/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.util;

import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.TimestampIterator;
import androidx.media3.common.util.UnstableApi;

@UnstableApi
public final class ConstantRateTimestampIterator
implements TimestampIterator {
    private final long durationUs;
    private final float frameRate;
    private final double framesDurationUs;
    private double currentTimestampUs;
    private int framesToAdd;

    public ConstantRateTimestampIterator(@IntRange(from=1L) long durationUs, @FloatRange(from=0.0, fromInclusive=false) float frameRate) {
        Assertions.checkArgument(durationUs > 0L);
        Assertions.checkArgument(frameRate > 0.0f);
        this.durationUs = durationUs;
        this.frameRate = frameRate;
        this.framesToAdd = Math.round(frameRate * ((float)durationUs / 1000000.0f));
        this.framesDurationUs = 1000000.0f / frameRate;
    }

    @Override
    public boolean hasNext() {
        return this.framesToAdd != 0;
    }

    @Override
    public long next() {
        Assertions.checkState(this.hasNext());
        --this.framesToAdd;
        long next = Math.round(this.currentTimestampUs);
        this.currentTimestampUs += this.framesDurationUs;
        return next;
    }

    @Override
    public ConstantRateTimestampIterator copyOf() {
        return new ConstantRateTimestampIterator(this.durationUs, this.frameRate);
    }
}

