/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.content.Context;
import android.graphics.Point;
import android.os.Bundle;
import android.os.Looper;
import android.view.accessibility.CaptioningManager;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.Bundleable;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.TrackSelectionOverride;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.BundleableUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public class TrackSelectionParameters
implements Bundleable {
    @UnstableApi
    public static final TrackSelectionParameters DEFAULT_WITHOUT_CONTEXT;
    @Deprecated
    @UnstableApi
    public static final TrackSelectionParameters DEFAULT;
    public final int maxVideoWidth;
    public final int maxVideoHeight;
    public final int maxVideoFrameRate;
    public final int maxVideoBitrate;
    public final int minVideoWidth;
    public final int minVideoHeight;
    public final int minVideoFrameRate;
    public final int minVideoBitrate;
    public final int viewportWidth;
    public final int viewportHeight;
    public final boolean viewportOrientationMayChange;
    public final ImmutableList<String> preferredVideoMimeTypes;
    public final int preferredVideoRoleFlags;
    public final ImmutableList<String> preferredAudioLanguages;
    public final int preferredAudioRoleFlags;
    public final int maxAudioChannelCount;
    public final int maxAudioBitrate;
    public final ImmutableList<String> preferredAudioMimeTypes;
    @UnstableApi
    public final AudioOffloadPreferences audioOffloadPreferences;
    public final ImmutableList<String> preferredTextLanguages;
    public final int preferredTextRoleFlags;
    public final int ignoredTextSelectionFlags;
    public final boolean selectUndeterminedTextLanguage;
    public final boolean forceLowestBitrate;
    public final boolean forceHighestSupportedBitrate;
    public final ImmutableMap<TrackGroup, TrackSelectionOverride> overrides;
    public final ImmutableSet<Integer> disabledTrackTypes;
    private static final String FIELD_PREFERRED_AUDIO_LANGUAGES;
    private static final String FIELD_PREFERRED_AUDIO_ROLE_FLAGS;
    private static final String FIELD_PREFERRED_TEXT_LANGUAGES;
    private static final String FIELD_PREFERRED_TEXT_ROLE_FLAGS;
    private static final String FIELD_SELECT_UNDETERMINED_TEXT_LANGUAGE;
    private static final String FIELD_MAX_VIDEO_WIDTH;
    private static final String FIELD_MAX_VIDEO_HEIGHT;
    private static final String FIELD_MAX_VIDEO_FRAMERATE;
    private static final String FIELD_MAX_VIDEO_BITRATE;
    private static final String FIELD_MIN_VIDEO_WIDTH;
    private static final String FIELD_MIN_VIDEO_HEIGHT;
    private static final String FIELD_MIN_VIDEO_FRAMERATE;
    private static final String FIELD_MIN_VIDEO_BITRATE;
    private static final String FIELD_VIEWPORT_WIDTH;
    private static final String FIELD_VIEWPORT_HEIGHT;
    private static final String FIELD_VIEWPORT_ORIENTATION_MAY_CHANGE;
    private static final String FIELD_PREFERRED_VIDEO_MIMETYPES;
    private static final String FIELD_MAX_AUDIO_CHANNEL_COUNT;
    private static final String FIELD_MAX_AUDIO_BITRATE;
    private static final String FIELD_PREFERRED_AUDIO_MIME_TYPES;
    private static final String FIELD_FORCE_LOWEST_BITRATE;
    private static final String FIELD_FORCE_HIGHEST_SUPPORTED_BITRATE;
    private static final String FIELD_SELECTION_OVERRIDES;
    private static final String FIELD_DISABLED_TRACK_TYPE;
    private static final String FIELD_PREFERRED_VIDEO_ROLE_FLAGS;
    private static final String FIELD_IGNORED_TEXT_SELECTION_FLAGS;
    private static final String FIELD_AUDIO_OFFLOAD_MODE_PREFERENCE;
    private static final String FIELD_IS_GAPLESS_SUPPORT_REQUIRED;
    private static final String FIELD_IS_SPEED_CHANGE_SUPPORT_REQUIRED;
    private static final String FIELD_AUDIO_OFFLOAD_PREFERENCES;
    @UnstableApi
    protected static final int FIELD_CUSTOM_ID_BASE = 1000;
    @Deprecated
    @UnstableApi
    public static final Bundleable.Creator<TrackSelectionParameters> CREATOR;

    public static TrackSelectionParameters getDefaults(Context context) {
        return new Builder(context).build();
    }

    @UnstableApi
    protected TrackSelectionParameters(Builder builder) {
        this.maxVideoWidth = builder.maxVideoWidth;
        this.maxVideoHeight = builder.maxVideoHeight;
        this.maxVideoFrameRate = builder.maxVideoFrameRate;
        this.maxVideoBitrate = builder.maxVideoBitrate;
        this.minVideoWidth = builder.minVideoWidth;
        this.minVideoHeight = builder.minVideoHeight;
        this.minVideoFrameRate = builder.minVideoFrameRate;
        this.minVideoBitrate = builder.minVideoBitrate;
        this.viewportWidth = builder.viewportWidth;
        this.viewportHeight = builder.viewportHeight;
        this.viewportOrientationMayChange = builder.viewportOrientationMayChange;
        this.preferredVideoMimeTypes = builder.preferredVideoMimeTypes;
        this.preferredVideoRoleFlags = builder.preferredVideoRoleFlags;
        this.preferredAudioLanguages = builder.preferredAudioLanguages;
        this.preferredAudioRoleFlags = builder.preferredAudioRoleFlags;
        this.maxAudioChannelCount = builder.maxAudioChannelCount;
        this.maxAudioBitrate = builder.maxAudioBitrate;
        this.preferredAudioMimeTypes = builder.preferredAudioMimeTypes;
        this.audioOffloadPreferences = builder.audioOffloadPreferences;
        this.preferredTextLanguages = builder.preferredTextLanguages;
        this.preferredTextRoleFlags = builder.preferredTextRoleFlags;
        this.ignoredTextSelectionFlags = builder.ignoredTextSelectionFlags;
        this.selectUndeterminedTextLanguage = builder.selectUndeterminedTextLanguage;
        this.forceLowestBitrate = builder.forceLowestBitrate;
        this.forceHighestSupportedBitrate = builder.forceHighestSupportedBitrate;
        this.overrides = ImmutableMap.copyOf((Map)builder.overrides);
        this.disabledTrackTypes = ImmutableSet.copyOf((Collection)builder.disabledTrackTypes);
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrackSelectionParameters other = (TrackSelectionParameters)obj;
        return this.maxVideoWidth == other.maxVideoWidth && this.maxVideoHeight == other.maxVideoHeight && this.maxVideoFrameRate == other.maxVideoFrameRate && this.maxVideoBitrate == other.maxVideoBitrate && this.minVideoWidth == other.minVideoWidth && this.minVideoHeight == other.minVideoHeight && this.minVideoFrameRate == other.minVideoFrameRate && this.minVideoBitrate == other.minVideoBitrate && this.viewportOrientationMayChange == other.viewportOrientationMayChange && this.viewportWidth == other.viewportWidth && this.viewportHeight == other.viewportHeight && this.preferredVideoMimeTypes.equals(other.preferredVideoMimeTypes) && this.preferredVideoRoleFlags == other.preferredVideoRoleFlags && this.preferredAudioLanguages.equals(other.preferredAudioLanguages) && this.preferredAudioRoleFlags == other.preferredAudioRoleFlags && this.maxAudioChannelCount == other.maxAudioChannelCount && this.maxAudioBitrate == other.maxAudioBitrate && this.preferredAudioMimeTypes.equals(other.preferredAudioMimeTypes) && this.audioOffloadPreferences.equals(other.audioOffloadPreferences) && this.preferredTextLanguages.equals(other.preferredTextLanguages) && this.preferredTextRoleFlags == other.preferredTextRoleFlags && this.ignoredTextSelectionFlags == other.ignoredTextSelectionFlags && this.selectUndeterminedTextLanguage == other.selectUndeterminedTextLanguage && this.forceLowestBitrate == other.forceLowestBitrate && this.forceHighestSupportedBitrate == other.forceHighestSupportedBitrate && this.overrides.equals(other.overrides) && this.disabledTrackTypes.equals(other.disabledTrackTypes);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.maxVideoWidth;
        result = 31 * result + this.maxVideoHeight;
        result = 31 * result + this.maxVideoFrameRate;
        result = 31 * result + this.maxVideoBitrate;
        result = 31 * result + this.minVideoWidth;
        result = 31 * result + this.minVideoHeight;
        result = 31 * result + this.minVideoFrameRate;
        result = 31 * result + this.minVideoBitrate;
        result = 31 * result + (this.viewportOrientationMayChange ? 1 : 0);
        result = 31 * result + this.viewportWidth;
        result = 31 * result + this.viewportHeight;
        result = 31 * result + this.preferredVideoMimeTypes.hashCode();
        result = 31 * result + this.preferredVideoRoleFlags;
        result = 31 * result + this.preferredAudioLanguages.hashCode();
        result = 31 * result + this.preferredAudioRoleFlags;
        result = 31 * result + this.maxAudioChannelCount;
        result = 31 * result + this.maxAudioBitrate;
        result = 31 * result + this.preferredAudioMimeTypes.hashCode();
        result = 31 * result + this.audioOffloadPreferences.hashCode();
        result = 31 * result + this.preferredTextLanguages.hashCode();
        result = 31 * result + this.preferredTextRoleFlags;
        result = 31 * result + this.ignoredTextSelectionFlags;
        result = 31 * result + (this.selectUndeterminedTextLanguage ? 1 : 0);
        result = 31 * result + (this.forceLowestBitrate ? 1 : 0);
        result = 31 * result + (this.forceHighestSupportedBitrate ? 1 : 0);
        result = 31 * result + this.overrides.hashCode();
        result = 31 * result + this.disabledTrackTypes.hashCode();
        return result;
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt(FIELD_MAX_VIDEO_WIDTH, this.maxVideoWidth);
        bundle.putInt(FIELD_MAX_VIDEO_HEIGHT, this.maxVideoHeight);
        bundle.putInt(FIELD_MAX_VIDEO_FRAMERATE, this.maxVideoFrameRate);
        bundle.putInt(FIELD_MAX_VIDEO_BITRATE, this.maxVideoBitrate);
        bundle.putInt(FIELD_MIN_VIDEO_WIDTH, this.minVideoWidth);
        bundle.putInt(FIELD_MIN_VIDEO_HEIGHT, this.minVideoHeight);
        bundle.putInt(FIELD_MIN_VIDEO_FRAMERATE, this.minVideoFrameRate);
        bundle.putInt(FIELD_MIN_VIDEO_BITRATE, this.minVideoBitrate);
        bundle.putInt(FIELD_VIEWPORT_WIDTH, this.viewportWidth);
        bundle.putInt(FIELD_VIEWPORT_HEIGHT, this.viewportHeight);
        bundle.putBoolean(FIELD_VIEWPORT_ORIENTATION_MAY_CHANGE, this.viewportOrientationMayChange);
        bundle.putStringArray(FIELD_PREFERRED_VIDEO_MIMETYPES, (String[])this.preferredVideoMimeTypes.toArray((Object[])new String[0]));
        bundle.putInt(FIELD_PREFERRED_VIDEO_ROLE_FLAGS, this.preferredVideoRoleFlags);
        bundle.putStringArray(FIELD_PREFERRED_AUDIO_LANGUAGES, (String[])this.preferredAudioLanguages.toArray((Object[])new String[0]));
        bundle.putInt(FIELD_PREFERRED_AUDIO_ROLE_FLAGS, this.preferredAudioRoleFlags);
        bundle.putInt(FIELD_MAX_AUDIO_CHANNEL_COUNT, this.maxAudioChannelCount);
        bundle.putInt(FIELD_MAX_AUDIO_BITRATE, this.maxAudioBitrate);
        bundle.putStringArray(FIELD_PREFERRED_AUDIO_MIME_TYPES, (String[])this.preferredAudioMimeTypes.toArray((Object[])new String[0]));
        bundle.putStringArray(FIELD_PREFERRED_TEXT_LANGUAGES, (String[])this.preferredTextLanguages.toArray((Object[])new String[0]));
        bundle.putInt(FIELD_PREFERRED_TEXT_ROLE_FLAGS, this.preferredTextRoleFlags);
        bundle.putInt(FIELD_IGNORED_TEXT_SELECTION_FLAGS, this.ignoredTextSelectionFlags);
        bundle.putBoolean(FIELD_SELECT_UNDETERMINED_TEXT_LANGUAGE, this.selectUndeterminedTextLanguage);
        bundle.putInt(FIELD_AUDIO_OFFLOAD_MODE_PREFERENCE, this.audioOffloadPreferences.audioOffloadMode);
        bundle.putBoolean(FIELD_IS_GAPLESS_SUPPORT_REQUIRED, this.audioOffloadPreferences.isGaplessSupportRequired);
        bundle.putBoolean(FIELD_IS_SPEED_CHANGE_SUPPORT_REQUIRED, this.audioOffloadPreferences.isSpeedChangeSupportRequired);
        bundle.putBundle(FIELD_AUDIO_OFFLOAD_PREFERENCES, this.audioOffloadPreferences.toBundle());
        bundle.putBoolean(FIELD_FORCE_LOWEST_BITRATE, this.forceLowestBitrate);
        bundle.putBoolean(FIELD_FORCE_HIGHEST_SUPPORTED_BITRATE, this.forceHighestSupportedBitrate);
        bundle.putParcelableArrayList(FIELD_SELECTION_OVERRIDES, BundleableUtil.toBundleArrayList(this.overrides.values()));
        bundle.putIntArray(FIELD_DISABLED_TRACK_TYPE, Ints.toArray(this.disabledTrackTypes));
        return bundle;
    }

    public static TrackSelectionParameters fromBundle(Bundle bundle) {
        return new Builder(bundle).build();
    }

    static {
        DEFAULT = DEFAULT_WITHOUT_CONTEXT = new Builder().build();
        FIELD_PREFERRED_AUDIO_LANGUAGES = Util.intToStringMaxRadix(1);
        FIELD_PREFERRED_AUDIO_ROLE_FLAGS = Util.intToStringMaxRadix(2);
        FIELD_PREFERRED_TEXT_LANGUAGES = Util.intToStringMaxRadix(3);
        FIELD_PREFERRED_TEXT_ROLE_FLAGS = Util.intToStringMaxRadix(4);
        FIELD_SELECT_UNDETERMINED_TEXT_LANGUAGE = Util.intToStringMaxRadix(5);
        FIELD_MAX_VIDEO_WIDTH = Util.intToStringMaxRadix(6);
        FIELD_MAX_VIDEO_HEIGHT = Util.intToStringMaxRadix(7);
        FIELD_MAX_VIDEO_FRAMERATE = Util.intToStringMaxRadix(8);
        FIELD_MAX_VIDEO_BITRATE = Util.intToStringMaxRadix(9);
        FIELD_MIN_VIDEO_WIDTH = Util.intToStringMaxRadix(10);
        FIELD_MIN_VIDEO_HEIGHT = Util.intToStringMaxRadix(11);
        FIELD_MIN_VIDEO_FRAMERATE = Util.intToStringMaxRadix(12);
        FIELD_MIN_VIDEO_BITRATE = Util.intToStringMaxRadix(13);
        FIELD_VIEWPORT_WIDTH = Util.intToStringMaxRadix(14);
        FIELD_VIEWPORT_HEIGHT = Util.intToStringMaxRadix(15);
        FIELD_VIEWPORT_ORIENTATION_MAY_CHANGE = Util.intToStringMaxRadix(16);
        FIELD_PREFERRED_VIDEO_MIMETYPES = Util.intToStringMaxRadix(17);
        FIELD_MAX_AUDIO_CHANNEL_COUNT = Util.intToStringMaxRadix(18);
        FIELD_MAX_AUDIO_BITRATE = Util.intToStringMaxRadix(19);
        FIELD_PREFERRED_AUDIO_MIME_TYPES = Util.intToStringMaxRadix(20);
        FIELD_FORCE_LOWEST_BITRATE = Util.intToStringMaxRadix(21);
        FIELD_FORCE_HIGHEST_SUPPORTED_BITRATE = Util.intToStringMaxRadix(22);
        FIELD_SELECTION_OVERRIDES = Util.intToStringMaxRadix(23);
        FIELD_DISABLED_TRACK_TYPE = Util.intToStringMaxRadix(24);
        FIELD_PREFERRED_VIDEO_ROLE_FLAGS = Util.intToStringMaxRadix(25);
        FIELD_IGNORED_TEXT_SELECTION_FLAGS = Util.intToStringMaxRadix(26);
        FIELD_AUDIO_OFFLOAD_MODE_PREFERENCE = Util.intToStringMaxRadix(27);
        FIELD_IS_GAPLESS_SUPPORT_REQUIRED = Util.intToStringMaxRadix(28);
        FIELD_IS_SPEED_CHANGE_SUPPORT_REQUIRED = Util.intToStringMaxRadix(29);
        FIELD_AUDIO_OFFLOAD_PREFERENCES = Util.intToStringMaxRadix(30);
        CREATOR = TrackSelectionParameters::fromBundle;
    }

    public static class Builder {
        private int maxVideoWidth;
        private int maxVideoHeight;
        private int maxVideoFrameRate;
        private int maxVideoBitrate;
        private int minVideoWidth;
        private int minVideoHeight;
        private int minVideoFrameRate;
        private int minVideoBitrate;
        private int viewportWidth;
        private int viewportHeight;
        private boolean viewportOrientationMayChange;
        private ImmutableList<String> preferredVideoMimeTypes;
        private int preferredVideoRoleFlags;
        private ImmutableList<String> preferredAudioLanguages;
        private int preferredAudioRoleFlags;
        private int maxAudioChannelCount;
        private int maxAudioBitrate;
        private ImmutableList<String> preferredAudioMimeTypes;
        private AudioOffloadPreferences audioOffloadPreferences;
        private ImmutableList<String> preferredTextLanguages;
        private int preferredTextRoleFlags;
        private int ignoredTextSelectionFlags;
        private boolean selectUndeterminedTextLanguage;
        private boolean forceLowestBitrate;
        private boolean forceHighestSupportedBitrate;
        private HashMap<TrackGroup, TrackSelectionOverride> overrides;
        private HashSet<Integer> disabledTrackTypes;

        @Deprecated
        @UnstableApi
        public Builder() {
            this.maxVideoWidth = Integer.MAX_VALUE;
            this.maxVideoHeight = Integer.MAX_VALUE;
            this.maxVideoFrameRate = Integer.MAX_VALUE;
            this.maxVideoBitrate = Integer.MAX_VALUE;
            this.viewportWidth = Integer.MAX_VALUE;
            this.viewportHeight = Integer.MAX_VALUE;
            this.viewportOrientationMayChange = true;
            this.preferredVideoMimeTypes = ImmutableList.of();
            this.preferredVideoRoleFlags = 0;
            this.preferredAudioLanguages = ImmutableList.of();
            this.preferredAudioRoleFlags = 0;
            this.maxAudioChannelCount = Integer.MAX_VALUE;
            this.maxAudioBitrate = Integer.MAX_VALUE;
            this.preferredAudioMimeTypes = ImmutableList.of();
            this.audioOffloadPreferences = AudioOffloadPreferences.DEFAULT;
            this.preferredTextLanguages = ImmutableList.of();
            this.preferredTextRoleFlags = 0;
            this.ignoredTextSelectionFlags = 0;
            this.selectUndeterminedTextLanguage = false;
            this.forceLowestBitrate = false;
            this.forceHighestSupportedBitrate = false;
            this.overrides = new HashMap();
            this.disabledTrackTypes = new HashSet();
        }

        public Builder(Context context) {
            this();
            this.setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(context);
            this.setViewportSizeToPhysicalDisplaySize(context, true);
        }

        @UnstableApi
        protected Builder(TrackSelectionParameters initialValues) {
            this.init(initialValues);
        }

        @UnstableApi
        protected Builder(Bundle bundle) {
            this.maxVideoWidth = bundle.getInt(FIELD_MAX_VIDEO_WIDTH, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.maxVideoWidth);
            this.maxVideoHeight = bundle.getInt(FIELD_MAX_VIDEO_HEIGHT, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.maxVideoHeight);
            this.maxVideoFrameRate = bundle.getInt(FIELD_MAX_VIDEO_FRAMERATE, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.maxVideoFrameRate);
            this.maxVideoBitrate = bundle.getInt(FIELD_MAX_VIDEO_BITRATE, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.maxVideoBitrate);
            this.minVideoWidth = bundle.getInt(FIELD_MIN_VIDEO_WIDTH, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.minVideoWidth);
            this.minVideoHeight = bundle.getInt(FIELD_MIN_VIDEO_HEIGHT, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.minVideoHeight);
            this.minVideoFrameRate = bundle.getInt(FIELD_MIN_VIDEO_FRAMERATE, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.minVideoFrameRate);
            this.minVideoBitrate = bundle.getInt(FIELD_MIN_VIDEO_BITRATE, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.minVideoBitrate);
            this.viewportWidth = bundle.getInt(FIELD_VIEWPORT_WIDTH, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.viewportWidth);
            this.viewportHeight = bundle.getInt(FIELD_VIEWPORT_HEIGHT, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.viewportHeight);
            this.viewportOrientationMayChange = bundle.getBoolean(FIELD_VIEWPORT_ORIENTATION_MAY_CHANGE, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.viewportOrientationMayChange);
            this.preferredVideoMimeTypes = ImmutableList.copyOf((Object[])((String[])MoreObjects.firstNonNull((Object)bundle.getStringArray(FIELD_PREFERRED_VIDEO_MIMETYPES), (Object)new String[0])));
            this.preferredVideoRoleFlags = bundle.getInt(FIELD_PREFERRED_VIDEO_ROLE_FLAGS, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.preferredVideoRoleFlags);
            String[] preferredAudioLanguages1 = (String[])MoreObjects.firstNonNull((Object)bundle.getStringArray(FIELD_PREFERRED_AUDIO_LANGUAGES), (Object)new String[0]);
            this.preferredAudioLanguages = Builder.normalizeLanguageCodes(preferredAudioLanguages1);
            this.preferredAudioRoleFlags = bundle.getInt(FIELD_PREFERRED_AUDIO_ROLE_FLAGS, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.preferredAudioRoleFlags);
            this.maxAudioChannelCount = bundle.getInt(FIELD_MAX_AUDIO_CHANNEL_COUNT, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.maxAudioChannelCount);
            this.maxAudioBitrate = bundle.getInt(FIELD_MAX_AUDIO_BITRATE, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.maxAudioBitrate);
            this.preferredAudioMimeTypes = ImmutableList.copyOf((Object[])((String[])MoreObjects.firstNonNull((Object)bundle.getStringArray(FIELD_PREFERRED_AUDIO_MIME_TYPES), (Object)new String[0])));
            this.audioOffloadPreferences = Builder.getAudioOffloadPreferencesFromBundle(bundle);
            this.preferredTextLanguages = Builder.normalizeLanguageCodes((String[])MoreObjects.firstNonNull((Object)bundle.getStringArray(FIELD_PREFERRED_TEXT_LANGUAGES), (Object)new String[0]));
            this.preferredTextRoleFlags = bundle.getInt(FIELD_PREFERRED_TEXT_ROLE_FLAGS, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.preferredTextRoleFlags);
            this.ignoredTextSelectionFlags = bundle.getInt(FIELD_IGNORED_TEXT_SELECTION_FLAGS, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.ignoredTextSelectionFlags);
            this.selectUndeterminedTextLanguage = bundle.getBoolean(FIELD_SELECT_UNDETERMINED_TEXT_LANGUAGE, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.selectUndeterminedTextLanguage);
            this.forceLowestBitrate = bundle.getBoolean(FIELD_FORCE_LOWEST_BITRATE, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.forceLowestBitrate);
            this.forceHighestSupportedBitrate = bundle.getBoolean(FIELD_FORCE_HIGHEST_SUPPORTED_BITRATE, TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.forceHighestSupportedBitrate);
            ArrayList overrideBundleList = bundle.getParcelableArrayList(FIELD_SELECTION_OVERRIDES);
            ImmutableList<TrackSelectionOverride> overrideList = overrideBundleList == null ? ImmutableList.of() : BundleableUtil.fromBundleList(TrackSelectionOverride.CREATOR, overrideBundleList);
            this.overrides = new HashMap();
            for (int i = 0; i < overrideList.size(); ++i) {
                TrackSelectionOverride override = (TrackSelectionOverride)overrideList.get(i);
                this.overrides.put(override.mediaTrackGroup, override);
            }
            int[] disabledTrackTypeArray = (int[])MoreObjects.firstNonNull((Object)bundle.getIntArray(FIELD_DISABLED_TRACK_TYPE), (Object)new int[0]);
            this.disabledTrackTypes = new HashSet();
            for (int disabledTrackType : disabledTrackTypeArray) {
                this.disabledTrackTypes.add(disabledTrackType);
            }
        }

        private static AudioOffloadPreferences getAudioOffloadPreferencesFromBundle(Bundle bundle) {
            Bundle audioOffloadPreferencesBundle = bundle.getBundle(FIELD_AUDIO_OFFLOAD_PREFERENCES);
            return audioOffloadPreferencesBundle != null ? AudioOffloadPreferences.fromBundle(audioOffloadPreferencesBundle) : new AudioOffloadPreferences.Builder().setAudioOffloadMode(bundle.getInt(FIELD_AUDIO_OFFLOAD_MODE_PREFERENCE, AudioOffloadPreferences.DEFAULT.audioOffloadMode)).setIsGaplessSupportRequired(bundle.getBoolean(FIELD_IS_GAPLESS_SUPPORT_REQUIRED, AudioOffloadPreferences.DEFAULT.isGaplessSupportRequired)).setIsSpeedChangeSupportRequired(bundle.getBoolean(FIELD_IS_SPEED_CHANGE_SUPPORT_REQUIRED, AudioOffloadPreferences.DEFAULT.isSpeedChangeSupportRequired)).build();
        }

        @EnsuresNonNull(value={"preferredVideoMimeTypes", "preferredAudioLanguages", "preferredAudioMimeTypes", "audioOffloadPreferences", "preferredTextLanguages", "overrides", "disabledTrackTypes"})
        private void init(@UnknownInitialization Builder this, TrackSelectionParameters parameters) {
            this.maxVideoWidth = parameters.maxVideoWidth;
            this.maxVideoHeight = parameters.maxVideoHeight;
            this.maxVideoFrameRate = parameters.maxVideoFrameRate;
            this.maxVideoBitrate = parameters.maxVideoBitrate;
            this.minVideoWidth = parameters.minVideoWidth;
            this.minVideoHeight = parameters.minVideoHeight;
            this.minVideoFrameRate = parameters.minVideoFrameRate;
            this.minVideoBitrate = parameters.minVideoBitrate;
            this.viewportWidth = parameters.viewportWidth;
            this.viewportHeight = parameters.viewportHeight;
            this.viewportOrientationMayChange = parameters.viewportOrientationMayChange;
            this.preferredVideoMimeTypes = parameters.preferredVideoMimeTypes;
            this.preferredVideoRoleFlags = parameters.preferredVideoRoleFlags;
            this.preferredAudioLanguages = parameters.preferredAudioLanguages;
            this.preferredAudioRoleFlags = parameters.preferredAudioRoleFlags;
            this.maxAudioChannelCount = parameters.maxAudioChannelCount;
            this.maxAudioBitrate = parameters.maxAudioBitrate;
            this.preferredAudioMimeTypes = parameters.preferredAudioMimeTypes;
            this.audioOffloadPreferences = parameters.audioOffloadPreferences;
            this.preferredTextLanguages = parameters.preferredTextLanguages;
            this.preferredTextRoleFlags = parameters.preferredTextRoleFlags;
            this.ignoredTextSelectionFlags = parameters.ignoredTextSelectionFlags;
            this.selectUndeterminedTextLanguage = parameters.selectUndeterminedTextLanguage;
            this.forceLowestBitrate = parameters.forceLowestBitrate;
            this.forceHighestSupportedBitrate = parameters.forceHighestSupportedBitrate;
            this.disabledTrackTypes = new HashSet<Integer>((Collection<Integer>)parameters.disabledTrackTypes);
            this.overrides = new HashMap<TrackGroup, TrackSelectionOverride>((Map<TrackGroup, TrackSelectionOverride>)parameters.overrides);
        }

        @CanIgnoreReturnValue
        @UnstableApi
        protected Builder set(TrackSelectionParameters parameters) {
            this.init(parameters);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxVideoSizeSd() {
            return this.setMaxVideoSize(1279, 719);
        }

        @CanIgnoreReturnValue
        public Builder clearVideoSizeConstraints() {
            return this.setMaxVideoSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @CanIgnoreReturnValue
        public Builder setMaxVideoSize(int maxVideoWidth, int maxVideoHeight) {
            this.maxVideoWidth = maxVideoWidth;
            this.maxVideoHeight = maxVideoHeight;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxVideoFrameRate(int maxVideoFrameRate) {
            this.maxVideoFrameRate = maxVideoFrameRate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxVideoBitrate(int maxVideoBitrate) {
            this.maxVideoBitrate = maxVideoBitrate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMinVideoSize(int minVideoWidth, int minVideoHeight) {
            this.minVideoWidth = minVideoWidth;
            this.minVideoHeight = minVideoHeight;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMinVideoFrameRate(int minVideoFrameRate) {
            this.minVideoFrameRate = minVideoFrameRate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMinVideoBitrate(int minVideoBitrate) {
            this.minVideoBitrate = minVideoBitrate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setViewportSizeToPhysicalDisplaySize(Context context, boolean viewportOrientationMayChange) {
            Point viewportSize = Util.getCurrentDisplayModeSize(context);
            return this.setViewportSize(viewportSize.x, viewportSize.y, viewportOrientationMayChange);
        }

        @CanIgnoreReturnValue
        public Builder clearViewportSizeConstraints() {
            return this.setViewportSize(Integer.MAX_VALUE, Integer.MAX_VALUE, true);
        }

        @CanIgnoreReturnValue
        public Builder setViewportSize(int viewportWidth, int viewportHeight, boolean viewportOrientationMayChange) {
            this.viewportWidth = viewportWidth;
            this.viewportHeight = viewportHeight;
            this.viewportOrientationMayChange = viewportOrientationMayChange;
            return this;
        }

        public Builder setPreferredVideoMimeType(@Nullable String mimeType) {
            return mimeType == null ? this.setPreferredVideoMimeTypes(new String[0]) : this.setPreferredVideoMimeTypes(mimeType);
        }

        @CanIgnoreReturnValue
        public Builder setPreferredVideoMimeTypes(String ... mimeTypes) {
            this.preferredVideoMimeTypes = ImmutableList.copyOf((Object[])mimeTypes);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPreferredVideoRoleFlags(int preferredVideoRoleFlags) {
            this.preferredVideoRoleFlags = preferredVideoRoleFlags;
            return this;
        }

        public Builder setPreferredAudioLanguage(@Nullable String preferredAudioLanguage) {
            return preferredAudioLanguage == null ? this.setPreferredAudioLanguages(new String[0]) : this.setPreferredAudioLanguages(preferredAudioLanguage);
        }

        @CanIgnoreReturnValue
        public Builder setPreferredAudioLanguages(String ... preferredAudioLanguages) {
            this.preferredAudioLanguages = Builder.normalizeLanguageCodes(preferredAudioLanguages);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPreferredAudioRoleFlags(int preferredAudioRoleFlags) {
            this.preferredAudioRoleFlags = preferredAudioRoleFlags;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxAudioChannelCount(int maxAudioChannelCount) {
            this.maxAudioChannelCount = maxAudioChannelCount;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxAudioBitrate(int maxAudioBitrate) {
            this.maxAudioBitrate = maxAudioBitrate;
            return this;
        }

        public Builder setPreferredAudioMimeType(@Nullable String mimeType) {
            return mimeType == null ? this.setPreferredAudioMimeTypes(new String[0]) : this.setPreferredAudioMimeTypes(mimeType);
        }

        @CanIgnoreReturnValue
        public Builder setPreferredAudioMimeTypes(String ... mimeTypes) {
            this.preferredAudioMimeTypes = ImmutableList.copyOf((Object[])mimeTypes);
            return this;
        }

        @UnstableApi
        @CanIgnoreReturnValue
        public Builder setAudioOffloadPreferences(AudioOffloadPreferences audioOffloadPreferences) {
            this.audioOffloadPreferences = audioOffloadPreferences;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(Context context) {
            if (Util.SDK_INT >= 19) {
                this.setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettingsV19(context);
            }
            return this;
        }

        public Builder setPreferredTextLanguage(@Nullable String preferredTextLanguage) {
            return preferredTextLanguage == null ? this.setPreferredTextLanguages(new String[0]) : this.setPreferredTextLanguages(preferredTextLanguage);
        }

        @CanIgnoreReturnValue
        public Builder setPreferredTextLanguages(String ... preferredTextLanguages) {
            this.preferredTextLanguages = Builder.normalizeLanguageCodes(preferredTextLanguages);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPreferredTextRoleFlags(int preferredTextRoleFlags) {
            this.preferredTextRoleFlags = preferredTextRoleFlags;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setIgnoredTextSelectionFlags(int ignoredTextSelectionFlags) {
            this.ignoredTextSelectionFlags = ignoredTextSelectionFlags;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSelectUndeterminedTextLanguage(boolean selectUndeterminedTextLanguage) {
            this.selectUndeterminedTextLanguage = selectUndeterminedTextLanguage;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setForceLowestBitrate(boolean forceLowestBitrate) {
            this.forceLowestBitrate = forceLowestBitrate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setForceHighestSupportedBitrate(boolean forceHighestSupportedBitrate) {
            this.forceHighestSupportedBitrate = forceHighestSupportedBitrate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addOverride(TrackSelectionOverride override) {
            this.overrides.put(override.mediaTrackGroup, override);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setOverrideForType(TrackSelectionOverride override) {
            this.clearOverridesOfType(override.getType());
            this.overrides.put(override.mediaTrackGroup, override);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clearOverride(TrackGroup mediaTrackGroup) {
            this.overrides.remove(mediaTrackGroup);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clearOverridesOfType(int trackType) {
            Iterator<TrackSelectionOverride> it = this.overrides.values().iterator();
            while (it.hasNext()) {
                TrackSelectionOverride override = it.next();
                if (override.getType() != trackType) continue;
                it.remove();
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clearOverrides() {
            this.overrides.clear();
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setDisabledTrackTypes(Set<Integer> disabledTrackTypes) {
            this.disabledTrackTypes.clear();
            this.disabledTrackTypes.addAll(disabledTrackTypes);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTrackTypeDisabled(int trackType, boolean disabled) {
            if (disabled) {
                this.disabledTrackTypes.add(trackType);
            } else {
                this.disabledTrackTypes.remove(trackType);
            }
            return this;
        }

        public TrackSelectionParameters build() {
            return new TrackSelectionParameters(this);
        }

        @RequiresApi(value=19)
        private void setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettingsV19(Context context) {
            if (Util.SDK_INT < 23 && Looper.myLooper() == null) {
                return;
            }
            CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
            if (captioningManager == null || !captioningManager.isEnabled()) {
                return;
            }
            this.preferredTextRoleFlags = 1088;
            Locale preferredLocale = captioningManager.getLocale();
            if (preferredLocale != null) {
                this.preferredTextLanguages = ImmutableList.of((Object)Util.getLocaleLanguageTag(preferredLocale));
            }
        }

        private static ImmutableList<String> normalizeLanguageCodes(String[] preferredTextLanguages) {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (String language : Assertions.checkNotNull(preferredTextLanguages)) {
                listBuilder.add((Object)Util.normalizeLanguageCode(Assertions.checkNotNull(language)));
            }
            return listBuilder.build();
        }
    }

    @UnstableApi
    public static final class AudioOffloadPreferences
    implements Bundleable {
        public static final int AUDIO_OFFLOAD_MODE_REQUIRED = 2;
        public static final int AUDIO_OFFLOAD_MODE_ENABLED = 1;
        public static final int AUDIO_OFFLOAD_MODE_DISABLED = 0;
        public static final AudioOffloadPreferences DEFAULT = new Builder().build();
        public final int audioOffloadMode;
        public final boolean isGaplessSupportRequired;
        public final boolean isSpeedChangeSupportRequired;
        private static final String FIELD_AUDIO_OFFLOAD_MODE_PREFERENCE = Util.intToStringMaxRadix(1);
        private static final String FIELD_IS_GAPLESS_SUPPORT_REQUIRED = Util.intToStringMaxRadix(2);
        private static final String FIELD_IS_SPEED_CHANGE_SUPPORT_REQUIRED = Util.intToStringMaxRadix(3);

        private AudioOffloadPreferences(Builder builder) {
            this.audioOffloadMode = builder.audioOffloadMode;
            this.isGaplessSupportRequired = builder.isGaplessSupportRequired;
            this.isSpeedChangeSupportRequired = builder.isSpeedChangeSupportRequired;
        }

        public Builder buildUpon() {
            return new Builder().setAudioOffloadMode(this.audioOffloadMode).setIsGaplessSupportRequired(this.isGaplessSupportRequired).setIsSpeedChangeSupportRequired(this.isSpeedChangeSupportRequired);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AudioOffloadPreferences other = (AudioOffloadPreferences)obj;
            return this.audioOffloadMode == other.audioOffloadMode && this.isGaplessSupportRequired == other.isGaplessSupportRequired && this.isSpeedChangeSupportRequired == other.isSpeedChangeSupportRequired;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.audioOffloadMode;
            result = 31 * result + (this.isGaplessSupportRequired ? 1 : 0);
            result = 31 * result + (this.isSpeedChangeSupportRequired ? 1 : 0);
            return result;
        }

        @Override
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putInt(FIELD_AUDIO_OFFLOAD_MODE_PREFERENCE, this.audioOffloadMode);
            bundle.putBoolean(FIELD_IS_GAPLESS_SUPPORT_REQUIRED, this.isGaplessSupportRequired);
            bundle.putBoolean(FIELD_IS_SPEED_CHANGE_SUPPORT_REQUIRED, this.isSpeedChangeSupportRequired);
            return bundle;
        }

        public static AudioOffloadPreferences fromBundle(Bundle bundle) {
            return new Builder().setAudioOffloadMode(bundle.getInt(FIELD_AUDIO_OFFLOAD_MODE_PREFERENCE, AudioOffloadPreferences.DEFAULT.audioOffloadMode)).setIsGaplessSupportRequired(bundle.getBoolean(FIELD_IS_GAPLESS_SUPPORT_REQUIRED, AudioOffloadPreferences.DEFAULT.isGaplessSupportRequired)).setIsSpeedChangeSupportRequired(bundle.getBoolean(FIELD_IS_SPEED_CHANGE_SUPPORT_REQUIRED, AudioOffloadPreferences.DEFAULT.isSpeedChangeSupportRequired)).build();
        }

        public static final class Builder {
            private int audioOffloadMode = 0;
            private boolean isGaplessSupportRequired = false;
            private boolean isSpeedChangeSupportRequired = false;

            @CanIgnoreReturnValue
            public Builder setAudioOffloadMode(int audioOffloadMode) {
                this.audioOffloadMode = audioOffloadMode;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setIsGaplessSupportRequired(boolean isGaplessSupportRequired) {
                this.isGaplessSupportRequired = isGaplessSupportRequired;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setIsSpeedChangeSupportRequired(boolean isSpeedChangeSupportRequired) {
                this.isSpeedChangeSupportRequired = isSpeedChangeSupportRequired;
                return this;
            }

            public AudioOffloadPreferences build() {
                return new AudioOffloadPreferences(this);
            }
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.TYPE_USE})
        public static @interface AudioOffloadMode {
        }
    }
}

