/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import android.app.Application;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModel;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a6\u0010\u0004\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00022\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001H\u0000\u001aI\u0010\t\u001a\u0002H\u0006\"\n\b\u0000\u0010\u0006*\u0004\u0018\u00010\n2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00052\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000eH\u0000\u00a2\u0006\u0002\u0010\u000f\"\u0018\u0010\u0000\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"ANDROID_VIEWMODEL_SIGNATURE", "", "Ljava/lang/Class;", "VIEWMODEL_SIGNATURE", "findMatchingConstructor", "Ljava/lang/reflect/Constructor;", "T", "modelClass", "signature", "newInstance", "Landroidx/lifecycle/ViewModel;", "constructor", "params", "", "", "(Ljava/lang/Class;Ljava/lang/reflect/Constructor;[Ljava/lang/Object;)Landroidx/lifecycle/ViewModel;", "lifecycle-viewmodel-savedstate_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class SavedStateViewModelFactoryKt {
    @NotNull
    private static final List<Class<?>> ANDROID_VIEWMODEL_SIGNATURE;
    @NotNull
    private static final List<Class<?>> VIEWMODEL_SIGNATURE;

    public static final <T extends ViewModel> T newInstance(@NotNull Class<T> modelClass, @NotNull Constructor<T> constructor, Object ... params) {
        ViewModel viewModel2;
        Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
        Intrinsics.checkNotNullParameter(constructor, (String)"constructor");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        try {
            viewModel2 = (ViewModel)constructor.newInstance(Arrays.copyOf(params, params.length));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to access " + modelClass, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("A " + modelClass + " cannot be instantiated.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("An exception happened in constructor of " + modelClass, e.getCause());
        }
        return (T)viewModel2;
    }

    @Nullable
    public static final <T> Constructor<T> findMatchingConstructor(@NotNull Class<T> modelClass, @NotNull List<? extends Class<?>> signature) {
        Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
        Intrinsics.checkNotNullParameter(signature, (String)"signature");
        Constructor<?>[] constructorArray = modelClass.getConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"modelClass.constructors");
        for (Constructor<?> constructor : constructorArray) {
            Class<?>[] classArray = constructor.getParameterTypes();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"constructor.parameterTypes");
            List parameterTypes = ArraysKt.toList((Object[])classArray);
            if (Intrinsics.areEqual(signature, (Object)parameterTypes)) {
                Intrinsics.checkNotNull(constructor, (String)"null cannot be cast to non-null type java.lang.reflect.Constructor<T of androidx.lifecycle.SavedStateViewModelFactoryKt.findMatchingConstructor>");
                return constructor;
            }
            if (signature.size() != parameterTypes.size() || !parameterTypes.containsAll((Collection)signature)) continue;
            throw new UnsupportedOperationException("Class " + modelClass.getSimpleName() + " must have parameters in the proper order: " + signature);
        }
        return null;
    }

    public static final /* synthetic */ List access$getANDROID_VIEWMODEL_SIGNATURE$p() {
        return ANDROID_VIEWMODEL_SIGNATURE;
    }

    public static final /* synthetic */ List access$getVIEWMODEL_SIGNATURE$p() {
        return VIEWMODEL_SIGNATURE;
    }

    static {
        Object[] objectArray = new Class[]{Application.class, SavedStateHandle.class};
        ANDROID_VIEWMODEL_SIGNATURE = CollectionsKt.listOf((Object[])objectArray);
        VIEWMODEL_SIGNATURE = CollectionsKt.listOf(SavedStateHandle.class);
    }
}

