/*
 * Decompiled with CFR 0.152.
 */
package androidx.databinding;

import androidx.annotation.NonNull;
import androidx.core.util.Pools;
import androidx.databinding.CallbackRegistry;
import androidx.databinding.ObservableList;

public class ListChangeRegistry
extends CallbackRegistry<ObservableList.OnListChangedCallback, ObservableList, ListChanges> {
    private static final Pools.SynchronizedPool<ListChanges> sListChanges = new Pools.SynchronizedPool(10);
    private static final int ALL = 0;
    private static final int CHANGED = 1;
    private static final int INSERTED = 2;
    private static final int MOVED = 3;
    private static final int REMOVED = 4;
    private static final CallbackRegistry.NotifierCallback<ObservableList.OnListChangedCallback, ObservableList, ListChanges> NOTIFIER_CALLBACK = new CallbackRegistry.NotifierCallback<ObservableList.OnListChangedCallback, ObservableList, ListChanges>(){

        public void onNotifyCallback(ObservableList.OnListChangedCallback callback, ObservableList sender, int notificationType, ListChanges listChanges) {
            switch (notificationType) {
                case 1: {
                    callback.onItemRangeChanged(sender, listChanges.start, listChanges.count);
                    break;
                }
                case 2: {
                    callback.onItemRangeInserted(sender, listChanges.start, listChanges.count);
                    break;
                }
                case 3: {
                    callback.onItemRangeMoved(sender, listChanges.start, listChanges.to, listChanges.count);
                    break;
                }
                case 4: {
                    callback.onItemRangeRemoved(sender, listChanges.start, listChanges.count);
                    break;
                }
                default: {
                    callback.onChanged(sender);
                }
            }
        }
    };

    public void notifyChanged(@NonNull ObservableList list) {
        this.notifyCallbacks(list, 0, null);
    }

    public void notifyChanged(@NonNull ObservableList list, int start, int count) {
        ListChanges listChanges = ListChangeRegistry.acquire(start, 0, count);
        this.notifyCallbacks(list, 1, listChanges);
    }

    public void notifyInserted(@NonNull ObservableList list, int start, int count) {
        ListChanges listChanges = ListChangeRegistry.acquire(start, 0, count);
        this.notifyCallbacks(list, 2, listChanges);
    }

    public void notifyMoved(@NonNull ObservableList list, int from, int to, int count) {
        ListChanges listChanges = ListChangeRegistry.acquire(from, to, count);
        this.notifyCallbacks(list, 3, listChanges);
    }

    public void notifyRemoved(@NonNull ObservableList list, int start, int count) {
        ListChanges listChanges = ListChangeRegistry.acquire(start, 0, count);
        this.notifyCallbacks(list, 4, listChanges);
    }

    private static ListChanges acquire(int start, int to, int count) {
        ListChanges listChanges = (ListChanges)sListChanges.acquire();
        if (listChanges == null) {
            listChanges = new ListChanges();
        }
        listChanges.start = start;
        listChanges.to = to;
        listChanges.count = count;
        return listChanges;
    }

    public synchronized void notifyCallbacks(@NonNull ObservableList sender, int notificationType, ListChanges listChanges) {
        super.notifyCallbacks((Object)sender, notificationType, (Object)listChanges);
        if (listChanges != null) {
            sListChanges.release((Object)listChanges);
        }
    }

    public ListChangeRegistry() {
        super(NOTIFIER_CALLBACK);
    }

    static class ListChanges {
        public int start;
        public int count;
        public int to;

        ListChanges() {
        }
    }
}

