/*
 * Decompiled with CFR 0.152.
 */
package androidx.databinding.adapters;

import android.annotation.TargetApi;
import android.os.Build;
import android.widget.SearchView;
import androidx.annotation.RestrictTo;
import androidx.databinding.BindingAdapter;
import androidx.databinding.BindingMethod;
import androidx.databinding.BindingMethods;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@BindingMethods(value={@BindingMethod(type=SearchView.class, attribute="android:onQueryTextFocusChange", method="setOnQueryTextFocusChangeListener"), @BindingMethod(type=SearchView.class, attribute="android:onSearchClick", method="setOnSearchClickListener"), @BindingMethod(type=SearchView.class, attribute="android:onClose", method="setOnCloseListener")})
public class SearchViewBindingAdapter {
    @BindingAdapter(value={"android:onQueryTextSubmit", "android:onQueryTextChange"}, requireAll=false)
    public static void setOnQueryTextListener(SearchView view, final OnQueryTextSubmit submit, final OnQueryTextChange change) {
        if (Build.VERSION.SDK_INT >= 11) {
            if (submit == null && change == null) {
                view.setOnQueryTextListener(null);
            } else {
                view.setOnQueryTextListener(new SearchView.OnQueryTextListener(){

                    public boolean onQueryTextSubmit(String query) {
                        if (submit != null) {
                            return submit.onQueryTextSubmit(query);
                        }
                        return false;
                    }

                    public boolean onQueryTextChange(String newText) {
                        if (change != null) {
                            return change.onQueryTextChange(newText);
                        }
                        return false;
                    }
                });
            }
        }
    }

    @BindingAdapter(value={"android:onSuggestionSelect", "android:onSuggestionClick"}, requireAll=false)
    public static void setOnSuggestListener(SearchView view, final OnSuggestionSelect submit, final OnSuggestionClick change) {
        if (Build.VERSION.SDK_INT >= 11) {
            if (submit == null && change == null) {
                view.setOnSuggestionListener(null);
            } else {
                view.setOnSuggestionListener(new SearchView.OnSuggestionListener(){

                    public boolean onSuggestionSelect(int position) {
                        if (submit != null) {
                            return submit.onSuggestionSelect(position);
                        }
                        return false;
                    }

                    public boolean onSuggestionClick(int position) {
                        if (change != null) {
                            return change.onSuggestionClick(position);
                        }
                        return false;
                    }
                });
            }
        }
    }

    @TargetApi(value=11)
    public static interface OnQueryTextSubmit {
        public boolean onQueryTextSubmit(String var1);
    }

    @TargetApi(value=11)
    public static interface OnQueryTextChange {
        public boolean onQueryTextChange(String var1);
    }

    @TargetApi(value=11)
    public static interface OnSuggestionSelect {
        public boolean onSuggestionSelect(int var1);
    }

    @TargetApi(value=11)
    public static interface OnSuggestionClick {
        public boolean onSuggestionClick(int var1);
    }
}

