/*
 * Decompiled with CFR 0.152.
 */
package androidx.databinding.adapters;

import android.view.View;
import android.widget.Adapter;
import android.widget.AdapterView;
import androidx.annotation.RestrictTo;
import androidx.databinding.BindingAdapter;
import androidx.databinding.BindingMethod;
import androidx.databinding.BindingMethods;
import androidx.databinding.InverseBindingListener;
import androidx.databinding.InverseBindingMethod;
import androidx.databinding.InverseBindingMethods;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@BindingMethods(value={@BindingMethod(type=AdapterView.class, attribute="android:onItemClick", method="setOnItemClickListener"), @BindingMethod(type=AdapterView.class, attribute="android:onItemLongClick", method="setOnItemLongClickListener")})
@InverseBindingMethods(value={@InverseBindingMethod(type=AdapterView.class, attribute="android:selectedItemPosition"), @InverseBindingMethod(type=AdapterView.class, attribute="android:selection", method="getSelectedItemPosition", event="android:selectedItemPositionAttrChanged")})
public class AdapterViewBindingAdapter {
    @BindingAdapter(value={"android:selectedItemPosition"})
    public static void setSelectedItemPosition(AdapterView view, int position) {
        if (view.getSelectedItemPosition() != position) {
            view.setSelection(position);
        }
    }

    @BindingAdapter(value={"android:selection"})
    public static void setSelection(AdapterView view, int position) {
        AdapterViewBindingAdapter.setSelectedItemPosition(view, position);
    }

    @BindingAdapter(value={"android:selectedItemPosition", "android:adapter"})
    public static void setSelectedItemPosition(AdapterView view, int position, Adapter adapter) {
        if (adapter != view.getAdapter()) {
            view.setAdapter(adapter);
            view.setSelection(position);
        } else if (view.getSelectedItemPosition() != position) {
            view.setSelection(position);
        }
    }

    @BindingAdapter(value={"android:selection", "android:adapter"})
    public static void setSelection(AdapterView view, int position, Adapter adapter) {
        AdapterViewBindingAdapter.setSelectedItemPosition(view, position, adapter);
    }

    @BindingAdapter(value={"android:onItemSelected", "android:onNothingSelected", "android:selectedItemPositionAttrChanged"}, requireAll=false)
    public static void setOnItemSelectedListener(AdapterView view, OnItemSelected selected, OnNothingSelected nothingSelected, InverseBindingListener attrChanged) {
        if (selected == null && nothingSelected == null && attrChanged == null) {
            view.setOnItemSelectedListener(null);
        } else {
            view.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)new OnItemSelectedComponentListener(selected, nothingSelected, attrChanged));
        }
    }

    public static interface OnNothingSelected {
        public void onNothingSelected(AdapterView<?> var1);
    }

    public static interface OnItemSelected {
        public void onItemSelected(AdapterView<?> var1, View var2, int var3, long var4);
    }

    public static class OnItemSelectedComponentListener
    implements AdapterView.OnItemSelectedListener {
        private final OnItemSelected mSelected;
        private final OnNothingSelected mNothingSelected;
        private final InverseBindingListener mAttrChanged;

        public OnItemSelectedComponentListener(OnItemSelected selected, OnNothingSelected nothingSelected, InverseBindingListener attrChanged) {
            this.mSelected = selected;
            this.mNothingSelected = nothingSelected;
            this.mAttrChanged = attrChanged;
        }

        public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
            if (this.mSelected != null) {
                this.mSelected.onItemSelected(parent, view, position, id2);
            }
            if (this.mAttrChanged != null) {
                this.mAttrChanged.onChange();
            }
        }

        public void onNothingSelected(AdapterView<?> parent) {
            if (this.mNothingSelected != null) {
                this.mNothingSelected.onNothingSelected(parent);
            }
            if (this.mAttrChanged != null) {
                this.mAttrChanged.onChange();
            }
        }
    }
}

