/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content.res;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import androidx.annotation.AnyRes;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.RequiresApi;
import androidx.annotation.StyleableRes;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0007\u001a\u00020\u0004*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\f\u001a\u00020\u0004*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0016\u0010\r\u001a\u00020\u0004*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0010\u001a\u00020\u000b*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0011\u001a\u00020\u0012*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0014\u0010\u0013\u001a\u00020\u0004*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0014\u001a\u00020\u0004*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0015\u001a\u00020\u0004*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u001a\u001f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001b\u001a\u0014\u0010\u001c\u001a\u00020\u001a*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u001a/\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e*\u00020\u00022\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u001e0 H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\""}, d2={"checkAttribute", "", "Landroid/content/res/TypedArray;", "index", "", "getBooleanOrThrow", "", "getColorOrThrow", "getColorStateListOrThrow", "Landroid/content/res/ColorStateList;", "getDimensionOrThrow", "", "getDimensionPixelOffsetOrThrow", "getDimensionPixelSizeOrThrow", "getDrawableOrThrow", "Landroid/graphics/drawable/Drawable;", "getFloatOrThrow", "getFontOrThrow", "Landroid/graphics/Typeface;", "getIntOrThrow", "getIntegerOrThrow", "getResourceIdOrThrow", "getStringOrThrow", "", "getTextArrayOrThrow", "", "", "(Landroid/content/res/TypedArray;I)[Ljava/lang/CharSequence;", "getTextOrThrow", "use", "R", "block", "Lkotlin/Function1;", "(Landroid/content/res/TypedArray;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "core-ktx_release"})
public final class TypedArrayKt {
    private static final void checkAttribute(TypedArray $this$checkAttribute, @StyleableRes int index) {
        if (!$this$checkAttribute.hasValue(index)) {
            throw new IllegalArgumentException("Attribute not defined in set.");
        }
    }

    public static final boolean getBooleanOrThrow(@NotNull TypedArray $this$getBooleanOrThrow, @StyleableRes int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getBooleanOrThrow, (String)"<this>");
        TypedArrayKt.checkAttribute($this$getBooleanOrThrow, index);
        return $this$getBooleanOrThrow.getBoolean(index, false);
    }

    @ColorInt
    public static final int getColorOrThrow(@NotNull TypedArray $this$getColorOrThrow, @StyleableRes int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getColorOrThrow, (String)"<this>");
        TypedArrayKt.checkAttribute($this$getColorOrThrow, index);
        return $this$getColorOrThrow.getColor(index, 0);
    }

    @NotNull
    public static final ColorStateList getColorStateListOrThrow(@NotNull TypedArray $this$getColorStateListOrThrow, @StyleableRes int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getColorStateListOrThrow, (String)"<this>");
        TypedArrayKt.checkAttribute($this$getColorStateListOrThrow, index);
        ColorStateList colorStateList = $this$getColorStateListOrThrow.getColorStateList(index);
        boolean bl = false;
        boolean bl2 = false;
        if (colorStateList == null) {
            boolean bl3 = false;
            String string = "Attribute value was not a color or color state list.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return colorStateList;
    }

    public static final float getDimensionOrThrow(@NotNull TypedArray $this$getDimensionOrThrow, @StyleableRes int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getDimensionOrThrow, (String)"<this>");
        TypedArrayKt.checkAttribute($this$getDimensionOrThrow, index);
        return $this$getDimensionOrThrow.getDimension(index, 0.0f);
    }

    @Dimension
    public static final int getDimensionPixelOffsetOrThrow(@NotNull TypedArray $this$getDimensionPixelOffsetOrThrow, @StyleableRes int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getDimensionPixelOffsetOrThrow, (String)"<this>");
        TypedArrayKt.checkAttribute($this$getDimensionPixelOffsetOrThrow, index);
        return $this$getDimensionPixelOffsetOrThrow.getDimensionPixelOffset(index, 0);
    }

    @Dimension
    public static final int getDimensionPixelSizeOrThrow(@NotNull TypedArray $this$getDimensionPixelSizeOrThrow, @StyleableRes int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getDimensionPixelSizeOrThrow, (String)"<this>");
        TypedArrayKt.checkAttribute($this$getDimensionPixelSizeOrThrow, index);
        return $this$getDimensionPixelSizeOrThrow.getDimensionPixelSize(index, 0);
    }

    @NotNull
    public static final Drawable getDrawableOrThrow(@NotNull TypedArray $this$getDrawableOrThrow, @StyleableRes int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getDrawableOrThrow, (String)"<this>");
        TypedArrayKt.checkAttribute($this$getDrawableOrThrow, index);
        Drawable drawable = $this$getDrawableOrThrow.getDrawable(index);
        Intrinsics.checkNotNull((Object)drawable);
        Drawable drawable2 = drawable;
        return drawable2;
    }

    public static final float getFloatOrThrow(@NotNull TypedArray $this$getFloatOrThrow, @StyleableRes int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getFloatOrThrow, (String)"<this>");
        TypedArrayKt.checkAttribute($this$getFloatOrThrow, index);
        return $this$getFloatOrThrow.getFloat(index, 0.0f);
    }

    @RequiresApi(value=26)
    @NotNull
    public static final Typeface getFontOrThrow(@NotNull TypedArray $this$getFontOrThrow, @StyleableRes int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getFontOrThrow, (String)"<this>");
        TypedArrayKt.checkAttribute($this$getFontOrThrow, index);
        Typeface typeface = $this$getFontOrThrow.getFont(index);
        Intrinsics.checkNotNull((Object)typeface);
        Typeface typeface2 = typeface;
        return typeface2;
    }

    public static final int getIntOrThrow(@NotNull TypedArray $this$getIntOrThrow, @StyleableRes int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getIntOrThrow, (String)"<this>");
        TypedArrayKt.checkAttribute($this$getIntOrThrow, index);
        return $this$getIntOrThrow.getInt(index, 0);
    }

    public static final int getIntegerOrThrow(@NotNull TypedArray $this$getIntegerOrThrow, @StyleableRes int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getIntegerOrThrow, (String)"<this>");
        TypedArrayKt.checkAttribute($this$getIntegerOrThrow, index);
        return $this$getIntegerOrThrow.getInteger(index, 0);
    }

    @AnyRes
    public static final int getResourceIdOrThrow(@NotNull TypedArray $this$getResourceIdOrThrow, @StyleableRes int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getResourceIdOrThrow, (String)"<this>");
        TypedArrayKt.checkAttribute($this$getResourceIdOrThrow, index);
        return $this$getResourceIdOrThrow.getResourceId(index, 0);
    }

    @NotNull
    public static final String getStringOrThrow(@NotNull TypedArray $this$getStringOrThrow, @StyleableRes int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getStringOrThrow, (String)"<this>");
        TypedArrayKt.checkAttribute($this$getStringOrThrow, index);
        String string = $this$getStringOrThrow.getString(index);
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            boolean bl3 = false;
            String string2 = "Attribute value could not be coerced to String.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    @NotNull
    public static final CharSequence getTextOrThrow(@NotNull TypedArray $this$getTextOrThrow, @StyleableRes int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getTextOrThrow, (String)"<this>");
        TypedArrayKt.checkAttribute($this$getTextOrThrow, index);
        CharSequence charSequence = $this$getTextOrThrow.getText(index);
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null) {
            boolean bl3 = false;
            String string = "Attribute value could not be coerced to CharSequence.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return charSequence;
    }

    @NotNull
    public static final CharSequence[] getTextArrayOrThrow(@NotNull TypedArray $this$getTextArrayOrThrow, @StyleableRes int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getTextArrayOrThrow, (String)"<this>");
        TypedArrayKt.checkAttribute($this$getTextArrayOrThrow, index);
        CharSequence[] charSequenceArray = $this$getTextArrayOrThrow.getTextArray(index);
        Intrinsics.checkNotNullExpressionValue((Object)charSequenceArray, (String)"getTextArray(index)");
        return charSequenceArray;
    }

    public static final <R> R use(@NotNull TypedArray $this$use, @NotNull Function1<? super TypedArray, ? extends R> block) {
        Intrinsics.checkNotNullParameter((Object)$this$use, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$use = false;
        Object object = block.invoke((Object)$this$use);
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        $this$use.recycle();
        return (R)object;
    }
}

