/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.os.Build;
import android.os.PersistableBundle;
import androidx.annotation.RequiresApi;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a=\u0010\u0000\u001a\u00020\u00012.\u0010\u0002\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00040\u0003\"\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0007\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"persistableBundleOf", "Landroid/os/PersistableBundle;", "pairs", "", "Lkotlin/Pair;", "", "", "([Lkotlin/Pair;)Landroid/os/PersistableBundle;", "core-ktx_release"})
public final class PersistableBundleKt {
    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=21)
    @NotNull
    public static final PersistableBundle persistableBundleOf(Pair<String, ? extends Object> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        PersistableBundle persistableBundle = new PersistableBundle(pairs.length);
        boolean bl = false;
        boolean bl2 = false;
        PersistableBundle $this$apply = persistableBundle;
        boolean bl3 = false;
        for (Pair<String, ? extends Object> pair : pairs) {
            void key;
            String string = (String)pair.component1();
            Object value = pair.component2();
            Object object = value;
            if (object == null) {
                $this$apply.putString((String)key, null);
                continue;
            }
            if (object instanceof Boolean) {
                if (Build.VERSION.SDK_INT >= 22) {
                    $this$apply.putBoolean((String)key, ((Boolean)value).booleanValue());
                    continue;
                }
                throw (Throwable)new IllegalArgumentException("Illegal value type boolean for key \"" + (String)key + '\"');
            }
            if (object instanceof Double) {
                $this$apply.putDouble((String)key, ((Number)value).doubleValue());
                continue;
            }
            if (object instanceof Integer) {
                $this$apply.putInt((String)key, ((Number)value).intValue());
                continue;
            }
            if (object instanceof Long) {
                $this$apply.putLong((String)key, ((Number)value).longValue());
                continue;
            }
            if (object instanceof String) {
                $this$apply.putString((String)key, (String)value);
                continue;
            }
            if (object instanceof boolean[]) {
                if (Build.VERSION.SDK_INT >= 22) {
                    $this$apply.putBooleanArray((String)key, (boolean[])value);
                    continue;
                }
                throw (Throwable)new IllegalArgumentException("Illegal value type boolean[] for key \"" + (String)key + '\"');
            }
            if (object instanceof double[]) {
                $this$apply.putDoubleArray((String)key, (double[])value);
                continue;
            }
            if (object instanceof int[]) {
                $this$apply.putIntArray((String)key, (int[])value);
                continue;
            }
            if (object instanceof long[]) {
                $this$apply.putLongArray((String)key, (long[])value);
                continue;
            }
            if (object instanceof Object[]) {
                Class<?> componentType;
                Intrinsics.checkNotNull(value.getClass().getComponentType());
                if (String.class.isAssignableFrom(componentType)) {
                    Object object2 = value;
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.String>");
                    }
                    $this$apply.putStringArray((String)key, (String[])object2);
                    continue;
                }
                String valueType = componentType.getCanonicalName();
                throw (Throwable)new IllegalArgumentException("Illegal value array type " + valueType + " for key \"" + (String)key + '\"');
            }
            String valueType = value.getClass().getCanonicalName();
            throw (Throwable)new IllegalArgumentException("Illegal value type " + valueType + " for key \"" + (String)key + '\"');
        }
        return persistableBundle;
    }
}

