/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorSpace;
import android.graphics.Point;
import android.graphics.PointF;
import androidx.annotation.ColorInt;
import androidx.annotation.RequiresApi;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a#\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0086\b\u001a7\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0087\b\u001a&\u0010\u000b\u001a\u00020\u0001*\u00020\u00012\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u0010H\u0086\b\u001a\u0015\u0010\u0011\u001a\u00020\b*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0086\n\u001a\u0015\u0010\u0011\u001a\u00020\b*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0014H\u0086\n\u001a\u001d\u0010\u0015\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0086\n\u001a'\u0010\u0018\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\bH\u0086\b\u001a'\u0010\u001a\u001a\u00020\u000f*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\b\b\u0001\u0010\u001b\u001a\u00020\u0003H\u0086\n\u00a8\u0006\u001c"}, d2={"createBitmap", "Landroid/graphics/Bitmap;", "width", "", "height", "config", "Landroid/graphics/Bitmap$Config;", "hasAlpha", "", "colorSpace", "Landroid/graphics/ColorSpace;", "applyCanvas", "block", "Lkotlin/Function1;", "Landroid/graphics/Canvas;", "", "Lkotlin/ExtensionFunctionType;", "contains", "p", "Landroid/graphics/Point;", "Landroid/graphics/PointF;", "get", "x", "y", "scale", "filter", "set", "color", "core-ktx_minDepVersionsRelease"})
public final class BitmapKt {
    @NotNull
    public static final Bitmap applyCanvas(@NotNull Bitmap $receiver, @NotNull Function1<? super Canvas, Unit> block) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        Canvas c = new Canvas($receiver);
        block.invoke((Object)c);
        return $receiver;
    }

    public static final int get(@NotNull Bitmap $receiver, int x, int y) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver.getPixel(x, y);
    }

    public static final void set(@NotNull Bitmap $receiver, int x, int y, @ColorInt int color) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        $receiver.setPixel(x, y, color);
    }

    @NotNull
    public static final Bitmap scale(@NotNull Bitmap $receiver, int width, int height, boolean filter) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)$receiver, (int)width, (int)height, (boolean)filter);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createScaledBitma\u2026s, width, height, filter)");
        return bitmap;
    }

    @NotNull
    public static /* synthetic */ Bitmap scale$default(Bitmap $receiver, int width, int height, boolean filter, int n, Object object) {
        if ((n & 4) != 0) {
            filter = true;
        }
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)$receiver, (int)width, (int)height, (boolean)filter);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createScaledBitma\u2026s, width, height, filter)");
        return bitmap;
    }

    @NotNull
    public static final Bitmap createBitmap(int width, int height, @NotNull Bitmap.Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createBitmap(width, height, config)");
        return bitmap;
    }

    @NotNull
    public static /* synthetic */ Bitmap createBitmap$default(int width, int height, Bitmap.Config config, int n, Object object) {
        if ((n & 4) != 0) {
            config = Bitmap.Config.ARGB_8888;
        }
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createBitmap(width, height, config)");
        return bitmap;
    }

    @RequiresApi(value=26)
    @NotNull
    public static final Bitmap createBitmap(int width, int height, @NotNull Bitmap.Config config, boolean hasAlpha, @NotNull ColorSpace colorSpace) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)colorSpace, (String)"colorSpace");
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config, (boolean)hasAlpha, (ColorSpace)colorSpace);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createBitmap(widt\u2026ig, hasAlpha, colorSpace)");
        return bitmap;
    }

    @RequiresApi(value=26)
    @NotNull
    public static /* synthetic */ Bitmap createBitmap$default(int width, int height, Bitmap.Config config, boolean hasAlpha, ColorSpace colorSpace, int n, Object object) {
        if ((n & 4) != 0) {
            config = Bitmap.Config.ARGB_8888;
        }
        if ((n & 8) != 0) {
            hasAlpha = true;
        }
        if ((n & 0x10) != 0) {
            ColorSpace colorSpace2 = ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB);
            Intrinsics.checkExpressionValueIsNotNull((Object)colorSpace2, (String)"ColorSpace.get(ColorSpace.Named.SRGB)");
            colorSpace = colorSpace2;
        }
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)colorSpace, (String)"colorSpace");
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config, (boolean)hasAlpha, (ColorSpace)colorSpace);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createBitmap(widt\u2026ig, hasAlpha, colorSpace)");
        return bitmap;
    }

    public static final boolean contains(@NotNull Bitmap $receiver, @NotNull Point p) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        return p.x >= 0 && p.x < $receiver.getWidth() && p.y >= 0 && p.y < $receiver.getHeight();
    }

    public static final boolean contains(@NotNull Bitmap $receiver, @NotNull PointF p) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        return p.x >= 0.0f && p.x < (float)$receiver.getWidth() && p.y >= 0.0f && p.y < (float)$receiver.getHeight();
    }
}

