/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.preference;

import android.preference.Preference;
import android.preference.PreferenceGroup;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\n\u001a\u00020\u000bH\u0096\u0002J\t\u0010\f\u001a\u00020\u0002H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/core/preference/PreferenceIterator;", "", "Landroid/preference/Preference;", "group", "Landroid/preference/PreferenceGroup;", "(Landroid/preference/PreferenceGroup;)V", "getGroup", "()Landroid/preference/PreferenceGroup;", "index", "", "hasNext", "", "next", "remove", "", "core-ktx_release"})
final class PreferenceIterator
implements Iterator<Preference>,
KMutableIterator {
    private int index;
    @NotNull
    private final PreferenceGroup group;

    @Override
    public boolean hasNext() {
        return this.index < this.group.getPreferenceCount();
    }

    @Override
    @NotNull
    public Preference next() {
        int n = this.index;
        this.index = n + 1;
        Preference preference = this.group.getPreference(n);
        if (preference == null) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        return preference;
    }

    @Override
    public void remove() {
        PreferenceIterator preferenceIterator = this;
        preferenceIterator.index += -1;
        this.group.removePreference(this.group.getPreference(preferenceIterator.index));
    }

    @NotNull
    public final PreferenceGroup getGroup() {
        return this.group;
    }

    public PreferenceIterator(@NotNull PreferenceGroup group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        this.group = group;
    }
}

