/*
 * Decompiled with CFR 0.152.
 */
package androidx.os;

import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.util.Size;
import android.util.SizeF;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a;\u0010\u0000\u001a\u00020\u00012.\u0010\u0002\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00040\u0003\"\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"bundleOf", "Landroid/os/Bundle;", "pairs", "", "Lkotlin/Pair;", "", "", "([Lkotlin/Pair;)Landroid/os/Bundle;", "core-ktx_release"})
public final class BundleKt {
    @NotNull
    public static final Bundle bundleOf(Pair<String, ? extends Object> ... pairs) {
        Bundle bundle;
        Bundle $receiver = bundle = new Bundle(((Object[])pairs).length);
        for (Pair<String, ? extends Object> pair : pairs) {
            String key = (String)pair.component1();
            Object value = pair.component2();
            Object object = value;
            if (object == null) {
                $receiver.putString(key, null);
                continue;
            }
            if (object instanceof Boolean) {
                $receiver.putBoolean(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (object instanceof Byte) {
                $receiver.putByte(key, ((Number)value).byteValue());
                continue;
            }
            if (object instanceof Character) {
                $receiver.putChar(key, ((Character)value).charValue());
                continue;
            }
            if (object instanceof Double) {
                $receiver.putDouble(key, ((Number)value).doubleValue());
                continue;
            }
            if (object instanceof Float) {
                $receiver.putFloat(key, ((Number)value).floatValue());
                continue;
            }
            if (object instanceof Integer) {
                $receiver.putInt(key, ((Number)value).intValue());
                continue;
            }
            if (object instanceof Long) {
                $receiver.putLong(key, ((Number)value).longValue());
                continue;
            }
            if (object instanceof Short) {
                $receiver.putShort(key, ((Number)value).shortValue());
                continue;
            }
            if (object instanceof Bundle) {
                $receiver.putBundle(key, (Bundle)value);
                continue;
            }
            if (object instanceof CharSequence) {
                $receiver.putCharSequence(key, (CharSequence)value);
                continue;
            }
            if (object instanceof Parcelable) {
                $receiver.putParcelable(key, (Parcelable)value);
                continue;
            }
            if (object instanceof boolean[]) {
                $receiver.putBooleanArray(key, (boolean[])value);
                continue;
            }
            if (object instanceof byte[]) {
                $receiver.putByteArray(key, (byte[])value);
                continue;
            }
            if (object instanceof char[]) {
                $receiver.putCharArray(key, (char[])value);
                continue;
            }
            if (object instanceof double[]) {
                $receiver.putDoubleArray(key, (double[])value);
                continue;
            }
            if (object instanceof float[]) {
                $receiver.putFloatArray(key, (float[])value);
                continue;
            }
            if (object instanceof int[]) {
                $receiver.putIntArray(key, (int[])value);
                continue;
            }
            if (object instanceof long[]) {
                $receiver.putLongArray(key, (long[])value);
                continue;
            }
            if (object instanceof short[]) {
                $receiver.putShortArray(key, (short[])value);
                continue;
            }
            if (object instanceof Object[]) {
                Class<?> componentType = value.getClass().getComponentType();
                if (Parcelable.class.isAssignableFrom(componentType)) {
                    Object object2 = value;
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<android.os.Parcelable>");
                    }
                    $receiver.putParcelableArray(key, (Parcelable[])object2);
                    continue;
                }
                if (String.class.isAssignableFrom(componentType)) {
                    Object object3 = value;
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.String>");
                    }
                    $receiver.putStringArray(key, (String[])object3);
                    continue;
                }
                if (CharSequence.class.isAssignableFrom(componentType)) {
                    Object object4 = value;
                    if (object4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.CharSequence>");
                    }
                    $receiver.putCharSequenceArray(key, (CharSequence[])object4);
                    continue;
                }
                if (Serializable.class.isAssignableFrom(componentType)) {
                    $receiver.putSerializable(key, (Serializable)value);
                    continue;
                }
                Class<?> clazz = componentType;
                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"componentType");
                String valueType = clazz.getCanonicalName();
                throw (Throwable)new IllegalArgumentException("Illegal value array type " + valueType + " for key \"" + key + '\"');
            }
            if (object instanceof Serializable) {
                $receiver.putSerializable(key, (Serializable)value);
                continue;
            }
            if (Build.VERSION.SDK_INT >= 18 && value instanceof Binder) {
                $receiver.putBinder(key, (IBinder)value);
                continue;
            }
            if (Build.VERSION.SDK_INT >= 21 && value instanceof Size) {
                $receiver.putSize(key, (Size)value);
                continue;
            }
            if (Build.VERSION.SDK_INT >= 21 && value instanceof SizeF) {
                $receiver.putSizeF(key, (SizeF)value);
                continue;
            }
            String valueType = value.getClass().getCanonicalName();
            throw (Throwable)new IllegalArgumentException("Illegal value type " + valueType + " for key \"" + key + '\"');
        }
        return bundle;
    }
}

