/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

@file:Suppress("NOTHING_TO_INLINE") // Aliases to public API.

package androidx.time

import android.support.annotation.RequiresApi
import java.time.Month
import java.time.YearMonth

/**
 * Return the year component of this [YearMonth].
 *
 * This method allows to use destructuring declarations when working with year-months,
 * for example:
 * ```
 * val (year, month) = myYearMonth
 * ```
 *
 * @see YearMonth.getYear
 */
@RequiresApi(26)
inline operator fun YearMonth.component1(): Int = year

/**
 * Return the [Month] component of this [YearMonth].
 *
 * This method allows to use destructuring declarations when working with year-months,
 * for example:
 * ```
 * val (year, month) = myYearMonth
 * ```
 *
 * @see YearMonth.getMonth
 */
@RequiresApi(26)
inline operator fun YearMonth.component2(): Month = month
