/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.key;

import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.key.MotionKey;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.core.motion.utils.TimeCycleSplineSet;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import androidx.constraintlayout.core.motion.utils.Utils;
import java.util.HashMap;
import java.util.HashSet;

public class MotionKeyTimeCycle
extends MotionKey {
    static final String NAME = "KeyTimeCycle";
    private static final String TAG = "KeyTimeCycle";
    private String mTransitionEasing;
    private int mCurveFit = -1;
    private float mAlpha = Float.NaN;
    private float mElevation = Float.NaN;
    private float mRotation = Float.NaN;
    private float mRotationX = Float.NaN;
    private float mRotationY = Float.NaN;
    private float mTransitionPathRotate = Float.NaN;
    private float mScaleX = Float.NaN;
    private float mScaleY = Float.NaN;
    private float mTranslationX = Float.NaN;
    private float mTranslationY = Float.NaN;
    private float mTranslationZ = Float.NaN;
    private float mProgress = Float.NaN;
    private int mWaveShape = 0;
    private String mCustomWaveShape = null;
    private float mWavePeriod = Float.NaN;
    private float mWaveOffset = 0.0f;
    public static final int KEY_TYPE = 3;

    public MotionKeyTimeCycle() {
        this.mType = 3;
        this.mCustom = new HashMap();
    }

    public void addTimeValues(HashMap<String, TimeCycleSplineSet> splines) {
        block28: for (String s : splines.keySet()) {
            TimeCycleSplineSet splineSet = splines.get(s);
            if (splineSet == null) continue;
            if (s.startsWith("CUSTOM")) {
                String cKey = s.substring("CUSTOM".length() + 1);
                CustomVariable cValue = (CustomVariable)this.mCustom.get(cKey);
                if (cValue == null) continue;
                ((TimeCycleSplineSet.CustomVarSet)splineSet).setPoint(this.mFramePosition, cValue, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                continue;
            }
            switch (s) {
                case "alpha": {
                    if (Float.isNaN(this.mAlpha)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mAlpha, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "rotationX": {
                    if (Float.isNaN(this.mRotationX)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mRotationX, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "rotationY": {
                    if (Float.isNaN(this.mRotationY)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mRotationY, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "rotationZ": {
                    if (Float.isNaN(this.mRotation)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mRotation, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "pathRotate": {
                    if (Float.isNaN(this.mTransitionPathRotate)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mTransitionPathRotate, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "scaleX": {
                    if (Float.isNaN(this.mScaleX)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mScaleX, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "scaleY": {
                    if (Float.isNaN(this.mScaleY)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mScaleY, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "translationX": {
                    if (Float.isNaN(this.mTranslationX)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mTranslationX, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "translationY": {
                    if (Float.isNaN(this.mTranslationY)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mTranslationY, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "translationZ": {
                    if (Float.isNaN(this.mTranslationZ)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mTranslationZ, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "elevation": {
                    if (Float.isNaN(this.mTranslationZ)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mTranslationZ, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "progress": {
                    if (Float.isNaN(this.mProgress)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mProgress, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
            }
            Utils.loge("KeyTimeCycles", "UNKNOWN addValues \"" + s + "\"");
        }
    }

    @Override
    public void addValues(HashMap<String, SplineSet> splines) {
    }

    @Override
    public boolean setValue(int type, int value) {
        switch (type) {
            case 100: {
                this.mFramePosition = value;
                break;
            }
            case 421: {
                this.mWaveShape = value;
                break;
            }
            default: {
                return super.setValue(type, value);
            }
        }
        return true;
    }

    @Override
    public boolean setValue(int type, float value) {
        switch (type) {
            case 403: {
                this.mAlpha = value;
                break;
            }
            case 401: {
                this.mCurveFit = this.toInt(Float.valueOf(value));
                break;
            }
            case 307: {
                this.mElevation = this.toFloat(Float.valueOf(value));
                break;
            }
            case 315: {
                this.mProgress = this.toFloat(Float.valueOf(value));
                break;
            }
            case 310: {
                this.mRotation = this.toFloat(Float.valueOf(value));
                break;
            }
            case 308: {
                this.mRotationX = this.toFloat(Float.valueOf(value));
                break;
            }
            case 309: {
                this.mRotationY = this.toFloat(Float.valueOf(value));
                break;
            }
            case 311: {
                this.mScaleX = this.toFloat(Float.valueOf(value));
                break;
            }
            case 312: {
                this.mScaleY = this.toFloat(Float.valueOf(value));
                break;
            }
            case 416: {
                this.mTransitionPathRotate = this.toFloat(Float.valueOf(value));
                break;
            }
            case 304: {
                this.mTranslationX = this.toFloat(Float.valueOf(value));
                break;
            }
            case 305: {
                this.mTranslationY = this.toFloat(Float.valueOf(value));
                break;
            }
            case 306: {
                this.mTranslationZ = this.toFloat(Float.valueOf(value));
                break;
            }
            case 423: {
                this.mWavePeriod = this.toFloat(Float.valueOf(value));
                break;
            }
            case 424: {
                this.mWaveOffset = this.toFloat(Float.valueOf(value));
                break;
            }
            default: {
                return super.setValue(type, value);
            }
        }
        return true;
    }

    @Override
    public boolean setValue(int type, String value) {
        switch (type) {
            case 421: {
                this.mWaveShape = 7;
                this.mCustomWaveShape = value;
                break;
            }
            case 420: {
                this.mTransitionEasing = value;
                break;
            }
            default: {
                return super.setValue(type, value);
            }
        }
        return true;
    }

    @Override
    public boolean setValue(int type, boolean value) {
        return super.setValue(type, value);
    }

    @Override
    public MotionKeyTimeCycle copy(MotionKey src) {
        super.copy(src);
        MotionKeyTimeCycle k = (MotionKeyTimeCycle)src;
        this.mTransitionEasing = k.mTransitionEasing;
        this.mCurveFit = k.mCurveFit;
        this.mWaveShape = k.mWaveShape;
        this.mWavePeriod = k.mWavePeriod;
        this.mWaveOffset = k.mWaveOffset;
        this.mProgress = k.mProgress;
        this.mAlpha = k.mAlpha;
        this.mElevation = k.mElevation;
        this.mRotation = k.mRotation;
        this.mTransitionPathRotate = k.mTransitionPathRotate;
        this.mRotationX = k.mRotationX;
        this.mRotationY = k.mRotationY;
        this.mScaleX = k.mScaleX;
        this.mScaleY = k.mScaleY;
        this.mTranslationX = k.mTranslationX;
        this.mTranslationY = k.mTranslationY;
        this.mTranslationZ = k.mTranslationZ;
        return this;
    }

    @Override
    public void getAttributeNames(HashSet<String> attributes) {
        if (!Float.isNaN(this.mAlpha)) {
            attributes.add("alpha");
        }
        if (!Float.isNaN(this.mElevation)) {
            attributes.add("elevation");
        }
        if (!Float.isNaN(this.mRotation)) {
            attributes.add("rotationZ");
        }
        if (!Float.isNaN(this.mRotationX)) {
            attributes.add("rotationX");
        }
        if (!Float.isNaN(this.mRotationY)) {
            attributes.add("rotationY");
        }
        if (!Float.isNaN(this.mScaleX)) {
            attributes.add("scaleX");
        }
        if (!Float.isNaN(this.mScaleY)) {
            attributes.add("scaleY");
        }
        if (!Float.isNaN(this.mTransitionPathRotate)) {
            attributes.add("pathRotate");
        }
        if (!Float.isNaN(this.mTranslationX)) {
            attributes.add("translationX");
        }
        if (!Float.isNaN(this.mTranslationY)) {
            attributes.add("translationY");
        }
        if (!Float.isNaN(this.mTranslationZ)) {
            attributes.add("translationZ");
        }
        if (this.mCustom.size() > 0) {
            for (String s : this.mCustom.keySet()) {
                attributes.add("CUSTOM," + s);
            }
        }
    }

    @Override
    public MotionKey clone() {
        return new MotionKeyTimeCycle().copy(this);
    }

    @Override
    public int getId(String name) {
        return TypedValues.CycleType.getId(name);
    }
}

