/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion;

import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.utils.Easing;
import androidx.constraintlayout.core.motion.utils.Rect;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.core.motion.utils.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

class MotionConstrainedPoint
implements Comparable<MotionConstrainedPoint> {
    public static final String TAG = "MotionPaths";
    public static final boolean DEBUG = false;
    private float mAlpha = 1.0f;
    int mVisibilityMode = 0;
    int mVisibility;
    private boolean mApplyElevation = false;
    private float mElevation = 0.0f;
    private float mRotation = 0.0f;
    private float mRotationX = 0.0f;
    public float rotationY = 0.0f;
    private float mScaleX = 1.0f;
    private float mScaleY = 1.0f;
    private float mPivotX = Float.NaN;
    private float mPivotY = Float.NaN;
    private float mTranslationX = 0.0f;
    private float mTranslationY = 0.0f;
    private float mTranslationZ = 0.0f;
    private Easing mKeyFrameEasing;
    private int mDrawPath = 0;
    private float mPosition;
    private float mX;
    private float mY;
    private float mWidth;
    private float mHeight;
    private float mPathRotate = Float.NaN;
    private float mProgress = Float.NaN;
    private int mAnimateRelativeTo = -1;
    static final int PERPENDICULAR = 1;
    static final int CARTESIAN = 2;
    static String[] sNames = new String[]{"position", "x", "y", "width", "height", "pathRotate"};
    LinkedHashMap<String, CustomVariable> mCustomVariable = new LinkedHashMap();
    int mMode = 0;
    double[] mTempValue = new double[18];
    double[] mTempDelta = new double[18];

    MotionConstrainedPoint() {
    }

    private boolean diff(float a, float b) {
        if (Float.isNaN(a) || Float.isNaN(b)) {
            return Float.isNaN(a) != Float.isNaN(b);
        }
        return Math.abs(a - b) > 1.0E-6f;
    }

    void different(MotionConstrainedPoint points, HashSet<String> keySet) {
        if (this.diff(this.mAlpha, points.mAlpha)) {
            keySet.add("alpha");
        }
        if (this.diff(this.mElevation, points.mElevation)) {
            keySet.add("translationZ");
        }
        if (this.mVisibility != points.mVisibility && this.mVisibilityMode == 0 && (this.mVisibility == 4 || points.mVisibility == 4)) {
            keySet.add("alpha");
        }
        if (this.diff(this.mRotation, points.mRotation)) {
            keySet.add("rotationZ");
        }
        if (!Float.isNaN(this.mPathRotate) || !Float.isNaN(points.mPathRotate)) {
            keySet.add("pathRotate");
        }
        if (!Float.isNaN(this.mProgress) || !Float.isNaN(points.mProgress)) {
            keySet.add("progress");
        }
        if (this.diff(this.mRotationX, points.mRotationX)) {
            keySet.add("rotationX");
        }
        if (this.diff(this.rotationY, points.rotationY)) {
            keySet.add("rotationY");
        }
        if (this.diff(this.mPivotX, points.mPivotX)) {
            keySet.add("pivotX");
        }
        if (this.diff(this.mPivotY, points.mPivotY)) {
            keySet.add("pivotY");
        }
        if (this.diff(this.mScaleX, points.mScaleX)) {
            keySet.add("scaleX");
        }
        if (this.diff(this.mScaleY, points.mScaleY)) {
            keySet.add("scaleY");
        }
        if (this.diff(this.mTranslationX, points.mTranslationX)) {
            keySet.add("translationX");
        }
        if (this.diff(this.mTranslationY, points.mTranslationY)) {
            keySet.add("translationY");
        }
        if (this.diff(this.mTranslationZ, points.mTranslationZ)) {
            keySet.add("translationZ");
        }
        if (this.diff(this.mElevation, points.mElevation)) {
            keySet.add("elevation");
        }
    }

    void different(MotionConstrainedPoint points, boolean[] mask, String[] custom) {
        int c = 0;
        int n = c++;
        mask[n] = mask[n] | this.diff(this.mPosition, points.mPosition);
        int n2 = c++;
        mask[n2] = mask[n2] | this.diff(this.mX, points.mX);
        int n3 = c++;
        mask[n3] = mask[n3] | this.diff(this.mY, points.mY);
        int n4 = c++;
        mask[n4] = mask[n4] | this.diff(this.mWidth, points.mWidth);
        int n5 = c++;
        mask[n5] = mask[n5] | this.diff(this.mHeight, points.mHeight);
    }

    void fillStandard(double[] data, int[] toUse) {
        float[] set = new float[]{this.mPosition, this.mX, this.mY, this.mWidth, this.mHeight, this.mAlpha, this.mElevation, this.mRotation, this.mRotationX, this.rotationY, this.mScaleX, this.mScaleY, this.mPivotX, this.mPivotY, this.mTranslationX, this.mTranslationY, this.mTranslationZ, this.mPathRotate};
        int c = 0;
        for (int i = 0; i < toUse.length; ++i) {
            if (toUse[i] >= set.length) continue;
            data[c++] = set[toUse[i]];
        }
    }

    boolean hasCustomData(String name) {
        return this.mCustomVariable.containsKey(name);
    }

    int getCustomDataCount(String name) {
        return this.mCustomVariable.get(name).numberOfInterpolatedValues();
    }

    int getCustomData(String name, double[] value, int offset) {
        CustomVariable a = this.mCustomVariable.get(name);
        if (a.numberOfInterpolatedValues() == 1) {
            value[offset] = a.getValueToInterpolate();
            return 1;
        }
        int n = a.numberOfInterpolatedValues();
        float[] f = new float[n];
        a.getValuesToInterpolate(f);
        for (int i = 0; i < n; ++i) {
            value[offset++] = f[i];
        }
        return n;
    }

    void setBounds(float x, float y, float w, float h) {
        this.mX = x;
        this.mY = y;
        this.mWidth = w;
        this.mHeight = h;
    }

    @Override
    public int compareTo(MotionConstrainedPoint o) {
        return Float.compare(this.mPosition, o.mPosition);
    }

    public void applyParameters(MotionWidget view) {
        this.mVisibility = view.getVisibility();
        this.mAlpha = view.getVisibility() != 4 ? 0.0f : view.getAlpha();
        this.mApplyElevation = false;
        this.mRotation = view.getRotationZ();
        this.mRotationX = view.getRotationX();
        this.rotationY = view.getRotationY();
        this.mScaleX = view.getScaleX();
        this.mScaleY = view.getScaleY();
        this.mPivotX = view.getPivotX();
        this.mPivotY = view.getPivotY();
        this.mTranslationX = view.getTranslationX();
        this.mTranslationY = view.getTranslationY();
        this.mTranslationZ = view.getTranslationZ();
        Set<String> at = view.getCustomAttributeNames();
        for (String s : at) {
            CustomVariable attr = view.getCustomAttribute(s);
            if (attr == null || !attr.isContinuous()) continue;
            this.mCustomVariable.put(s, attr);
        }
    }

    public void addValues(HashMap<String, SplineSet> splines, int mFramePosition) {
        block30: for (String s : splines.keySet()) {
            SplineSet ViewSpline = splines.get(s);
            switch (s) {
                case "alpha": {
                    ViewSpline.setPoint(mFramePosition, Float.isNaN(this.mAlpha) ? 1.0f : this.mAlpha);
                    continue block30;
                }
                case "rotationZ": {
                    ViewSpline.setPoint(mFramePosition, Float.isNaN(this.mRotation) ? 0.0f : this.mRotation);
                    continue block30;
                }
                case "rotationX": {
                    ViewSpline.setPoint(mFramePosition, Float.isNaN(this.mRotationX) ? 0.0f : this.mRotationX);
                    continue block30;
                }
                case "rotationY": {
                    ViewSpline.setPoint(mFramePosition, Float.isNaN(this.rotationY) ? 0.0f : this.rotationY);
                    continue block30;
                }
                case "pivotX": {
                    ViewSpline.setPoint(mFramePosition, Float.isNaN(this.mPivotX) ? 0.0f : this.mPivotX);
                    continue block30;
                }
                case "pivotY": {
                    ViewSpline.setPoint(mFramePosition, Float.isNaN(this.mPivotY) ? 0.0f : this.mPivotY);
                    continue block30;
                }
                case "pathRotate": {
                    ViewSpline.setPoint(mFramePosition, Float.isNaN(this.mPathRotate) ? 0.0f : this.mPathRotate);
                    continue block30;
                }
                case "progress": {
                    ViewSpline.setPoint(mFramePosition, Float.isNaN(this.mProgress) ? 0.0f : this.mProgress);
                    continue block30;
                }
                case "scaleX": {
                    ViewSpline.setPoint(mFramePosition, Float.isNaN(this.mScaleX) ? 1.0f : this.mScaleX);
                    continue block30;
                }
                case "scaleY": {
                    ViewSpline.setPoint(mFramePosition, Float.isNaN(this.mScaleY) ? 1.0f : this.mScaleY);
                    continue block30;
                }
                case "translationX": {
                    ViewSpline.setPoint(mFramePosition, Float.isNaN(this.mTranslationX) ? 0.0f : this.mTranslationX);
                    continue block30;
                }
                case "translationY": {
                    ViewSpline.setPoint(mFramePosition, Float.isNaN(this.mTranslationY) ? 0.0f : this.mTranslationY);
                    continue block30;
                }
                case "translationZ": {
                    ViewSpline.setPoint(mFramePosition, Float.isNaN(this.mTranslationZ) ? 0.0f : this.mTranslationZ);
                    continue block30;
                }
            }
            if (s.startsWith("CUSTOM")) {
                String customName = s.split(",")[1];
                if (!this.mCustomVariable.containsKey(customName)) continue;
                CustomVariable custom = this.mCustomVariable.get(customName);
                if (ViewSpline instanceof SplineSet.CustomSpline) {
                    ((SplineSet.CustomSpline)ViewSpline).setPoint(mFramePosition, custom);
                    continue;
                }
                Utils.loge(TAG, s + " ViewSpline not a CustomSet frame = " + mFramePosition + ", value" + custom.getValueToInterpolate() + ViewSpline);
                continue;
            }
            Utils.loge(TAG, "UNKNOWN spline " + s);
        }
    }

    public void setState(MotionWidget view) {
        this.setBounds(view.getX(), view.getY(), view.getWidth(), view.getHeight());
        this.applyParameters(view);
    }

    public void setState(Rect rect, MotionWidget view, int rotation, float prevous) {
        this.setBounds(rect.left, rect.top, rect.width(), rect.height());
        this.applyParameters(view);
        this.mPivotX = Float.NaN;
        this.mPivotY = Float.NaN;
        switch (rotation) {
            case 2: {
                this.mRotation = prevous + 90.0f;
                break;
            }
            case 1: {
                this.mRotation = prevous - 90.0f;
            }
        }
    }
}

