/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.key;

import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.key.MotionKey;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import java.util.HashMap;
import java.util.HashSet;

public class MotionKeyAttributes
extends MotionKey {
    static final String NAME = "KeyAttribute";
    private static final String TAG = "KeyAttributes";
    private static final boolean DEBUG = false;
    private String mTransitionEasing;
    private int mCurveFit = -1;
    private int mVisibility = 0;
    private float mAlpha = Float.NaN;
    private float mElevation = Float.NaN;
    private float mRotation = Float.NaN;
    private float mRotationX = Float.NaN;
    private float mRotationY = Float.NaN;
    private float mPivotX = Float.NaN;
    private float mPivotY = Float.NaN;
    private float mTransitionPathRotate = Float.NaN;
    private float mScaleX = Float.NaN;
    private float mScaleY = Float.NaN;
    private float mTranslationX = Float.NaN;
    private float mTranslationY = Float.NaN;
    private float mTranslationZ = Float.NaN;
    private float mProgress = Float.NaN;
    public static final int KEY_TYPE = 1;

    public MotionKeyAttributes() {
        this.mType = 1;
        this.mCustom = new HashMap();
    }

    @Override
    public void getAttributeNames(HashSet<String> attributes) {
        if (!Float.isNaN(this.mAlpha)) {
            attributes.add("alpha");
        }
        if (!Float.isNaN(this.mElevation)) {
            attributes.add("elevation");
        }
        if (!Float.isNaN(this.mRotation)) {
            attributes.add("rotationZ");
        }
        if (!Float.isNaN(this.mRotationX)) {
            attributes.add("rotationX");
        }
        if (!Float.isNaN(this.mRotationY)) {
            attributes.add("rotationY");
        }
        if (!Float.isNaN(this.mPivotX)) {
            attributes.add("pivotX");
        }
        if (!Float.isNaN(this.mPivotY)) {
            attributes.add("pivotY");
        }
        if (!Float.isNaN(this.mTranslationX)) {
            attributes.add("translationX");
        }
        if (!Float.isNaN(this.mTranslationY)) {
            attributes.add("translationY");
        }
        if (!Float.isNaN(this.mTranslationZ)) {
            attributes.add("translationZ");
        }
        if (!Float.isNaN(this.mTransitionPathRotate)) {
            attributes.add("pathRotate");
        }
        if (!Float.isNaN(this.mScaleX)) {
            attributes.add("scaleX");
        }
        if (!Float.isNaN(this.mScaleY)) {
            attributes.add("scaleY");
        }
        if (!Float.isNaN(this.mProgress)) {
            attributes.add("progress");
        }
        if (this.mCustom.size() > 0) {
            for (String s : this.mCustom.keySet()) {
                attributes.add("CUSTOM," + s);
            }
        }
    }

    @Override
    public void addValues(HashMap<String, SplineSet> splines) {
        block32: for (String s : splines.keySet()) {
            SplineSet splineSet = splines.get(s);
            if (splineSet == null) continue;
            if (s.startsWith("CUSTOM")) {
                String cKey = s.substring("CUSTOM".length() + 1);
                CustomVariable cValue = (CustomVariable)this.mCustom.get(cKey);
                if (cValue == null) continue;
                ((SplineSet.CustomSpline)splineSet).setPoint(this.mFramePosition, cValue);
                continue;
            }
            switch (s) {
                case "alpha": {
                    if (Float.isNaN(this.mAlpha)) continue block32;
                    splineSet.setPoint(this.mFramePosition, this.mAlpha);
                    continue block32;
                }
                case "elevation": {
                    if (Float.isNaN(this.mElevation)) continue block32;
                    splineSet.setPoint(this.mFramePosition, this.mElevation);
                    continue block32;
                }
                case "rotationZ": {
                    if (Float.isNaN(this.mRotation)) continue block32;
                    splineSet.setPoint(this.mFramePosition, this.mRotation);
                    continue block32;
                }
                case "rotationX": {
                    if (Float.isNaN(this.mRotationX)) continue block32;
                    splineSet.setPoint(this.mFramePosition, this.mRotationX);
                    continue block32;
                }
                case "rotationY": {
                    if (Float.isNaN(this.mRotationY)) continue block32;
                    splineSet.setPoint(this.mFramePosition, this.mRotationY);
                    continue block32;
                }
                case "pivotX": {
                    if (Float.isNaN(this.mRotationX)) continue block32;
                    splineSet.setPoint(this.mFramePosition, this.mPivotX);
                    continue block32;
                }
                case "pivotY": {
                    if (Float.isNaN(this.mRotationY)) continue block32;
                    splineSet.setPoint(this.mFramePosition, this.mPivotY);
                    continue block32;
                }
                case "pathRotate": {
                    if (Float.isNaN(this.mTransitionPathRotate)) continue block32;
                    splineSet.setPoint(this.mFramePosition, this.mTransitionPathRotate);
                    continue block32;
                }
                case "scaleX": {
                    if (Float.isNaN(this.mScaleX)) continue block32;
                    splineSet.setPoint(this.mFramePosition, this.mScaleX);
                    continue block32;
                }
                case "scaleY": {
                    if (Float.isNaN(this.mScaleY)) continue block32;
                    splineSet.setPoint(this.mFramePosition, this.mScaleY);
                    continue block32;
                }
                case "translationX": {
                    if (Float.isNaN(this.mTranslationX)) continue block32;
                    splineSet.setPoint(this.mFramePosition, this.mTranslationX);
                    continue block32;
                }
                case "translationY": {
                    if (Float.isNaN(this.mTranslationY)) continue block32;
                    splineSet.setPoint(this.mFramePosition, this.mTranslationY);
                    continue block32;
                }
                case "translationZ": {
                    if (Float.isNaN(this.mTranslationZ)) continue block32;
                    splineSet.setPoint(this.mFramePosition, this.mTranslationZ);
                    continue block32;
                }
                case "progress": {
                    if (Float.isNaN(this.mProgress)) continue block32;
                    splineSet.setPoint(this.mFramePosition, this.mProgress);
                    continue block32;
                }
            }
            System.err.println("not supported by KeyAttributes " + s);
        }
    }

    @Override
    public MotionKey clone() {
        return null;
    }

    @Override
    public boolean setValue(int type, int value) {
        switch (type) {
            case 302: {
                this.mVisibility = value;
                break;
            }
            case 301: {
                this.mCurveFit = value;
                break;
            }
            case 100: {
                this.mFramePosition = value;
                break;
            }
            default: {
                if (this.setValue(type, value)) break;
                return super.setValue(type, value);
            }
        }
        return true;
    }

    @Override
    public boolean setValue(int type, float value) {
        switch (type) {
            case 303: {
                this.mAlpha = value;
                break;
            }
            case 304: {
                this.mTranslationX = value;
                break;
            }
            case 305: {
                this.mTranslationY = value;
                break;
            }
            case 306: {
                this.mTranslationZ = value;
                break;
            }
            case 307: {
                this.mElevation = value;
                break;
            }
            case 308: {
                this.mRotationX = value;
                break;
            }
            case 309: {
                this.mRotationY = value;
                break;
            }
            case 310: {
                this.mRotation = value;
                break;
            }
            case 311: {
                this.mScaleX = value;
                break;
            }
            case 312: {
                this.mScaleY = value;
                break;
            }
            case 313: {
                this.mPivotX = value;
                break;
            }
            case 314: {
                this.mPivotY = value;
                break;
            }
            case 315: {
                this.mProgress = value;
                break;
            }
            case 316: {
                this.mTransitionPathRotate = value;
                break;
            }
            case 100: {
                this.mTransitionPathRotate = value;
                break;
            }
            default: {
                return super.setValue(type, value);
            }
        }
        return true;
    }

    @Override
    public void setInterpolation(HashMap<String, Integer> interpolation) {
        if (!Float.isNaN(this.mAlpha)) {
            interpolation.put("alpha", this.mCurveFit);
        }
        if (!Float.isNaN(this.mElevation)) {
            interpolation.put("elevation", this.mCurveFit);
        }
        if (!Float.isNaN(this.mRotation)) {
            interpolation.put("rotationZ", this.mCurveFit);
        }
        if (!Float.isNaN(this.mRotationX)) {
            interpolation.put("rotationX", this.mCurveFit);
        }
        if (!Float.isNaN(this.mRotationY)) {
            interpolation.put("rotationY", this.mCurveFit);
        }
        if (!Float.isNaN(this.mPivotX)) {
            interpolation.put("pivotX", this.mCurveFit);
        }
        if (!Float.isNaN(this.mPivotY)) {
            interpolation.put("pivotY", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTranslationX)) {
            interpolation.put("translationX", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTranslationY)) {
            interpolation.put("translationY", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTranslationZ)) {
            interpolation.put("translationZ", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTransitionPathRotate)) {
            interpolation.put("pathRotate", this.mCurveFit);
        }
        if (!Float.isNaN(this.mScaleX)) {
            interpolation.put("scaleX", this.mCurveFit);
        }
        if (!Float.isNaN(this.mScaleY)) {
            interpolation.put("scaleY", this.mCurveFit);
        }
        if (!Float.isNaN(this.mProgress)) {
            interpolation.put("progress", this.mCurveFit);
        }
        if (this.mCustom.size() > 0) {
            for (String s : this.mCustom.keySet()) {
                interpolation.put("CUSTOM," + s, this.mCurveFit);
            }
        }
    }

    @Override
    public boolean setValue(int type, String value) {
        switch (type) {
            case 317: {
                this.mTransitionEasing = value;
                break;
            }
            case 101: {
                this.mTargetString = value;
                break;
            }
            default: {
                return super.setValue(type, value);
            }
        }
        return true;
    }

    @Override
    public int getId(String name) {
        return TypedValues.AttributesType.getId(name);
    }

    public int getCurveFit() {
        return this.mCurveFit;
    }

    public void printAttributes() {
        HashSet<String> nameSet = new HashSet<String>();
        this.getAttributeNames(nameSet);
        System.out.println(" ------------- " + this.mFramePosition + " -------------");
        String[] names = nameSet.toArray(new String[0]);
        for (int i = 0; i < names.length; ++i) {
            int id = TypedValues.AttributesType.getId(names[i]);
            System.out.println(names[i] + ":" + this.getFloatValue(id));
        }
    }

    private float getFloatValue(int id) {
        switch (id) {
            case 303: {
                return this.mAlpha;
            }
            case 304: {
                return this.mTranslationX;
            }
            case 305: {
                return this.mTranslationY;
            }
            case 306: {
                return this.mTranslationZ;
            }
            case 307: {
                return this.mElevation;
            }
            case 308: {
                return this.mRotationX;
            }
            case 309: {
                return this.mRotationY;
            }
            case 310: {
                return this.mRotation;
            }
            case 311: {
                return this.mScaleX;
            }
            case 312: {
                return this.mScaleY;
            }
            case 313: {
                return this.mPivotX;
            }
            case 314: {
                return this.mPivotY;
            }
            case 315: {
                return this.mProgress;
            }
            case 316: {
                return this.mTransitionPathRotate;
            }
            case 100: {
                return this.mFramePosition;
            }
        }
        return Float.NaN;
    }
}

