/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.parser;

import androidx.constraintlayout.core.parser.CLContainer;
import androidx.constraintlayout.core.parser.CLNumber;
import androidx.constraintlayout.core.parser.CLParser;

public class CLElement {
    private final char[] mContent;
    protected long mStart = -1L;
    protected long mEnd = Long.MAX_VALUE;
    protected CLContainer mContainer;
    private int mLine;
    protected static int sMaxLine = 80;
    protected static int sBaseIndent = 2;

    public CLElement(char[] content) {
        this.mContent = content;
    }

    public boolean notStarted() {
        return this.mStart == -1L;
    }

    public void setLine(int line) {
        this.mLine = line;
    }

    public int getLine() {
        return this.mLine;
    }

    public void setStart(long start) {
        this.mStart = start;
    }

    public long getStart() {
        return this.mStart;
    }

    public long getEnd() {
        return this.mEnd;
    }

    public void setEnd(long end) {
        if (this.mEnd != Long.MAX_VALUE) {
            return;
        }
        this.mEnd = end;
        if (CLParser.sDebug) {
            System.out.println("closing " + this.hashCode() + " -> " + this);
        }
        if (this.mContainer != null) {
            this.mContainer.add(this);
        }
    }

    protected void addIndent(StringBuilder builder, int indent) {
        for (int i = 0; i < indent; ++i) {
            builder.append(' ');
        }
    }

    public String toString() {
        if (this.mStart > this.mEnd || this.mEnd == Long.MAX_VALUE) {
            return this.getClass() + " (INVALID, " + this.mStart + "-" + this.mEnd + ")";
        }
        String content = new String(this.mContent);
        content = content.substring((int)this.mStart, (int)this.mEnd + 1);
        return this.getStrClass() + " (" + this.mStart + " : " + this.mEnd + ") <<" + content + ">>";
    }

    protected String getStrClass() {
        String myClass = this.getClass().toString();
        return myClass.substring(myClass.lastIndexOf(46) + 1);
    }

    protected String getDebugName() {
        if (CLParser.sDebug) {
            return this.getStrClass() + " -> ";
        }
        return "";
    }

    public String content() {
        String content = new String(this.mContent);
        if (this.mEnd == Long.MAX_VALUE || this.mEnd < this.mStart) {
            return content.substring((int)this.mStart, (int)this.mStart + 1);
        }
        return content.substring((int)this.mStart, (int)this.mEnd + 1);
    }

    public boolean isDone() {
        return this.mEnd != Long.MAX_VALUE;
    }

    public void setContainer(CLContainer element) {
        this.mContainer = element;
    }

    public CLElement getContainer() {
        return this.mContainer;
    }

    public boolean isStarted() {
        return this.mStart > -1L;
    }

    protected String toJSON() {
        return "";
    }

    protected String toFormattedJSON(int indent, int forceIndent) {
        return "";
    }

    public int getInt() {
        if (this instanceof CLNumber) {
            return ((CLNumber)this).getInt();
        }
        return 0;
    }

    public float getFloat() {
        if (this instanceof CLNumber) {
            return ((CLNumber)this).getFloat();
        }
        return Float.NaN;
    }
}

