/*
 * Decompiled with CFR 0.152.
 */
package androidx.concurrent.futures;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.concurrent.futures.AbstractResolvableFuture;
import androidx.concurrent.futures.ResolvableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class CallbackToFutureAdapter {
    private CallbackToFutureAdapter() {
    }

    @NonNull
    public static <T> ListenableFuture<T> getFuture(@NonNull Resolver<T> callback) {
        Completer completer = new Completer();
        SafeFuture safeFuture = new SafeFuture(completer);
        completer.future = safeFuture;
        completer.tag = callback.getClass();
        try {
            Object tag = callback.attachCompleter(completer);
            if (tag != null) {
                completer.tag = tag;
            }
        }
        catch (Exception e) {
            safeFuture.setException(e);
        }
        return safeFuture;
    }

    public static final class Completer<T> {
        Object tag;
        SafeFuture<T> future;
        private ResolvableFuture<Void> cancellationFuture = ResolvableFuture.create();
        private boolean attemptedSetting;

        Completer() {
        }

        public boolean set(T value) {
            boolean wasSet;
            this.attemptedSetting = true;
            SafeFuture<T> localFuture = this.future;
            boolean bl = wasSet = localFuture != null && localFuture.set(value);
            if (wasSet) {
                this.setCompletedNormally();
            }
            return wasSet;
        }

        public boolean setException(@NonNull Throwable t) {
            boolean wasSet;
            this.attemptedSetting = true;
            SafeFuture<T> localFuture = this.future;
            boolean bl = wasSet = localFuture != null && localFuture.setException(t);
            if (wasSet) {
                this.setCompletedNormally();
            }
            return wasSet;
        }

        public boolean setCancelled() {
            boolean wasSet;
            this.attemptedSetting = true;
            SafeFuture<T> localFuture = this.future;
            boolean bl = wasSet = localFuture != null && localFuture.cancelWithoutNotifyingCompleter(true);
            if (wasSet) {
                this.setCompletedNormally();
            }
            return wasSet;
        }

        public void addCancellationListener(@NonNull Runnable runnable, @NonNull Executor executor) {
            ResolvableFuture<Void> localCancellationFuture = this.cancellationFuture;
            if (localCancellationFuture != null) {
                localCancellationFuture.addListener(runnable, executor);
            }
        }

        void fireCancellationListeners() {
            this.tag = null;
            this.future = null;
            this.cancellationFuture.set(null);
        }

        private void setCompletedNormally() {
            this.tag = null;
            this.future = null;
            this.cancellationFuture = null;
        }

        protected void finalize() {
            ResolvableFuture<Void> localCancellationFuture;
            SafeFuture<T> localFuture = this.future;
            if (localFuture != null && !localFuture.isDone()) {
                localFuture.setException(new FutureGarbageCollectedException("The completer object was garbage collected - this future would otherwise never complete. The tag was: " + this.tag));
            }
            if (!this.attemptedSetting && (localCancellationFuture = this.cancellationFuture) != null) {
                localCancellationFuture.set(null);
            }
        }
    }

    private static final class SafeFuture<T>
    implements ListenableFuture<T> {
        final WeakReference<Completer<T>> completerWeakReference;
        private final AbstractResolvableFuture<T> delegate = new AbstractResolvableFuture<T>(){

            @Override
            protected String pendingToString() {
                Completer completer = (Completer)completerWeakReference.get();
                if (completer == null) {
                    return "Completer object has been garbage collected, future will fail soon";
                }
                return "tag=[" + completer.tag + "]";
            }
        };

        SafeFuture(Completer<T> completer) {
            this.completerWeakReference = new WeakReference<Completer<Completer<T>>>(completer);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            Completer completer = (Completer)this.completerWeakReference.get();
            boolean cancelled = this.delegate.cancel(mayInterruptIfRunning);
            if (cancelled && completer != null) {
                completer.fireCancellationListeners();
            }
            return cancelled;
        }

        boolean cancelWithoutNotifyingCompleter(boolean shouldInterrupt) {
            return this.delegate.cancel(shouldInterrupt);
        }

        boolean set(T value) {
            return this.delegate.set(value);
        }

        boolean setException(Throwable t) {
            return this.delegate.setException(t);
        }

        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        public boolean isDone() {
            return this.delegate.isDone();
        }

        public T get() throws InterruptedException, ExecutionException {
            return this.delegate.get();
        }

        public T get(long timeout, @NonNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.get(timeout, unit);
        }

        public void addListener(@NonNull Runnable listener, @NonNull Executor executor) {
            this.delegate.addListener(listener, executor);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    public static interface Resolver<T> {
        @Nullable
        public Object attachCompleter(@NonNull Completer<T> var1) throws Exception;
    }

    static final class FutureGarbageCollectedException
    extends Throwable {
        FutureGarbageCollectedException(String message) {
            super(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

