/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test.junit4;

import android.os.Handler;
import android.os.Looper;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import androidx.compose.ui.platform.ViewRootForTest;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewTreeLifecycleOwner;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001:\u0002$%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rJ\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\tH\u0002J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0015\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001dJ\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rJ\b\u0010\u001f\u001a\u00020\u0010H\u0002J\r\u0010 \u001a\u00020\u0010H\u0001\u00a2\u0006\u0002\b!J\u0015\u0010\"\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b#R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Landroidx/compose/ui/test/junit4/ComposeRootRegistry;", "", "()V", "allRoots", "", "Landroidx/compose/ui/platform/ViewRootForTest;", "kotlin.jvm.PlatformType", "", "isSetUp", "", "()Z", "lock", "registryListeners", "Landroidx/compose/ui/test/junit4/ComposeRootRegistry$OnRegistrationChangedListener;", "resumedRoots", "addOnRegistrationChangedListener", "", "listener", "dispatchOnRegistrationChanged", "composeRoot", "isRegistered", "getCreatedComposeRoots", "getRegisteredComposeRoots", "getStatementFor", "Lorg/junit/runners/model/Statement;", "base", "onViewRootCreated", "root", "registerComposeRoot", "registerComposeRoot$ui_test_junit4_release", "removeOnRegistrationChangedListener", "setupRegistry", "tearDownRegistry", "tearDownRegistry$ui_test_junit4_release", "unregisterComposeRoot", "unregisterComposeRoot$ui_test_junit4_release", "OnRegistrationChangedListener", "StateChangeHandler", "ui-test-junit4_release"})
public final class ComposeRootRegistry {
    @NotNull
    private final Object lock = new Object();
    private final Set<ViewRootForTest> allRoots = Collections.newSetFromMap(new WeakHashMap());
    @NotNull
    private final Set<ViewRootForTest> resumedRoots = new LinkedHashSet();
    @NotNull
    private final Set<OnRegistrationChangedListener> registryListeners = new LinkedHashSet();

    public final boolean isSetUp() {
        return Intrinsics.areEqual((Object)ViewRootForTest.Companion.getOnViewCreatedCallback(), (Object)new Function1<ViewRootForTest, Unit>((Object)this){

            public final void invoke(@NotNull ViewRootForTest p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ComposeRootRegistry.access$onViewRootCreated((ComposeRootRegistry)this.receiver, p0);
            }
        });
    }

    private final void setupRegistry() {
        ViewRootForTest.Companion.setOnViewCreatedCallback((Function1)new Function1<ViewRootForTest, Unit>((Object)this){

            public final void invoke(@NotNull ViewRootForTest p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ComposeRootRegistry.access$onViewRootCreated((ComposeRootRegistry)this.receiver, p0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=2)
    public final void tearDownRegistry$ui_test_junit4_release() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            ViewRootForTest.Companion.setOnViewCreatedCallback(null);
            Iterable $this$forEach$iv = this.getCreatedComposeRoots();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ViewRootForTest it = (ViewRootForTest)element$iv;
                boolean bl2 = false;
                this.unregisterComposeRoot$ui_test_junit4_release(it);
            }
            this.allRoots.clear();
            this.resumedRoots.clear();
            this.registryListeners.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onViewRootCreated(ViewRootForTest root) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.isSetUp()) {
                this.allRoots.add(root);
                root.getView().addOnAttachStateChangeListener((View.OnAttachStateChangeListener)new StateChangeHandler(root));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final Set<ViewRootForTest> getCreatedComposeRoots() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            while (true) {
                try {
                    Set<ViewRootForTest> set = this.allRoots;
                    Intrinsics.checkNotNullExpressionValue(set, (String)"allRoots");
                    return CollectionsKt.toSet((Iterable)set);
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    continue;
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<ViewRootForTest> getRegisteredComposeRoots() {
        Set set;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            set = CollectionsKt.toSet((Iterable)this.resumedRoots);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerComposeRoot$ui_test_junit4_release(@NotNull ViewRootForTest composeRoot) {
        Intrinsics.checkNotNullParameter((Object)composeRoot, (String)"composeRoot");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.isSetUp() && this.resumedRoots.add(composeRoot)) {
                this.dispatchOnRegistrationChanged(composeRoot, true);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterComposeRoot$ui_test_junit4_release(@NotNull ViewRootForTest composeRoot) {
        Intrinsics.checkNotNullParameter((Object)composeRoot, (String)"composeRoot");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.resumedRoots.remove(composeRoot)) {
                this.dispatchOnRegistrationChanged(composeRoot, false);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final Statement getStatementFor(@NotNull Statement base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        return new Statement(this, base){
            final /* synthetic */ ComposeRootRegistry this$0;
            final /* synthetic */ Statement $base;
            {
                this.this$0 = $receiver;
                this.$base = $base;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() {
                try {
                    ComposeRootRegistry.access$setupRegistry(this.this$0);
                    this.$base.evaluate();
                }
                finally {
                    this.this$0.tearDownRegistry$ui_test_junit4_release();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addOnRegistrationChangedListener(@NotNull OnRegistrationChangedListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.registryListeners.add(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeOnRegistrationChangedListener(@NotNull OnRegistrationChangedListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.registryListeners.remove(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dispatchOnRegistrationChanged(ViewRootForTest composeRoot, boolean isRegistered) {
        List $i$a$-synchronized-ComposeRootRegistry$dispatchOnRegistrationChanged$22;
        Object object = this.lock;
        synchronized (object) {
            boolean $i$a$-synchronized-ComposeRootRegistry$dispatchOnRegistrationChanged$22 = false;
            $i$a$-synchronized-ComposeRootRegistry$dispatchOnRegistrationChanged$22 = CollectionsKt.toList((Iterable)this.registryListeners);
        }
        Iterable $this$forEach$iv = $i$a$-synchronized-ComposeRootRegistry$dispatchOnRegistrationChanged$22;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnRegistrationChangedListener it = (OnRegistrationChangedListener)element$iv;
            boolean bl = false;
            it.onRegistrationChanged(composeRoot, isRegistered);
        }
    }

    public static final /* synthetic */ void access$onViewRootCreated(ComposeRootRegistry $this, ViewRootForTest root) {
        $this.onViewRootCreated(root);
    }

    public static final /* synthetic */ void access$setupRegistry(ComposeRootRegistry $this) {
        $this.setupRegistry();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Landroidx/compose/ui/test/junit4/ComposeRootRegistry$OnRegistrationChangedListener;", "", "onRegistrationChanged", "", "composeRoot", "Landroidx/compose/ui/platform/ViewRootForTest;", "registered", "", "ui-test-junit4_release"})
    public static interface OnRegistrationChangedListener {
        public void onRegistrationChanged(@NotNull ViewRootForTest var1, boolean var2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\tH\u0002J\b\u0010\u0017\u001a\u00020\tH\u0002J\b\u0010\u0018\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/compose/ui/test/junit4/ComposeRootRegistry$StateChangeHandler;", "Landroid/view/View$OnAttachStateChangeListener;", "Landroidx/lifecycle/LifecycleEventObserver;", "Landroidx/compose/ui/test/junit4/ComposeRootRegistry$OnRegistrationChangedListener;", "composeRoot", "Landroidx/compose/ui/platform/ViewRootForTest;", "(Landroidx/compose/ui/test/junit4/ComposeRootRegistry;Landroidx/compose/ui/platform/ViewRootForTest;)V", "removeObserver", "Lkotlin/Function0;", "", "onRegistrationChanged", "registered", "", "onStateChanged", "source", "Landroidx/lifecycle/LifecycleOwner;", "event", "Landroidx/lifecycle/Lifecycle$Event;", "onViewAttachedToWindow", "view", "Landroid/view/View;", "onViewDetachedFromWindow", "removeLifecycleObserver", "removeLifecycleObserverMainThread", "unregisterComposeRoot", "ui-test-junit4_release"})
    private final class StateChangeHandler
    implements View.OnAttachStateChangeListener,
    LifecycleEventObserver,
    OnRegistrationChangedListener {
        @NotNull
        private final ViewRootForTest composeRoot;
        @Nullable
        private Function0<Unit> removeObserver;

        public StateChangeHandler(ViewRootForTest composeRoot) {
            Intrinsics.checkNotNullParameter((Object)ComposeRootRegistry.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)composeRoot, (String)"composeRoot");
            this.composeRoot = composeRoot;
        }

        public void onViewAttachedToWindow(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            LifecycleOwner lifecycleOwner = ViewTreeLifecycleOwner.get((View)view);
            Object object = lifecycleOwner == null ? null : lifecycleOwner.getLifecycle();
            if (object == null) {
                return;
            }
            Lifecycle lifecycle = object;
            lifecycle.addObserver((LifecycleObserver)this);
            this.removeObserver = (Function0)new Function0<Unit>(lifecycle, this){
                final /* synthetic */ Lifecycle $lifecycle;
                final /* synthetic */ StateChangeHandler this$0;
                {
                    this.$lifecycle = $lifecycle;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.$lifecycle.removeObserver((LifecycleObserver)this.this$0);
                }
            };
        }

        public void onViewDetachedFromWindow(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            this.removeLifecycleObserver();
            this.unregisterComposeRoot();
        }

        public void onStateChanged(@NotNull LifecycleOwner source, @NotNull Lifecycle.Event event) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event == Lifecycle.Event.ON_RESUME) {
                ComposeRootRegistry.this.registerComposeRoot$ui_test_junit4_release(this.composeRoot);
                ComposeRootRegistry.this.addOnRegistrationChangedListener(this);
            } else {
                this.unregisterComposeRoot();
            }
        }

        @Override
        public void onRegistrationChanged(@NotNull ViewRootForTest composeRoot, boolean registered) {
            Intrinsics.checkNotNullParameter((Object)composeRoot, (String)"composeRoot");
            if (Intrinsics.areEqual((Object)composeRoot, (Object)this.composeRoot) && !registered) {
                this.removeLifecycleObserver();
            }
        }

        private final void unregisterComposeRoot() {
            ComposeRootRegistry.this.removeOnRegistrationChangedListener(this);
            ComposeRootRegistry.this.unregisterComposeRoot$ui_test_junit4_release(this.composeRoot);
        }

        private final void removeLifecycleObserver() {
            if (!Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
                new Handler(Looper.getMainLooper()).postAtFrontOfQueue(() -> StateChangeHandler.removeLifecycleObserver$lambda-0(this));
            } else {
                this.removeLifecycleObserverMainThread();
            }
        }

        private final void removeLifecycleObserverMainThread() {
            Function0<Unit> function0 = this.removeObserver;
            if (function0 != null) {
                Unit unit;
                Unit unit2;
                function0.invoke();
                Unit it = unit2 = (unit = Unit.INSTANCE);
                boolean bl = false;
                this.removeObserver = null;
            }
        }

        private static final void removeLifecycleObserver$lambda-0(StateChangeHandler this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.removeLifecycleObserverMainThread();
        }
    }
}

