/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import android.graphics.BitmapShader;
import android.graphics.LinearGradient;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.os.Build;
import androidx.annotation.VisibleForTesting;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.AndroidImageBitmap_androidKt;
import androidx.compose.ui.graphics.AndroidTileMode_androidKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.ImageBitmap;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a1\u0010\u0000\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\b\u0010\t\u001aO\u0010\n\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0006H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001aO\u0010\u0016\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0006H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a?\u0010\u001b\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\u0017\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000fH\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a\u0019\u0010\u001e\u001a\u00020\u001f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0001\u00f8\u0001\u0000\u001a!\u0010 \u001a\u00020!2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\"\u001a\u00020\u001fH\u0001\u00f8\u0001\u0000\u001a3\u0010#\u001a\u0004\u0018\u00010$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\"\u001a\u00020\u001fH\u0001\u00f8\u0001\u0000\u001a)\u0010&\u001a\u00020'2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000fH\u0002\u00f8\u0001\u0000*\n\u0010(\"\u00020\u00012\u00020\u0001\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006)"}, d2={"ActualImageShader", "Landroid/graphics/Shader;", "Landroidx/compose/ui/graphics/Shader;", "image", "Landroidx/compose/ui/graphics/ImageBitmap;", "tileModeX", "Landroidx/compose/ui/graphics/TileMode;", "tileModeY", "ActualImageShader-F49vj9s", "(Landroidx/compose/ui/graphics/ImageBitmap;II)Landroid/graphics/Shader;", "ActualLinearGradientShader", "from", "Landroidx/compose/ui/geometry/Offset;", "to", "colors", "", "Landroidx/compose/ui/graphics/Color;", "colorStops", "", "tileMode", "ActualLinearGradientShader-VjE6UOU", "(JJLjava/util/List;Ljava/util/List;I)Landroid/graphics/Shader;", "ActualRadialGradientShader", "center", "radius", "ActualRadialGradientShader-8uybcMk", "(JFLjava/util/List;Ljava/util/List;I)Landroid/graphics/Shader;", "ActualSweepGradientShader", "ActualSweepGradientShader-9KIMszo", "(JLjava/util/List;Ljava/util/List;)Landroid/graphics/Shader;", "countTransparentColors", "", "makeTransparentColors", "", "numTransparentColors", "makeTransparentStops", "", "stops", "validateColorStops", "", "Shader", "ui-graphics_release"})
public final class AndroidShader_androidKt {
    @NotNull
    public static final Shader ActualLinearGradientShader-VjE6UOU(long from, long to, @NotNull List<Color> colors, @Nullable List<Float> colorStops, int tileMode) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        AndroidShader_androidKt.validateColorStops(colors, colorStops);
        int numTransparentColors = AndroidShader_androidKt.countTransparentColors(colors);
        return (Shader)new LinearGradient(Offset.getX-impl((long)from), Offset.getY-impl((long)from), Offset.getX-impl((long)to), Offset.getY-impl((long)to), AndroidShader_androidKt.makeTransparentColors(colors, numTransparentColors), AndroidShader_androidKt.makeTransparentStops(colorStops, colors, numTransparentColors), AndroidTileMode_androidKt.toAndroidTileMode-0vamqd0(tileMode));
    }

    @NotNull
    public static final Shader ActualRadialGradientShader-8uybcMk(long center, float radius, @NotNull List<Color> colors, @Nullable List<Float> colorStops, int tileMode) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        AndroidShader_androidKt.validateColorStops(colors, colorStops);
        int numTransparentColors = AndroidShader_androidKt.countTransparentColors(colors);
        return (Shader)new RadialGradient(Offset.getX-impl((long)center), Offset.getY-impl((long)center), radius, AndroidShader_androidKt.makeTransparentColors(colors, numTransparentColors), AndroidShader_androidKt.makeTransparentStops(colorStops, colors, numTransparentColors), AndroidTileMode_androidKt.toAndroidTileMode-0vamqd0(tileMode));
    }

    @NotNull
    public static final Shader ActualSweepGradientShader-9KIMszo(long center, @NotNull List<Color> colors, @Nullable List<Float> colorStops) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        AndroidShader_androidKt.validateColorStops(colors, colorStops);
        int numTransparentColors = AndroidShader_androidKt.countTransparentColors(colors);
        return (Shader)new SweepGradient(Offset.getX-impl((long)center), Offset.getY-impl((long)center), AndroidShader_androidKt.makeTransparentColors(colors, numTransparentColors), AndroidShader_androidKt.makeTransparentStops(colorStops, colors, numTransparentColors));
    }

    @NotNull
    public static final Shader ActualImageShader-F49vj9s(@NotNull ImageBitmap image, int tileModeX, int tileModeY) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return (Shader)new BitmapShader(AndroidImageBitmap_androidKt.asAndroidBitmap(image), AndroidTileMode_androidKt.toAndroidTileMode-0vamqd0(tileModeX), AndroidTileMode_androidKt.toAndroidTileMode-0vamqd0(tileModeY));
    }

    @VisibleForTesting
    public static final int countTransparentColors(@NotNull List<Color> colors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        if (Build.VERSION.SDK_INT >= 26) {
            return 0;
        }
        int numTransparentColors = 0;
        int n = 1;
        int n2 = CollectionsKt.getLastIndex(colors);
        while (n < n2) {
            int i;
            if (!(Color.getAlpha-impl(colors.get(i = n++).unbox-impl()) == 0.0f)) continue;
            int n3 = numTransparentColors;
            numTransparentColors = n3 + 1;
        }
        return numTransparentColors;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final int[] makeTransparentColors(@NotNull List<Color> colors, int numTransparentColors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        if (Build.VERSION.SDK_INT >= 26) {
            int n = 0;
            int n2 = colors.size();
            int[] nArray = new int[n2];
            while (n < n2) {
                int n3 = n++;
                nArray[n3] = ColorKt.toArgb-8_81llA(colors.get(n3).unbox-impl());
            }
            return nArray;
        }
        int[] values = new int[colors.size() + numTransparentColors];
        int valuesIndex = 0;
        int lastIndex = CollectionsKt.getLastIndex(colors);
        List<Color> $this$fastForEachIndexed$iv = colors;
        boolean $i$f$fastForEachIndexed = false;
        int n = 0;
        int n4 = $this$fastForEachIndexed$iv.size();
        while (n < n4) {
            int n5;
            void color;
            int index$iv = n++;
            Color item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            long l = item$iv.unbox-impl();
            int index = index$iv;
            boolean bl = false;
            if (Color.getAlpha-impl((long)color) == 0.0f) {
                if (index == 0) {
                    n5 = valuesIndex;
                    valuesIndex = n5 + 1;
                    values[n5] = ColorKt.toArgb-8_81llA(Color.copy-wmQWz5c$default(colors.get(1).unbox-impl(), 0.0f, 0.0f, 0.0f, 0.0f, 14, null));
                    continue;
                }
                if (index == lastIndex) {
                    n5 = valuesIndex;
                    valuesIndex = n5 + 1;
                    values[n5] = ColorKt.toArgb-8_81llA(Color.copy-wmQWz5c$default(colors.get(index - 1).unbox-impl(), 0.0f, 0.0f, 0.0f, 0.0f, 14, null));
                    continue;
                }
                long previousColor = colors.get(index - 1).unbox-impl();
                int n6 = valuesIndex;
                valuesIndex = n6 + 1;
                values[n6] = ColorKt.toArgb-8_81llA(Color.copy-wmQWz5c$default(previousColor, 0.0f, 0.0f, 0.0f, 0.0f, 14, null));
                long nextColor = colors.get(index + 1).unbox-impl();
                int n7 = valuesIndex;
                valuesIndex = n7 + 1;
                values[n7] = ColorKt.toArgb-8_81llA(Color.copy-wmQWz5c$default(nextColor, 0.0f, 0.0f, 0.0f, 0.0f, 14, null));
                continue;
            }
            n5 = valuesIndex;
            valuesIndex = n5 + 1;
            values[n5] = ColorKt.toArgb-8_81llA((long)color);
        }
        return values;
    }

    @VisibleForTesting
    @Nullable
    public static final float[] makeTransparentStops(@Nullable List<Float> stops, @NotNull List<Color> colors, int numTransparentColors) {
        float f;
        float f2;
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        if (numTransparentColors == 0) {
            List<Float> list = stops;
            return list == null ? null : CollectionsKt.toFloatArray((Collection)list);
        }
        float[] newStops = new float[colors.size() + numTransparentColors];
        List<Float> list = stops;
        if (list == null) {
            f2 = 0.0f;
        } else {
            Float f3 = list.get(0);
            f2 = f3 == null ? 0.0f : f3.floatValue();
        }
        newStops[0] = f2;
        int newStopsIndex = 1;
        int n = 1;
        int n2 = CollectionsKt.getLastIndex(colors);
        while (n < n2) {
            int i = n++;
            long color = colors.get(i).unbox-impl();
            List<Float> list2 = stops;
            Float f4 = list2 == null ? null : list2.get(i);
            float stop = f4 == null ? (float)i / (float)CollectionsKt.getLastIndex(colors) : f4.floatValue();
            int n3 = newStopsIndex;
            newStopsIndex = n3 + 1;
            newStops[n3] = stop;
            if (!(Color.getAlpha-impl(color) == 0.0f)) continue;
            n3 = newStopsIndex;
            newStopsIndex = n3 + 1;
            newStops[n3] = stop;
        }
        List<Float> list3 = stops;
        if (list3 == null) {
            f = 1.0f;
        } else {
            Float f5 = list3.get(CollectionsKt.getLastIndex(colors));
            f = f5 == null ? 1.0f : f5.floatValue();
        }
        newStops[newStopsIndex] = f;
        return newStops;
    }

    private static final void validateColorStops(List<Color> colors, List<Float> colorStops) {
        if (colorStops == null) {
            if (colors.size() < 2) {
                throw new IllegalArgumentException("colors must have length of at least 2 if colorStops is omitted.");
            }
        } else if (colors.size() != colorStops.size()) {
            throw new IllegalArgumentException("colors and colorStops arguments must have equal length.");
        }
    }
}

