/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.lint;

import androidx.compose.lint.ComposableUtilsKt;
import androidx.compose.lint.PsiUtilsKt;
import androidx.compose.runtime.lint.ComposableStateFlowValueDetectorKt;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\r"}, d2={"Landroidx/compose/runtime/lint/ComposableStateFlowValueDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "Companion", "runtime-lint"})
public final class ComposableStateFlowValueDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue StateFlowValueCalledInComposition = Issue.Companion.create("StateFlowValueCalledInComposition", "StateFlow.value should not be called within composition", "Calling StateFlow.value within composition will not observe changes to the StateFlow, so changes might not be reflected within the composition. Instead you should use stateFlow.collectAsState() to observe changes to the StateFlow, and recompose when it changes.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(ComposableStateFlowValueDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<Class<USimpleNameReferenceExpression>> getApplicableUastTypes() {
        return CollectionsKt.listOf(USimpleNameReferenceExpression.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            public void visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                if (!Intrinsics.areEqual((Object)node.getIdentifier(), (Object)"value")) {
                    return;
                }
                PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)node));
                PsiMethod psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
                if (psiMethod == null) {
                    return;
                }
                PsiMethod method = psiMethod;
                PsiClass psiClass = method.getContainingClass();
                boolean bl = psiClass != null ? PsiUtilsKt.inheritsFrom(psiClass, ComposableStateFlowValueDetectorKt.access$getStateFlowName$p()) : false;
                if (bl && ComposableUtilsKt.isInvokedWithinComposable((UExpression)node)) {
                    JavaContext.report$default((JavaContext)this.$context, (Issue)ComposableStateFlowValueDetector.Companion.getStateFlowValueCalledInComposition(), (UElement)((UElement)node), (Location)this.$context.getNameLocation((UElement)node), (String)"StateFlow.value should not be called within composition", null, (int)16, null);
                }
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/runtime/lint/ComposableStateFlowValueDetector$Companion;", "", "()V", "StateFlowValueCalledInComposition", "Lcom/android/tools/lint/detector/api/Issue;", "getStateFlowValueCalledInComposition", "()Lcom/android/tools/lint/detector/api/Issue;", "runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getStateFlowValueCalledInComposition() {
            return StateFlowValueCalledInComposition;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

