/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.lint;

import androidx.compose.lint.KotlinUtilsKt;
import androidx.compose.lint.Name;
import androidx.compose.lint.Names;
import androidx.compose.lint.PsiUtilsKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.kotlin.KotlinUFunctionCallExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/compose/runtime/lint/AutoboxingStateCreationDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "replacements", "", "", "Landroidx/compose/lint/Name;", "createLintFix", "Lcom/android/tools/lint/detector/api/LintFix;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "replacementFunction", "getApplicableMethodNames", "", "getSuggestedReplacementName", "invocation", "Lorg/jetbrains/uast/kotlin/KotlinUFunctionCallExpression;", "usesStructuralEqualityPolicy", "", "visitMethodCall", "", "method", "Lcom/intellij/psi/PsiMethod;", "getLocationOfArgumentsList", "Lcom/android/tools/lint/detector/api/Location;", "getLocationOfTypeArguments", "Companion", "runtime-lint"})
@SourceDebugExtension(value={"SMAP\nAutoboxingStateCreationDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoboxingStateCreationDetector.kt\nandroidx/compose/runtime/lint/AutoboxingStateCreationDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,182:1\n1#2:183\n37#3,2:184\n23#4,2:186\n23#4,2:188\n*S KotlinDebug\n*F\n+ 1 AutoboxingStateCreationDetector.kt\nandroidx/compose/runtime/lint/AutoboxingStateCreationDetector\n*L\n116#1:184,2\n120#1:186,2\n126#1:188,2\n*E\n"})
public final class AutoboxingStateCreationDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Name> replacements;
    private static final int VALUE_PARAM_IDX = 0;
    private static final int MUTATION_POLICY_PARAM_IDX = 1;
    @NotNull
    private static final Issue AutoboxingStateCreation = Issue.Companion.create("AutoboxingStateCreation", "`State<T>` will autobox values assigned to this state. Use a specialized state type instead.", "Calling `mutableStateOf<T>()` when `T` is either backed by a primitive type on the JVM or is a value class results in a state implementation that requires all state values to be boxed. This usually causes an additional allocation for each state write, and adds some additional work to auto-unbox values when reading the value of the state. Instead, prefer to use a specialized primitive state implementation for `Int`, `Long`, `Float`, and `Double` when the state does not need to track null values and does not override the default `SnapshotMutationPolicy`.", Category.PERFORMANCE, 3, Severity.INFORMATIONAL, new Implementation(AutoboxingStateCreationDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE)));

    public AutoboxingStateCreationDetector() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"kotlin.Int", (Object)Names.Runtime.INSTANCE.getMutableIntStateOf()), TuplesKt.to((Object)"kotlin.Long", (Object)Names.Runtime.INSTANCE.getMutableLongStateOf()), TuplesKt.to((Object)"kotlin.Float", (Object)Names.Runtime.INSTANCE.getMutableFloatStateOf()), TuplesKt.to((Object)"kotlin.Double", (Object)Names.Runtime.INSTANCE.getMutableDoubleStateOf())};
        this.replacements = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)Names.Runtime.INSTANCE.getMutableStateOf().getShortName());
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!PsiUtilsKt.isInPackageName(method, Names.Runtime.INSTANCE.getPackageName())) {
            return;
        }
        Name name = this.getSuggestedReplacementName((KotlinUFunctionCallExpression)node);
        if (name == null) {
            return;
        }
        Name replacement = name;
        context.report(AutoboxingStateCreation, (UElement)node, context.getNameLocation((UElement)node), "Prefer `" + replacement.getShortName() + "` instead of `" + method.getName() + "`", this.createLintFix(context, node, replacement));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final LintFix createLintFix(JavaContext context, UCallExpression node, Name replacementFunction) {
        var5_4 = new LintFix[3];
        var5_4[0] = LintFix.Companion.create().replace().range(context.getNameLocation((UElement)node)).with(replacementFunction.getJavaFqn()).shortenNames(true).build();
        v0 = var5_4;
        v1 = 1;
        var6_5 = this.getLocationOfTypeArguments(context, node);
        if (var6_5 != null) {
            var8_6 = var6_5;
            var17_7 = v1;
            var16_8 = v0;
            $i$a$-let-AutoboxingStateCreationDetector$createLintFix$fixes$1 = false;
            var18_11 = LintFix.Companion.create().replace().range(it).with("").build();
            v0 = var16_8;
            v1 = var17_7;
            v2 = var18_11;
        } else {
            v2 = null;
        }
        v0[v1] = v2;
        v3 = var5_4;
        v4 = 2;
        var6_5 = this.getLocationOfArgumentsList(context, node);
        if (var6_5 == null) ** GOTO lbl-1000
        $i$a$-let-AutoboxingStateCreationDetector$createLintFix$fixes$1 = it = var6_5;
        var17_7 = v4;
        var16_8 = v3;
        $i$a$-takeIf-AutoboxingStateCreationDetector$createLintFix$fixes$2 = false;
        var18_12 = node.getArgumentForParameter(1) != null;
        v3 = var16_8;
        v4 = var17_7;
        v5 /* !! */  = var7_15 = var18_12 != false ? it : null;
        if (var7_15 != null) {
            it = var7_15;
            var17_7 = v4;
            var16_8 = v3;
            $i$a$-let-AutoboxingStateCreationDetector$createLintFix$fixes$3 = false;
            var11_17 = node.getArgumentForParameter(0);
            if (var11_17 != null && (var12_18 = var11_17.getSourcePsi()) != null && (var13_19 = var12_18.getText()) != null) {
                valueArg = var13_19;
                $i$a$-let-AutoboxingStateCreationDetector$createLintFix$fixes$3$1 = false;
                v6 = LintFix.Companion.create().replace().range((Location)argsListLocation).with("(" + valueArg + ")").build();
            } else {
                v6 = null;
            }
            var18_13 = v6;
            v3 = var16_8;
            v4 = var17_7;
            v7 = var18_13;
        } else lbl-1000:
        // 2 sources

        {
            v7 = null;
        }
        v3[v4] = v7;
        fixes = CollectionsKt.listOfNotNull((Object[])var5_4);
        $this$toTypedArray$iv = fixes;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        var5_4 = thisCollection$iv.toArray(new LintFix[0]);
        return LintFix.Companion.create().name("Replace with " + replacementFunction.getShortName()).composite((LintFix[])Arrays.copyOf(var5_4, var5_4.length));
    }

    private final Location getLocationOfTypeArguments(JavaContext $this$getLocationOfTypeArguments, UCallExpression node) {
        KtTypeArgumentList ktTypeArgumentList;
        block5: {
            block4: {
                PsiElement psiElement;
                block3: {
                    ktTypeArgumentList = node.getSourcePsi();
                    if (ktTypeArgumentList == null || (ktTypeArgumentList = ktTypeArgumentList.getChildren()) == null) break block4;
                    KtTypeArgumentList $this$firstIsInstanceOrNull$iv = ktTypeArgumentList;
                    boolean $i$f$firstIsInstanceOrNull = false;
                    for (PsiElement element$iv : $this$firstIsInstanceOrNull$iv) {
                        if (!(element$iv instanceof KtTypeArgumentList)) continue;
                        psiElement = element$iv;
                        break block3;
                    }
                    psiElement = null;
                }
                if ((ktTypeArgumentList = (KtTypeArgumentList)psiElement) != null) break block5;
            }
            return null;
        }
        KtTypeArgumentList typeArgsList = ktTypeArgumentList;
        return $this$getLocationOfTypeArguments.getLocation((PsiElement)typeArgsList);
    }

    private final Location getLocationOfArgumentsList(JavaContext $this$getLocationOfArgumentsList, UCallExpression node) {
        KtValueArgumentList ktValueArgumentList;
        block5: {
            block4: {
                PsiElement psiElement;
                block3: {
                    ktValueArgumentList = node.getSourcePsi();
                    if (ktValueArgumentList == null || (ktValueArgumentList = ktValueArgumentList.getChildren()) == null) break block4;
                    KtValueArgumentList $this$firstIsInstanceOrNull$iv = ktValueArgumentList;
                    boolean $i$f$firstIsInstanceOrNull = false;
                    for (PsiElement element$iv : $this$firstIsInstanceOrNull$iv) {
                        if (!(element$iv instanceof KtValueArgumentList)) continue;
                        psiElement = element$iv;
                        break block3;
                    }
                    psiElement = null;
                }
                if ((ktValueArgumentList = (KtValueArgumentList)psiElement) != null) break block5;
            }
            return null;
        }
        KtValueArgumentList argsList = ktValueArgumentList;
        return $this$getLocationOfArgumentsList.getLocation((PsiElement)argsList);
    }

    private final Name getSuggestedReplacementName(KotlinUFunctionCallExpression invocation) {
        Name name;
        if (!this.usesStructuralEqualityPolicy(invocation)) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = KotlinUtilsKt.resolveCall(invocation);
        if (resolvedCall == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = resolvedCall;
        Map map = resolvedCall2.getTypeArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"resolvedCall.typeArguments");
        KotlinType stateType = (KotlinType)((Map.Entry)CollectionsKt.single((Iterable)map.entrySet())).getValue();
        if (stateType.isMarkedNullable()) {
            name = null;
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)stateType, (String)"stateType");
            name = this.replacements.get(DescriptorUtilsKt.getJetTypeFqName((KotlinType)stateType, (boolean)true));
        }
        return name;
    }

    private final boolean usesStructuralEqualityPolicy(KotlinUFunctionCallExpression invocation) {
        UExpression uExpression;
        UExpression uExpression2 = (UExpression)CollectionsKt.getOrNull((List)invocation.getValueArguments(), (int)1);
        if (uExpression2 == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression2)) == null) {
            return true;
        }
        UExpression policyExpr = uExpression;
        KotlinUFunctionCallExpression kotlinUFunctionCallExpression = policyExpr instanceof KotlinUFunctionCallExpression ? (KotlinUFunctionCallExpression)policyExpr : null;
        if (kotlinUFunctionCallExpression == null || (kotlinUFunctionCallExpression = kotlinUFunctionCallExpression.resolve()) == null) {
            return false;
        }
        KotlinUFunctionCallExpression policyMethod = kotlinUFunctionCallExpression;
        return PsiUtilsKt.isInPackageName((PsiMethod)policyMethod, Names.Runtime.INSTANCE.getPackageName()) && Intrinsics.areEqual((Object)policyMethod.getName(), (Object)Names.Runtime.INSTANCE.getStructuralEqualityPolicy().getShortName());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/compose/runtime/lint/AutoboxingStateCreationDetector$Companion;", "", "()V", "AutoboxingStateCreation", "Lcom/android/tools/lint/detector/api/Issue;", "getAutoboxingStateCreation", "()Lcom/android/tools/lint/detector/api/Issue;", "MUTATION_POLICY_PARAM_IDX", "", "VALUE_PARAM_IDX", "runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getAutoboxingStateCreation() {
            return AutoboxingStateCreation;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

