/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.lint;

import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.USimpleNameReferenceExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002Jr\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u00102\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0016R\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u0004\u0018\u00010\u0005*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u0004\u0018\u00010\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\u00a8\u0006$"}, d2={"Landroidx/compose/runtime/lint/AutoboxingStateValuePropertyDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "identifier", "", "Lorg/jetbrains/uast/UElement;", "getIdentifier", "(Lorg/jetbrains/uast/UElement;)Ljava/lang/String;", "preferredPropertyName", "Lorg/jetbrains/uast/UAnnotation;", "getPreferredPropertyName", "(Lorg/jetbrains/uast/UAnnotation;)Ljava/lang/String;", "resolvedName", "getResolvedName", "applicableAnnotations", "", "createPropertyReplacementQuickFix", "Lcom/android/tools/lint/detector/api/LintFix;", "resolvedPropertyName", "visitAnnotationUsage", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "usage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "annotation", "qualifiedName", "method", "Lcom/intellij/psi/PsiMethod;", "annotations", "allMemberAnnotations", "allClassAnnotations", "allPackageAnnotations", "Companion", "runtime-lint"})
@SourceDebugExtension(value={"SMAP\nAutoboxingStateValuePropertyDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoboxingStateValuePropertyDetector.kt\nandroidx/compose/runtime/lint/AutoboxingStateValuePropertyDetector\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,118:1\n643#2,5:119\n*S KotlinDebug\n*F\n+ 1 AutoboxingStateValuePropertyDetector.kt\nandroidx/compose/runtime/lint/AutoboxingStateValuePropertyDetector\n*L\n71#1:119,5\n*E\n"})
public final class AutoboxingStateValuePropertyDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue AutoboxingStateValueProperty = Issue.Companion.create("AutoboxingStateValueProperty", "State access causes value to be autoboxed", "Avoid using the generic value accessor when using a State objects with a specialized types. Usages of the generic value property result in an unnecessary autoboxing operation whenever the state's value is read or written to. Use the specialized value accessor or property delegation to avoid unnecessary allocations.", Category.PERFORMANCE, 3, Severity.WARNING, new Implementation(AutoboxingStateValuePropertyDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    private final String getPreferredPropertyName(UAnnotation $this$preferredPropertyName) {
        return UastLintUtils.Companion.getAnnotationStringValue($this$preferredPropertyName, "preferredPropertyName");
    }

    private final String getIdentifier(UElement $this$identifier) {
        USimpleNameReferenceExpression uSimpleNameReferenceExpression = $this$identifier instanceof USimpleNameReferenceExpression ? (USimpleNameReferenceExpression)$this$identifier : null;
        return uSimpleNameReferenceExpression != null ? uSimpleNameReferenceExpression.getIdentifier() : null;
    }

    private final String getResolvedName(UElement $this$resolvedName) {
        USimpleNameReferenceExpression uSimpleNameReferenceExpression = $this$resolvedName instanceof USimpleNameReferenceExpression ? (USimpleNameReferenceExpression)$this$resolvedName : null;
        return uSimpleNameReferenceExpression != null ? uSimpleNameReferenceExpression.getResolvedName() : null;
    }

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object)"androidx.compose.runtime.snapshots.AutoboxingStateValueProperty");
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        String string;
        String preferredPropertyName;
        String resolvedPropertyName;
        block6: {
            String string2;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
            Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
            Intrinsics.checkNotNullParameter(allMemberAnnotations, (String)"allMemberAnnotations");
            Intrinsics.checkNotNullParameter(allClassAnnotations, (String)"allClassAnnotations");
            Intrinsics.checkNotNullParameter(allPackageAnnotations, (String)"allPackageAnnotations");
            if (type != AnnotationUsageType.FIELD_REFERENCE) {
                return;
            }
            String string3 = this.getIdentifier(usage);
            if (string3 == null) {
                string3 = resolvedPropertyName = "<unknown identifier>";
            }
            if ((string2 = this.getPreferredPropertyName(annotation)) == null) {
                string2 = "<unknown replacement>";
            }
            preferredPropertyName = string2;
            String string4 = this.getResolvedName(usage);
            if (string4 != null) {
                String $this$takeWhile$iv = string4;
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (Character.isLowerCase(it)) continue;
                    String string5 = $this$takeWhile$iv;
                    int n2 = 0;
                    String string6 = string5.substring(n2, index$iv);
                    v4 = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    break block6;
                }
                v4 = $this$takeWhile$iv;
            } else {
                v4 = string = null;
            }
        }
        String accessKind = Intrinsics.areEqual(string, (Object)"get") ? "Reading" : (Intrinsics.areEqual(string, (Object)"set") ? "Assigning" : "Accessing");
        context.report(AutoboxingStateValueProperty, usage, context.getLocation(usage), accessKind + " `" + resolvedPropertyName + "` will cause an autoboxing operation. Use `" + preferredPropertyName + "` to avoid unnecessary allocations.", this.createPropertyReplacementQuickFix(resolvedPropertyName, preferredPropertyName));
    }

    private final LintFix createPropertyReplacementQuickFix(String resolvedPropertyName, String preferredPropertyName) {
        return this.fix().name("Replace with `" + preferredPropertyName + "`").replace().text(resolvedPropertyName).with(preferredPropertyName).build();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/runtime/lint/AutoboxingStateValuePropertyDetector$Companion;", "", "()V", "AutoboxingStateValueProperty", "Lcom/android/tools/lint/detector/api/Issue;", "getAutoboxingStateValueProperty", "()Lcom/android/tools/lint/detector/api/Issue;", "runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getAutoboxingStateValueProperty() {
            return AutoboxingStateValueProperty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

