/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.internal;

import androidx.compose.material3.internal.CalendarDate;
import androidx.compose.material3.internal.CalendarModel;
import androidx.compose.material3.internal.CalendarModelKt;
import androidx.compose.material3.internal.CalendarMonth;
import androidx.compose.material3.internal.DateInputFormat;
import androidx.compose.runtime.internal.StabilityInferred;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 02\u00020\u0001:\u00010B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J$\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00112\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0018H\u0016J\u0014\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u0018H\u0016J\u0018\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\u0007H\u0016J\u001a\u0010)\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\u0018\u0010*\u001a\u00020!2\u0006\u0010'\u001a\u00020!2\u0006\u0010+\u001a\u00020\u0007H\u0016J\b\u0010,\u001a\u00020\u0011H\u0016J\u0014\u0010-\u001a\u00020#*\u00020\u000b2\u0006\u0010.\u001a\u00020/H\u0002J\f\u0010-\u001a\u00020#*\u00020!H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR&\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00061"}, d2={"Landroidx/compose/material3/internal/LegacyCalendarModelImpl;", "Landroidx/compose/material3/internal/CalendarModel;", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "(Ljava/util/Locale;)V", "firstDayOfWeek", "", "getFirstDayOfWeek", "()I", "today", "Landroidx/compose/material3/internal/CalendarDate;", "getToday", "()Landroidx/compose/material3/internal/CalendarDate;", "weekdayNames", "", "Lkotlin/Pair;", "", "getWeekdayNames", "()Ljava/util/List;", "dayInISO8601", "day", "formatWithPattern", "utcTimeMillis", "", "pattern", "getCanonicalDate", "timeInMillis", "getDateInputFormat", "Landroidx/compose/material3/internal/DateInputFormat;", "getDayOfWeek", "date", "getMonth", "Landroidx/compose/material3/internal/CalendarMonth;", "firstDayCalendar", "Ljava/util/Calendar;", "year", "month", "minusMonths", "from", "subtractedMonthsCount", "parse", "plusMonths", "addedMonthsCount", "toString", "toCalendar", "timeZone", "Ljava/util/TimeZone;", "Companion", "material3_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLegacyCalendarModelImpl.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyCalendarModelImpl.jvm.kt\nandroidx/compose/material3/internal/LegacyCalendarModelImpl\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,241:1\n69#2,6:242\n*S KotlinDebug\n*F\n+ 1 LegacyCalendarModelImpl.jvm.kt\nandroidx/compose/material3/internal/LegacyCalendarModelImpl\n*L\n61#1:242,6\n*E\n"})
public final class LegacyCalendarModelImpl
extends CalendarModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int firstDayOfWeek;
    @NotNull
    private final List<Pair<String, String>> weekdayNames;
    public static final int $stable = 8;
    @NotNull
    private static final TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");

    /*
     * WARNING - void declaration
     */
    public LegacyCalendarModelImpl(@NotNull Locale locale) {
        super(locale);
        void $this$weekdayNames_u24lambda_u241;
        List list;
        this.firstDayOfWeek = this.dayInISO8601(Calendar.getInstance(locale).getFirstDayOfWeek());
        List list2 = list = CollectionsKt.createListBuilder();
        LegacyCalendarModelImpl legacyCalendarModelImpl = this;
        boolean bl = false;
        Object[] weekdays = new DateFormatSymbols(locale).getWeekdays();
        String[] shortWeekdays = new DateFormatSymbols(locale).getShortWeekdays();
        List $this$fastForEachIndexed$iv = ArraysKt.drop((Object[])weekdays, (int)2);
        boolean $i$f$fastForEachIndexed = false;
        int index$iv = 0;
        int n = $this$fastForEachIndexed$iv.size();
        while (index$iv < n) {
            void day;
            Object item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            String string2 = (String)item$iv;
            int index = index$iv++;
            boolean bl2 = false;
            $this$weekdayNames_u24lambda_u241.add(new Pair((Object)day, (Object)shortWeekdays[index + 2]));
        }
        $this$weekdayNames_u24lambda_u241.add(new Pair(weekdays[1], (Object)shortWeekdays[1]));
        legacyCalendarModelImpl.weekdayNames = CollectionsKt.build((List)list);
    }

    @Override
    @NotNull
    public CalendarDate getToday() {
        Calendar systemCalendar = Calendar.getInstance();
        systemCalendar.set(11, 0);
        systemCalendar.set(12, 0);
        systemCalendar.set(13, 0);
        systemCalendar.set(14, 0);
        int utcOffset = systemCalendar.get(15) + systemCalendar.get(16);
        return new CalendarDate(systemCalendar.get(1), systemCalendar.get(2) + 1, systemCalendar.get(5), systemCalendar.getTimeInMillis() + (long)utcOffset);
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getWeekdayNames() {
        return this.weekdayNames;
    }

    @Override
    @NotNull
    public DateInputFormat getDateInputFormat(@NotNull Locale locale) {
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        Intrinsics.checkNotNull((Object)dateFormat, (String)"null cannot be cast to non-null type java.text.SimpleDateFormat");
        return CalendarModelKt.datePatternAsInputFormat(((SimpleDateFormat)dateFormat).toPattern());
    }

    @Override
    @NotNull
    public CalendarDate getCanonicalDate(long timeInMillis) {
        Calendar calendar = Calendar.getInstance(utcTimeZone);
        calendar.setTimeInMillis(timeInMillis);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new CalendarDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.getTimeInMillis());
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(long timeInMillis) {
        Calendar firstDayCalendar = Calendar.getInstance(utcTimeZone);
        firstDayCalendar.setTimeInMillis(timeInMillis);
        firstDayCalendar.set(5, 1);
        firstDayCalendar.set(11, 0);
        firstDayCalendar.set(12, 0);
        firstDayCalendar.set(13, 0);
        firstDayCalendar.set(14, 0);
        return this.getMonth(firstDayCalendar);
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(@NotNull CalendarDate date) {
        return this.getMonth(date.getYear(), date.getMonth());
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(int year, int month) {
        Calendar firstDayCalendar = Calendar.getInstance(utcTimeZone);
        firstDayCalendar.clear();
        firstDayCalendar.set(1, year);
        firstDayCalendar.set(2, month - 1);
        firstDayCalendar.set(5, 1);
        return this.getMonth(firstDayCalendar);
    }

    @Override
    public int getDayOfWeek(@NotNull CalendarDate date) {
        return this.dayInISO8601(this.toCalendar(date, TimeZone.getDefault()).get(7));
    }

    @Override
    @NotNull
    public CalendarMonth plusMonths(@NotNull CalendarMonth from, int addedMonthsCount) {
        if (addedMonthsCount <= 0) {
            return from;
        }
        Calendar laterMonth = this.toCalendar(from);
        laterMonth.add(2, addedMonthsCount);
        return this.getMonth(laterMonth);
    }

    @Override
    @NotNull
    public CalendarMonth minusMonths(@NotNull CalendarMonth from, int subtractedMonthsCount) {
        if (subtractedMonthsCount <= 0) {
            return from;
        }
        Calendar earlierMonth = this.toCalendar(from);
        earlierMonth.add(2, -subtractedMonthsCount);
        return this.getMonth(earlierMonth);
    }

    @Override
    @NotNull
    public String formatWithPattern(long utcTimeMillis, @NotNull String pattern, @NotNull Locale locale) {
        return Companion.formatWithPattern(utcTimeMillis, pattern, locale, this.getFormatterCache$material3_release());
    }

    @Override
    @Nullable
    public CalendarDate parse(@NotNull String date, @NotNull String pattern) {
        CalendarDate calendarDate;
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setTimeZone(utcTimeZone);
        dateFormat.setLenient(false);
        try {
            Date date2 = dateFormat.parse(date);
            if (date2 == null) {
                return null;
            }
            Date parsedDate = date2;
            Calendar calendar = Calendar.getInstance(utcTimeZone);
            calendar.setTime(parsedDate);
            calendarDate = new CalendarDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.getTimeInMillis());
        }
        catch (ParseException pe) {
            calendarDate = null;
        }
        return calendarDate;
    }

    @NotNull
    public String toString() {
        return "LegacyCalendarModel";
    }

    private final int dayInISO8601(int day) {
        int shiftedDay = (day + 6) % 7;
        if (shiftedDay == 0) {
            return 7;
        }
        return shiftedDay;
    }

    private final CalendarMonth getMonth(Calendar firstDayCalendar) {
        int difference = this.dayInISO8601(firstDayCalendar.get(7)) - this.getFirstDayOfWeek();
        int daysFromStartOfWeekToFirstOfMonth = difference < 0 ? difference + 7 : difference;
        return new CalendarMonth(firstDayCalendar.get(1), firstDayCalendar.get(2) + 1, firstDayCalendar.getActualMaximum(5), daysFromStartOfWeekToFirstOfMonth, firstDayCalendar.getTimeInMillis());
    }

    private final Calendar toCalendar(CalendarMonth $this$toCalendar) {
        Calendar calendar = Calendar.getInstance(utcTimeZone);
        calendar.setTimeInMillis($this$toCalendar.getStartUtcTimeMillis());
        return calendar;
    }

    private final Calendar toCalendar(CalendarDate $this$toCalendar, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.clear();
        calendar.set(1, $this$toCalendar.getYear());
        calendar.set(2, $this$toCalendar.getMonth() - 1);
        calendar.set(5, $this$toCalendar.getDayOfMonth());
        return calendar;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0010J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0010H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Landroidx/compose/material3/internal/LegacyCalendarModelImpl$Companion;", "", "()V", "utcTimeZone", "Ljava/util/TimeZone;", "getUtcTimeZone$material3_release", "()Ljava/util/TimeZone;", "formatWithPattern", "", "utcTimeMillis", "", "pattern", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "cache", "", "getCachedSimpleDateFormat", "Ljava/text/SimpleDateFormat;", "material3_release"})
    @SourceDebugExtension(value={"SMAP\nLegacyCalendarModelImpl.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyCalendarModelImpl.jvm.kt\nandroidx/compose/material3/internal/LegacyCalendarModelImpl$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,241:1\n361#2,7:242\n*S KotlinDebug\n*F\n+ 1 LegacyCalendarModelImpl.jvm.kt\nandroidx/compose/material3/internal/LegacyCalendarModelImpl$Companion\n*L\n192#1:242,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String formatWithPattern(long utcTimeMillis, @NotNull String pattern, @NotNull Locale locale, @NotNull Map<String, Object> cache) {
            SimpleDateFormat dateFormat = this.getCachedSimpleDateFormat(pattern, locale, cache);
            Calendar calendar = Calendar.getInstance(this.getUtcTimeZone$material3_release());
            calendar.setTimeInMillis(utcTimeMillis);
            return dateFormat.format(calendar.getTimeInMillis());
        }

        @NotNull
        public final TimeZone getUtcTimeZone$material3_release() {
            return utcTimeZone;
        }

        /*
         * WARNING - void declaration
         */
        private final SimpleDateFormat getCachedSimpleDateFormat(String pattern, Locale locale, Map<String, Object> cache) {
            Object object;
            void $this$getOrPut$iv;
            Map<String, Object> map2 = cache;
            String key$iv = pattern + locale.toLanguageTag();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, locale);
                dateFormat.setTimeZone(Companion.getUtcTimeZone$material3_release());
                SimpleDateFormat answer$iv = dateFormat;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (SimpleDateFormat)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

