/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.UnfoldLessDouble: ImageVector
    get() {
        if (_unfoldLessDouble != null) {
            return _unfoldLessDouble!!
        }
        _unfoldLessDouble = materialIcon(name = "TwoTone.UnfoldLessDouble") {
            materialPath {
                moveTo(16.58f, 1.41f)
                lineToRelative(-1.42f, -1.41f)
                lineToRelative(-3.17f, 3.17f)
                lineToRelative(-3.17f, -3.17f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(4.58f, 4.59f)
                close()
            }
            materialPath {
                moveTo(16.58f, 6.41f)
                lineToRelative(-1.42f, -1.41f)
                lineToRelative(-3.17f, 3.17f)
                lineToRelative(-3.17f, -3.17f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(4.58f, 4.59f)
                close()
            }
            materialPath {
                moveTo(7.42f, 17.59f)
                lineToRelative(1.42f, 1.41f)
                lineToRelative(3.17f, -3.17f)
                lineToRelative(3.17f, 3.17f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(-4.58f, -4.59f)
                close()
            }
            materialPath {
                moveTo(7.42f, 22.59f)
                lineToRelative(1.42f, 1.41f)
                lineToRelative(3.17f, -3.17f)
                lineToRelative(3.17f, 3.17f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(-4.58f, -4.59f)
                close()
            }
        }
        return _unfoldLessDouble!!
    }

private var _unfoldLessDouble: ImageVector? = null
