/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.SnippetFolder: ImageVector
    get() {
        if (_snippetFolder != null) {
            return _snippetFolder!!
        }
        _snippetFolder = materialIcon(name = "TwoTone.SnippetFolder") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(9.17f, 6.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(12.0f)
                lineToRelative(16.0f, 0.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(-8.83f)
                lineTo(9.17f, 6.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 6.0f)
                horizontalLineToRelative(-8.0f)
                lineToRelative(-2.0f, -2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 4.0f, 2.01f, 4.9f, 2.01f, 6.0f)
                lineTo(2.0f, 18.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(8.0f)
                curveTo(22.0f, 6.9f, 21.1f, 6.0f, 20.0f, 6.0f)
                close()
                moveTo(20.0f, 18.0f)
                lineTo(4.0f, 18.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(5.17f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(20.0f)
                verticalLineTo(18.0f)
                close()
                moveTo(17.5f, 12.12f)
                verticalLineToRelative(3.38f)
                lineToRelative(-3.0f, 0.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(1.38f)
                lineTo(17.5f, 12.12f)
                close()
                moveTo(16.5f, 9.0f)
                horizontalLineTo(13.0f)
                verticalLineToRelative(8.0f)
                lineToRelative(6.0f, 0.0f)
                verticalLineToRelative(-5.5f)
                lineTo(16.5f, 9.0f)
                lineTo(16.5f, 9.0f)
                close()
            }
        }
        return _snippetFolder!!
    }

private var _snippetFolder: ImageVector? = null
