/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.NoTransfer: ImageVector
    get() {
        if (_noTransfer != null) {
            return _noTransfer!!
        }
        _noTransfer = materialIcon(name = "TwoTone.NoTransfer") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(14.83f, 12.0f)
                horizontalLineTo(18.0f)
                verticalLineToRelative(3.17f)
                lineTo(14.83f, 12.0f)
                close()
                moveTo(9.17f, 12.0f)
                lineToRelative(5.0f, 5.0f)
                horizontalLineTo(6.63f)
                lineToRelative(-0.29f, -0.27f)
                curveTo(6.21f, 16.62f, 6.0f, 16.37f, 6.0f, 16.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineTo(9.17f)
                close()
                moveTo(10.0f, 14.5f)
                curveToRelative(0.0f, -0.83f, -0.67f, -1.5f, -1.5f, -1.5f)
                reflectiveCurveTo(7.0f, 13.67f, 7.0f, 14.5f)
                curveTo(7.0f, 15.33f, 7.67f, 16.0f, 8.5f, 16.0f)
                reflectiveCurveTo(10.0f, 15.33f, 10.0f, 14.5f)
                close()
                moveTo(7.82f, 4.99f)
                horizontalLineToRelative(9.83f)
                curveTo(17.11f, 4.46f, 15.69f, 4.0f, 12.0f, 4.0f)
                curveTo(9.6f, 4.0f, 8.17f, 4.2f, 7.31f, 4.48f)
                lineTo(7.82f, 4.99f)
                close()
            }
            materialPath {
                moveTo(8.5f, 13.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveTo(9.33f, 16.0f, 8.5f, 16.0f)
                reflectiveCurveTo(7.0f, 15.33f, 7.0f, 14.5f)
                reflectiveCurveTo(7.67f, 13.0f, 8.5f, 13.0f)
                close()
                moveTo(7.31f, 4.48f)
                curveTo(8.17f, 4.2f, 9.6f, 4.0f, 12.0f, 4.0f)
                curveToRelative(3.69f, 0.0f, 5.11f, 0.46f, 5.66f, 0.99f)
                horizontalLineTo(7.82f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(18.0f)
                verticalLineTo(10.0f)
                horizontalLineToRelative(-5.17f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(18.0f)
                verticalLineToRelative(3.17f)
                lineToRelative(1.81f, 1.81f)
                curveTo(19.92f, 16.67f, 20.0f, 16.35f, 20.0f, 16.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -3.5f, -3.58f, -4.0f, -8.0f, -4.0f)
                curveTo(9.48f, 2.0f, 7.24f, 2.16f, 5.78f, 2.95f)
                lineTo(7.31f, 4.48f)
                close()
                moveTo(19.78f, 22.61f)
                lineToRelative(-1.64f, -1.64f)
                curveTo(18.09f, 20.98f, 18.05f, 21.0f, 18.0f, 21.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineTo(6.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-1.78f)
                curveTo(4.39f, 17.67f, 4.0f, 16.88f, 4.0f, 16.0f)
                verticalLineTo(6.83f)
                lineTo(1.39f, 4.22f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(18.38f, 18.38f)
                lineTo(19.78f, 22.61f)
                close()
                moveTo(6.0f, 8.83f)
                verticalLineTo(10.0f)
                horizontalLineToRelative(1.17f)
                lineTo(6.0f, 8.83f)
                close()
                moveTo(14.17f, 17.0f)
                lineToRelative(-5.0f, -5.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.37f, 0.21f, 0.62f, 0.34f, 0.73f)
                lineTo(6.63f, 17.0f)
                horizontalLineTo(8.0f)
                horizontalLineTo(14.17f)
                close()
            }
        }
        return _noTransfer!!
    }

private var _noTransfer: ImageVector? = null
