/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.CurrencyYuan: ImageVector
    get() {
        if (_currencyYuan != null) {
            return _currencyYuan!!
        }
        _currencyYuan = materialIcon(name = "TwoTone.CurrencyYuan") {
            materialPath {
                moveTo(13.28f, 12.0f)
                lineToRelative(4.72f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(-5.0f, 0.0f)
                lineToRelative(0.0f, 7.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, -7.0f)
                lineToRelative(-5.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(4.72f, 0.0f)
                lineToRelative(-5.72f, -9.0f)
                lineToRelative(2.37f, 0.0f)
                lineToRelative(4.63f, 7.29f)
                lineToRelative(4.63f, -7.29f)
                lineToRelative(2.37f, 0.0f)
                close()
            }
        }
        return _currencyYuan!!
    }

private var _currencyYuan: ImageVector? = null
