/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SwitchLeft: ImageVector
    get() {
        if (_switchLeft != null) {
            return _switchLeft!!
        }
        _switchLeft = materialIcon(name = "Sharp.SwitchLeft") {
            materialPath {
                moveTo(8.5f, 8.62f)
                verticalLineToRelative(6.76f)
                lineTo(5.12f, 12.0f)
                lineTo(8.5f, 8.62f)
                moveTo(10.0f, 5.0f)
                lineToRelative(-7.0f, 7.0f)
                lineToRelative(7.0f, 7.0f)
                verticalLineTo(5.0f)
                lineTo(10.0f, 5.0f)
                close()
                moveTo(14.0f, 5.0f)
                verticalLineToRelative(14.0f)
                lineToRelative(7.0f, -7.0f)
                lineTo(14.0f, 5.0f)
                close()
            }
        }
        return _switchLeft!!
    }

private var _switchLeft: ImageVector? = null
