/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.RawOff: ImageVector
    get() {
        if (_rawOff != null) {
            return _rawOff!!
        }
        _rawOff = materialIcon(name = "Sharp.RawOff") {
            materialPath {
                moveTo(17.15f, 14.32f)
                lineToRelative(0.59f, -2.36f)
                lineToRelative(0.76f, 3.04f)
                lineToRelative(1.48f, 0.0f)
                lineToRelative(1.5f, -6.0f)
                lineToRelative(-1.5f, 0.0f)
                lineToRelative(-0.74f, 3.0f)
                lineToRelative(-0.74f, -3.0f)
                lineToRelative(-1.52f, 0.0f)
                lineToRelative(-0.74f, 3.0f)
                lineToRelative(-0.74f, -3.0f)
                lineToRelative(-1.5f, 0.0f)
                lineToRelative(0.72f, 2.9f)
                close()
            }
            materialPath {
                moveTo(1.39f, 4.22f)
                lineTo(6.17f, 9.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(1.1f)
                lineToRelative(0.9f, 2.0f)
                horizontalLineTo(8.0f)
                lineToRelative(-0.9f, -2.1f)
                curveTo(7.6f, 12.6f, 8.0f, 12.1f, 8.0f, 11.5f)
                verticalLineToRelative(-0.67f)
                lineToRelative(1.43f, 1.43f)
                lineTo(8.75f, 15.0f)
                horizontalLineToRelative(1.5f)
                lineToRelative(0.38f, -1.5f)
                horizontalLineToRelative(0.04f)
                lineToRelative(9.11f, 9.11f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                close()
                moveTo(6.5f, 11.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(11.5f)
                close()
            }
        }
        return _rawOff!!
    }

private var _rawOff: ImageVector? = null
