/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PropaneTank: ImageVector
    get() {
        if (_propaneTank != null) {
            return _propaneTank!!
        }
        _propaneTank = materialIcon(name = "Sharp.PropaneTank") {
            materialPath {
                moveTo(4.0f, 15.0f)
                verticalLineToRelative(3.0f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                horizontalLineToRelative(8.0f)
                curveToRelative(2.21f, 0.0f, 4.0f, -1.79f, 4.0f, -4.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineTo(4.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 13.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -1.86f, -1.28f, -3.41f, -3.0f, -3.86f)
                verticalLineTo(2.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(4.14f)
                curveToRelative(-1.72f, 0.45f, -3.0f, 2.0f, -3.0f, 3.86f)
                verticalLineToRelative(3.0f)
                horizontalLineTo(20.0f)
                close()
                moveTo(9.0f, 4.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(9.0f)
                verticalLineTo(4.0f)
                close()
            }
        }
        return _propaneTank!!
    }

private var _propaneTank: ImageVector? = null
