/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.DynamicFeed: ImageVector
    get() {
        if (_dynamicFeed != null) {
            return _dynamicFeed!!
        }
        _dynamicFeed = materialIcon(name = "Sharp.DynamicFeed") {
            materialPath {
                moveTo(8.0f, 8.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 9.0f)
                lineToRelative(11.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(-9.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(22.0f, 3.0f)
                horizontalLineTo(10.0f)
                verticalLineToRelative(10.0f)
                horizontalLineToRelative(12.0f)
                verticalLineTo(3.0f)
                close()
                moveTo(20.0f, 11.0f)
                horizontalLineToRelative(-8.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(8.0f)
                verticalLineTo(11.0f)
                close()
            }
            materialPath {
                moveTo(4.0f, 12.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 9.0f)
                lineToRelative(11.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(-9.0f, 0.0f)
                close()
            }
        }
        return _dynamicFeed!!
    }

private var _dynamicFeed: ImageVector? = null
