/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.BatchPrediction: ImageVector
    get() {
        if (_batchPrediction != null) {
            return _batchPrediction!!
        }
        _batchPrediction = materialIcon(name = "Sharp.BatchPrediction") {
            materialPath {
                moveTo(19.0f, 8.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(14.0f)
                verticalLineTo(8.0f)
                close()
                moveTo(13.0f, 20.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(19.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(20.5f)
                close()
                moveTo(13.0f, 18.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(0.0f, -1.5f, -2.5f, -3.0f, -2.5f, -5.0f)
                curveToRelative(0.0f, -1.93f, 1.57f, -3.5f, 3.5f, -3.5f)
                curveToRelative(1.93f, 0.0f, 3.5f, 1.57f, 3.5f, 3.5f)
                curveTo(15.5f, 15.0f, 13.0f, 16.5f, 13.0f, 18.0f)
                close()
                moveTo(18.0f, 6.5f)
                horizontalLineTo(6.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(12.0f)
                verticalLineTo(6.5f)
                close()
                moveTo(17.0f, 3.5f)
                horizontalLineTo(7.0f)
                verticalLineTo(2.0f)
                horizontalLineToRelative(10.0f)
                verticalLineTo(3.5f)
                close()
            }
        }
        return _batchPrediction!!
    }

private var _batchPrediction: ImageVector? = null
