/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.WifiFind: ImageVector
    get() {
        if (_wifiFind != null) {
            return _wifiFind!!
        }
        _wifiFind = materialIcon(name = "Rounded.WifiFind") {
            materialPath {
                moveTo(11.0f, 14.0f)
                curveToRelative(0.0f, -3.36f, 2.64f, -6.0f, 6.0f, -6.0f)
                curveToRelative(2.2f, 0.0f, 4.08f, 1.13f, 5.13f, 2.86f)
                lineToRelative(0.36f, -0.37f)
                curveToRelative(0.86f, -0.86f, 0.76f, -2.27f, -0.2f, -3.01f)
                curveTo(19.44f, 5.3f, 15.87f, 4.0f, 12.0f, 4.0f)
                curveTo(8.13f, 4.0f, 4.56f, 5.3f, 1.71f, 7.48f)
                curveToRelative(-0.96f, 0.74f, -1.06f, 2.15f, -0.2f, 3.01f)
                lineToRelative(9.08f, 9.09f)
                curveToRelative(0.78f, 0.78f, 2.05f, 0.78f, 2.83f, 0.0f)
                lineToRelative(0.45f, -0.45f)
                curveTo(12.14f, 18.09f, 11.0f, 16.2f, 11.0f, 14.0f)
                close()
            }
            materialPath {
                moveTo(20.44f, 16.03f)
                curveTo(20.79f, 15.44f, 21.0f, 14.75f, 21.0f, 14.0f)
                curveToRelative(0.0f, -2.24f, -1.76f, -4.0f, -4.0f, -4.0f)
                reflectiveCurveToRelative(-4.0f, 1.76f, -4.0f, 4.0f)
                curveToRelative(0.0f, 2.24f, 1.76f, 4.0f, 4.0f, 4.0f)
                curveToRelative(0.75f, 0.0f, 1.44f, -0.21f, 2.03f, -0.56f)
                lineToRelative(1.85f, 1.85f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(20.44f, 16.03f)
                close()
                moveTo(17.0f, 16.0f)
                curveToRelative(-1.12f, 0.0f, -2.0f, -0.88f, -2.0f, -2.0f)
                curveToRelative(0.0f, -1.12f, 0.88f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.88f, 2.0f, 2.0f)
                curveTo(19.0f, 15.12f, 18.12f, 16.0f, 17.0f, 16.0f)
                close()
            }
        }
        return _wifiFind!!
    }

private var _wifiFind: ImageVector? = null
