/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Brightness2: ImageVector
    get() {
        if (_brightness2 != null) {
            return _brightness2!!
        }
        _brightness2 = materialIcon(name = "Rounded.Brightness2") {
            materialPath {
                moveTo(12.43f, 2.3f)
                curveToRelative(-2.38f, -0.59f, -4.68f, -0.27f, -6.63f, 0.64f)
                curveToRelative(-0.35f, 0.16f, -0.41f, 0.64f, -0.1f, 0.86f)
                curveTo(8.3f, 5.6f, 10.0f, 8.6f, 10.0f, 12.0f)
                curveToRelative(0.0f, 3.4f, -1.7f, 6.4f, -4.3f, 8.2f)
                curveToRelative(-0.32f, 0.22f, -0.26f, 0.7f, 0.09f, 0.86f)
                curveToRelative(1.28f, 0.6f, 2.71f, 0.94f, 4.21f, 0.94f)
                curveToRelative(6.05f, 0.0f, 10.85f, -5.38f, 9.87f, -11.6f)
                curveToRelative(-0.61f, -3.92f, -3.59f, -7.16f, -7.44f, -8.1f)
                close()
            }
        }
        return _brightness2!!
    }

private var _brightness2: ImageVector? = null
