/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Dangerous: ImageVector
    get() {
        if (_dangerous != null) {
            return _dangerous!!
        }
        _dangerous = materialIcon(name = "Outlined.Dangerous") {
            materialPath {
                moveTo(15.73f, 3.0f)
                horizontalLineTo(8.27f)
                lineTo(3.0f, 8.27f)
                verticalLineToRelative(7.46f)
                lineTo(8.27f, 21.0f)
                horizontalLineToRelative(7.46f)
                lineTo(21.0f, 15.73f)
                verticalLineTo(8.27f)
                lineTo(15.73f, 3.0f)
                close()
                moveTo(19.0f, 14.9f)
                lineTo(14.9f, 19.0f)
                horizontalLineTo(9.1f)
                lineTo(5.0f, 14.9f)
                verticalLineTo(9.1f)
                lineTo(9.1f, 5.0f)
                horizontalLineToRelative(5.8f)
                lineTo(19.0f, 9.1f)
                verticalLineTo(14.9f)
                close()
                moveTo(14.83f, 7.76f)
                lineTo(12.0f, 10.59f)
                lineTo(9.17f, 7.76f)
                lineTo(7.76f, 9.17f)
                lineTo(10.59f, 12.0f)
                lineToRelative(-2.83f, 2.83f)
                lineToRelative(1.41f, 1.41f)
                lineTo(12.0f, 13.41f)
                lineToRelative(2.83f, 2.83f)
                lineToRelative(1.41f, -1.41f)
                lineTo(13.41f, 12.0f)
                lineToRelative(2.83f, -2.83f)
                lineTo(14.83f, 7.76f)
                close()
            }
        }
        return _dangerous!!
    }

private var _dangerous: ImageVector? = null
