/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.TvOff: ImageVector
    get() {
        if (_tvOff != null) {
            return _tvOff!!
        }
        _tvOff = materialIcon(name = "Filled.TvOff") {
            materialPath {
                moveTo(1.0f, 3.54f)
                lineToRelative(1.53f, 1.53f)
                curveTo(1.65f, 5.28f, 1.0f, 6.06f, 1.0f, 7.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(15.46f)
                lineToRelative(2.0f, 2.0f)
                lineToRelative(1.26f, -1.27f)
                lineTo(2.27f, 2.27f)
                lineTo(1.0f, 3.54f)
                close()
                moveTo(3.0f, 19.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(1.46f)
                lineToRelative(12.0f, 12.0f)
                horizontalLineTo(3.0f)
                close()
                moveTo(21.0f, 5.0f)
                horizontalLineToRelative(-7.58f)
                lineToRelative(3.29f, -3.3f)
                lineTo(16.0f, 1.0f)
                lineToRelative(-4.0f, 4.0f)
                lineToRelative(-4.0f, -4.0f)
                lineToRelative(-0.7f, 0.7f)
                lineTo(10.58f, 5.0f)
                horizontalLineTo(7.52f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(21.0f)
                verticalLineToRelative(11.48f)
                lineToRelative(1.65f, 1.65f)
                curveToRelative(0.22f, -0.32f, 0.35f, -0.71f, 0.35f, -1.13f)
                verticalLineTo(7.0f)
                curveToRelative(0.0f, -1.11f, -0.89f, -2.0f, -2.0f, -2.0f)
                close()
            }
        }
        return _tvOff!!
    }

private var _tvOff: ImageVector? = null
