/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.SettingsBluetooth: ImageVector
    get() {
        if (_settingsBluetooth != null) {
            return _settingsBluetooth!!
        }
        _settingsBluetooth = materialIcon(name = "Filled.SettingsBluetooth") {
            materialPath {
                moveTo(11.0f, 24.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                close()
                moveTo(7.0f, 24.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.0f)
                lineTo(7.0f, 22.0f)
                verticalLineToRelative(2.0f)
                close()
                moveTo(15.0f, 24.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                close()
                moveTo(17.71f, 5.71f)
                lineTo(12.0f, 0.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(7.59f)
                lineTo(6.41f, 3.0f)
                lineTo(5.0f, 4.41f)
                lineTo(10.59f, 10.0f)
                lineTo(5.0f, 15.59f)
                lineTo(6.41f, 17.0f)
                lineTo(11.0f, 12.41f)
                lineTo(11.0f, 20.0f)
                horizontalLineToRelative(1.0f)
                lineToRelative(5.71f, -5.71f)
                lineToRelative(-4.3f, -4.29f)
                lineToRelative(4.3f, -4.29f)
                close()
                moveTo(13.0f, 3.83f)
                lineToRelative(1.88f, 1.88f)
                lineTo(13.0f, 7.59f)
                lineTo(13.0f, 3.83f)
                close()
                moveTo(14.88f, 14.29f)
                lineTo(13.0f, 16.17f)
                verticalLineToRelative(-3.76f)
                lineToRelative(1.88f, 1.88f)
                close()
            }
        }
        return _settingsBluetooth!!
    }

private var _settingsBluetooth: ImageVector? = null
