/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Dry: ImageVector
    get() {
        if (_dry != null) {
            return _dry!!
        }
        _dry = materialIcon(name = "Filled.Dry") {
            materialPath {
                moveTo(15.65f, 4.86f)
                lineToRelative(-0.07f, -0.07f)
                curveToRelative(-0.57f, -0.62f, -0.82f, -1.41f, -0.67f, -2.2f)
                lineTo(15.0f, 2.0f)
                horizontalLineToRelative(-1.89f)
                lineToRelative(-0.06f, 0.43f)
                curveToRelative(-0.2f, 1.36f, 0.27f, 2.71f, 1.3f, 3.72f)
                lineToRelative(0.07f, 0.06f)
                curveToRelative(0.57f, 0.62f, 0.82f, 1.41f, 0.67f, 2.2f)
                lineTo(14.98f, 9.0f)
                horizontalLineToRelative(1.91f)
                lineToRelative(0.06f, -0.43f)
                curveTo(17.16f, 7.21f, 16.68f, 5.86f, 15.65f, 4.86f)
                close()
                moveTo(19.65f, 4.86f)
                lineToRelative(-0.07f, -0.07f)
                curveToRelative(-0.57f, -0.62f, -0.82f, -1.41f, -0.67f, -2.2f)
                lineTo(19.0f, 2.0f)
                horizontalLineToRelative(-1.89f)
                lineToRelative(-0.06f, 0.43f)
                curveToRelative(-0.2f, 1.36f, 0.27f, 2.71f, 1.3f, 3.72f)
                lineToRelative(0.07f, 0.06f)
                curveToRelative(0.57f, 0.62f, 0.82f, 1.41f, 0.67f, 2.2f)
                lineTo(18.98f, 9.0f)
                horizontalLineToRelative(1.91f)
                lineToRelative(0.06f, -0.43f)
                curveTo(21.16f, 7.21f, 20.68f, 5.86f, 19.65f, 4.86f)
                close()
                moveTo(9.12f, 5.0f)
                lineToRelative(-7.18f, 6.79f)
                curveTo(1.34f, 12.35f, 1.0f, 13.14f, 1.0f, 13.97f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                horizontalLineToRelative(6.25f)
                horizontalLineTo(12.0f)
                horizontalLineToRelative(5.75f)
                curveToRelative(0.69f, 0.0f, 1.25f, -0.56f, 1.25f, -1.25f)
                reflectiveCurveToRelative(-0.56f, -1.25f, -1.25f, -1.25f)
                horizontalLineTo(12.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(7.75f)
                curveToRelative(0.69f, 0.0f, 1.25f, -0.56f, 1.25f, -1.25f)
                reflectiveCurveTo(20.44f, 17.0f, 19.75f, 17.0f)
                horizontalLineTo(12.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(8.75f)
                curveToRelative(0.69f, 0.0f, 1.25f, -0.56f, 1.25f, -1.25f)
                reflectiveCurveToRelative(-0.56f, -1.25f, -1.25f, -1.25f)
                horizontalLineTo(12.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(6.75f)
                curveToRelative(0.69f, 0.0f, 1.25f, -0.56f, 1.25f, -1.25f)
                reflectiveCurveTo(19.44f, 10.0f, 18.75f, 10.0f)
                horizontalLineTo(8.86f)
                curveToRelative(0.64f, -1.11f, 1.48f, -2.58f, 1.49f, -2.61f)
                curveToRelative(0.09f, -0.16f, 0.14f, -0.33f, 0.14f, -0.53f)
                curveToRelative(0.0f, -0.26f, -0.09f, -0.5f, -0.26f, -0.7f)
                curveTo(10.22f, 6.12f, 9.12f, 5.0f, 9.12f, 5.0f)
                lineTo(9.12f, 5.0f)
                close()
            }
        }
        return _dry!!
    }

private var _dry: ImageVector? = null
