/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.modifiers;

import androidx.compose.foundation.text.BasicText_androidKt;
import androidx.compose.foundation.text.TouchMode_androidKt;
import androidx.compose.foundation.text.modifiers.SelectionControllerKt;
import androidx.compose.foundation.text.modifiers.StaticTextSelectionParams;
import androidx.compose.foundation.text.selection.MultiWidgetSelectionDelegate;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionRegistrar;
import androidx.compose.runtime.RememberObserver;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.ClipOp;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.drawscope.DrawContext;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawTransform;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.TextLayoutResult;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\"\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eR\u0019\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001f"}, d2={"Landroidx/compose/foundation/text/modifiers/SelectionController;", "Landroidx/compose/runtime/RememberObserver;", "selectionRegistrar", "Landroidx/compose/foundation/text/selection/SelectionRegistrar;", "backgroundSelectionColor", "Landroidx/compose/ui/graphics/Color;", "params", "Landroidx/compose/foundation/text/modifiers/StaticTextSelectionParams;", "(Landroidx/compose/foundation/text/selection/SelectionRegistrar;JLandroidx/compose/foundation/text/modifiers/StaticTextSelectionParams;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "modifier", "Landroidx/compose/ui/Modifier;", "getModifier", "()Landroidx/compose/ui/Modifier;", "selectable", "Landroidx/compose/foundation/text/selection/Selectable;", "selectableId", "", "draw", "", "drawScope", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "onAbandoned", "onForgotten", "onRemembered", "updateGlobalPosition", "coordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "updateTextLayout", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "foundation_release"})
@SourceDebugExtension(value={"SMAP\nSelectionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionController.kt\nandroidx/compose/foundation/text/modifiers/SelectionController\n+ 2 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n*L\n1#1,360:1\n214#2,8:361\n261#2,11:369\n*S KotlinDebug\n*F\n+ 1 SelectionController.kt\nandroidx/compose/foundation/text/modifiers/SelectionController\n*L\n149#1:361,8\n149#1:369,11\n*E\n"})
public final class SelectionController
implements RememberObserver {
    @NotNull
    private final SelectionRegistrar selectionRegistrar;
    private final long backgroundSelectionColor;
    @NotNull
    private StaticTextSelectionParams params;
    @Nullable
    private Selectable selectable;
    private final long selectableId;
    @NotNull
    private final Modifier modifier;

    private SelectionController(SelectionRegistrar selectionRegistrar, long backgroundSelectionColor, StaticTextSelectionParams params) {
        Intrinsics.checkNotNullParameter((Object)selectionRegistrar, (String)"selectionRegistrar");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.selectionRegistrar = selectionRegistrar;
        this.backgroundSelectionColor = backgroundSelectionColor;
        this.params = params;
        this.selectableId = this.selectionRegistrar.nextSelectableId();
        this.modifier = BasicText_androidKt.textPointerHoverIcon(SelectionControllerKt.access$makeSelectionModifier(this.selectionRegistrar, this.selectableId, (Function0)new Function0<LayoutCoordinates>(this){
            final /* synthetic */ SelectionController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final LayoutCoordinates invoke() {
                return SelectionController.access$getParams$p(this.this$0).getLayoutCoordinates();
            }
        }, (Function0)new Function0<TextLayoutResult>(this){
            final /* synthetic */ SelectionController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final TextLayoutResult invoke() {
                return SelectionController.access$getParams$p(this.this$0).getTextLayoutResult();
            }
        }, TouchMode_androidKt.isInTouchMode()), this.selectionRegistrar);
    }

    public /* synthetic */ SelectionController(SelectionRegistrar selectionRegistrar, long l, StaticTextSelectionParams staticTextSelectionParams, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            staticTextSelectionParams = StaticTextSelectionParams.Companion.getEmpty();
        }
        this(selectionRegistrar, l, staticTextSelectionParams, null);
    }

    @NotNull
    public final Modifier getModifier() {
        return this.modifier;
    }

    public void onRemembered() {
        this.selectable = this.selectionRegistrar.subscribe(new MultiWidgetSelectionDelegate(this.selectableId, (Function0<? extends LayoutCoordinates>)((Function0)new Function0<LayoutCoordinates>(this){
            final /* synthetic */ SelectionController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final LayoutCoordinates invoke() {
                return SelectionController.access$getParams$p(this.this$0).getLayoutCoordinates();
            }
        }), (Function0<TextLayoutResult>)((Function0)new Function0<TextLayoutResult>(this){
            final /* synthetic */ SelectionController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final TextLayoutResult invoke() {
                return SelectionController.access$getParams$p(this.this$0).getTextLayoutResult();
            }
        })));
    }

    public void onForgotten() {
        Selectable localSelectable = this.selectable;
        if (localSelectable != null) {
            this.selectionRegistrar.unsubscribe(localSelectable);
            this.selectable = null;
        }
    }

    public void onAbandoned() {
        Selectable localSelectable = this.selectable;
        if (localSelectable != null) {
            this.selectionRegistrar.unsubscribe(localSelectable);
            this.selectable = null;
        }
    }

    public final void updateTextLayout(@NotNull TextLayoutResult textLayoutResult) {
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        this.params = StaticTextSelectionParams.copy$default(this.params, null, textLayoutResult, 1, null);
    }

    public final void updateGlobalPosition(@NotNull LayoutCoordinates coordinates) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        this.params = StaticTextSelectionParams.copy$default(this.params, coordinates, null, 2, null);
    }

    public final void draw(@NotNull DrawScope drawScope) {
        int end;
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"drawScope");
        Selection selection = this.selectionRegistrar.getSubselections().get(this.selectableId);
        if (selection == null) {
            return;
        }
        Selection selection2 = selection;
        int start = !selection2.getHandlesCrossed() ? selection2.getStart().getOffset() : selection2.getEnd().getOffset();
        int n = end = !selection2.getHandlesCrossed() ? selection2.getEnd().getOffset() : selection2.getStart().getOffset();
        if (start == end) {
            return;
        }
        Selectable selectable2 = this.selectable;
        int lastOffset = selectable2 != null ? selectable2.getLastVisibleOffset() : 0;
        int clippedStart = RangesKt.coerceAtMost((int)start, (int)lastOffset);
        int clippedEnd = RangesKt.coerceAtMost((int)end, (int)lastOffset);
        Path path = this.params.getPathForRange(clippedStart, clippedEnd);
        if (path == null) {
            return;
        }
        Path selectionPath = path;
        DrawScope $this$draw_u24lambda_u241 = drawScope;
        boolean bl = false;
        if (this.params.getShouldClip()) {
            DrawScope $this$clipRect_u2drOu3jXo_u24default$iv = $this$draw_u24lambda_u241;
            float left$iv = 0.0f;
            float top$iv = 0.0f;
            float right$iv = Size.getWidth-impl((long)$this$clipRect_u2drOu3jXo_u24default$iv.getSize-NH-jbRc());
            float bottom$iv = Size.getHeight-impl((long)$this$clipRect_u2drOu3jXo_u24default$iv.getSize-NH-jbRc());
            int clipOp$iv = ClipOp.Companion.getIntersect-rtfAjoo();
            boolean bl2 = false;
            DrawScope $this$withTransform$iv$iv = $this$clipRect_u2drOu3jXo_u24default$iv;
            boolean $i$f$withTransform = false;
            DrawContext $this$withTransform_u24lambda_u246$iv$iv = $this$withTransform$iv$iv.getDrawContext();
            boolean bl3 = false;
            long previousSize$iv$iv = $this$withTransform_u24lambda_u246$iv$iv.getSize-NH-jbRc();
            $this$withTransform_u24lambda_u246$iv$iv.getCanvas().save();
            DrawTransform $this$clipRect_rOu3jXo_u24lambda_u244$iv = $this$withTransform_u24lambda_u246$iv$iv.getTransform();
            boolean bl4 = false;
            $this$clipRect_rOu3jXo_u24lambda_u244$iv.clipRect-N_I0leg(left$iv, top$iv, right$iv, bottom$iv, clipOp$iv);
            DrawScope $this$draw_u24lambda_u241_u24lambda_u240 = $this$withTransform$iv$iv;
            boolean bl5 = false;
            DrawScope.drawPath-LG529CI$default((DrawScope)$this$draw_u24lambda_u241_u24lambda_u240, (Path)selectionPath, (long)this.backgroundSelectionColor, (float)0.0f, null, null, (int)0, (int)60, null);
            $this$withTransform_u24lambda_u246$iv$iv.getCanvas().restore();
            $this$withTransform_u24lambda_u246$iv$iv.setSize-uvyYCjk(previousSize$iv$iv);
        } else {
            DrawScope.drawPath-LG529CI$default((DrawScope)$this$draw_u24lambda_u241, (Path)selectionPath, (long)this.backgroundSelectionColor, (float)0.0f, null, null, (int)0, (int)60, null);
        }
    }

    public /* synthetic */ SelectionController(SelectionRegistrar selectionRegistrar, long backgroundSelectionColor, StaticTextSelectionParams params, DefaultConstructorMarker $constructor_marker) {
        this(selectionRegistrar, backgroundSelectionColor, params);
    }

    public static final /* synthetic */ StaticTextSelectionParams access$getParams$p(SelectionController $this) {
        return $this.params;
    }
}

