/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.compat.quirk;

import android.media.MediaFormat;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.Quirk;

@RequiresApi(value=21)
public class MediaCodecInfoReportIncorrectInfoQuirk
implements Quirk {
    static boolean load() {
        return MediaCodecInfoReportIncorrectInfoQuirk.isNokia1() || MediaCodecInfoReportIncorrectInfoQuirk.isMotoC() || MediaCodecInfoReportIncorrectInfoQuirk.isX650() || MediaCodecInfoReportIncorrectInfoQuirk.isX230() || MediaCodecInfoReportIncorrectInfoQuirk.isHuaweiMate9() || MediaCodecInfoReportIncorrectInfoQuirk.isPositivoTwist2Pro() || MediaCodecInfoReportIncorrectInfoQuirk.isRedmiNote4() || MediaCodecInfoReportIncorrectInfoQuirk.isLGK430();
    }

    private static boolean isNokia1() {
        return "Nokia".equalsIgnoreCase(Build.BRAND) && "Nokia 1".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isMotoC() {
        return "motorola".equalsIgnoreCase(Build.BRAND) && "moto c".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isX650() {
        return "infinix".equalsIgnoreCase(Build.BRAND) && "infinix x650".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isX230() {
        return "LGE".equalsIgnoreCase(Build.BRAND) && "LG-X230".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isHuaweiMate9() {
        return "Huawei".equalsIgnoreCase(Build.BRAND) && "mha-l29".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isPositivoTwist2Pro() {
        return "positivo".equalsIgnoreCase(Build.BRAND) && "twist 2 pro".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isRedmiNote4() {
        return "Xiaomi".equalsIgnoreCase(Build.BRAND) && "redmi note 4".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isLGK430() {
        return "lge".equalsIgnoreCase(Build.BRAND) && "lg-k430".equalsIgnoreCase(Build.MODEL);
    }

    public boolean isUnSupportMediaCodecInfo(@NonNull MediaFormat mediaFormat) {
        if (MediaCodecInfoReportIncorrectInfoQuirk.isNokia1() || MediaCodecInfoReportIncorrectInfoQuirk.isMotoC() || MediaCodecInfoReportIncorrectInfoQuirk.isX650() || MediaCodecInfoReportIncorrectInfoQuirk.isX230() || MediaCodecInfoReportIncorrectInfoQuirk.isPositivoTwist2Pro()) {
            String mimeType = mediaFormat.getString("mime");
            return "video/mp4v-es".equals(mimeType);
        }
        if (MediaCodecInfoReportIncorrectInfoQuirk.isHuaweiMate9() && this.isVideoFormat(mediaFormat)) {
            int width = mediaFormat.getInteger("width");
            int height = mediaFormat.getInteger("height");
            return width == 3840 && height == 2160;
        }
        if ((MediaCodecInfoReportIncorrectInfoQuirk.isRedmiNote4() || MediaCodecInfoReportIncorrectInfoQuirk.isLGK430()) && "video/avc".equals(mediaFormat.getString("mime"))) {
            int width = mediaFormat.getInteger("width");
            int height = mediaFormat.getInteger("height");
            return width == 1920 && height == 1080;
        }
        return false;
    }

    private boolean isVideoFormat(@NonNull MediaFormat mediaFormat) {
        String mimeType = mediaFormat.getString("mime");
        return mimeType.contains("video/");
    }
}

