/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.util.Range;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.video.AutoValue_VideoSpec;
import androidx.camera.video.FallbackStrategy;
import androidx.camera.video.Quality;
import androidx.camera.video.QualitySelector;
import com.google.auto.value.AutoValue;
import java.util.Arrays;

@RequiresApi(value=21)
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@AutoValue
public abstract class VideoSpec {
    @NonNull
    public static final Range<Integer> FRAME_RATE_RANGE_AUTO = new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE));
    @NonNull
    public static final Range<Integer> BITRATE_RANGE_AUTO = new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE));
    @NonNull
    public static final QualitySelector QUALITY_SELECTOR_AUTO = QualitySelector.fromOrderedList(Arrays.asList(Quality.FHD, Quality.HD, Quality.SD), FallbackStrategy.higherQualityOrLowerThan(Quality.FHD));
    static final int ASPECT_RATIO_AUTO = -1;
    static final int ASPECT_RATIO_4_3 = 0;
    static final int ASPECT_RATIO_16_9 = 1;

    VideoSpec() {
    }

    @NonNull
    public static Builder builder() {
        return new AutoValue_VideoSpec.Builder().setQualitySelector(QUALITY_SELECTOR_AUTO).setFrameRate(FRAME_RATE_RANGE_AUTO).setBitrate(BITRATE_RANGE_AUTO).setAspectRatio(-1);
    }

    @NonNull
    public abstract QualitySelector getQualitySelector();

    @NonNull
    public abstract Range<Integer> getFrameRate();

    @NonNull
    public abstract Range<Integer> getBitrate();

    abstract int getAspectRatio();

    @NonNull
    public abstract Builder toBuilder();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        @NonNull
        public abstract Builder setQualitySelector(@NonNull QualitySelector var1);

        @NonNull
        public abstract Builder setFrameRate(@NonNull Range<Integer> var1);

        @NonNull
        public abstract Builder setBitrate(@NonNull Range<Integer> var1);

        @NonNull
        abstract Builder setAspectRatio(int var1);

        @NonNull
        public abstract VideoSpec build();
    }
}

