/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.media.MediaMuxer;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.Logger;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.impl.CamcorderProfileProxy;
import androidx.camera.core.impl.MutableStateObservable;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.StateObservable;
import androidx.camera.core.impl.utils.CloseGuardHelper;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.video.AudioSpec;
import androidx.camera.video.AudioStats;
import androidx.camera.video.AutoValue_Recorder_RecordingRecord;
import androidx.camera.video.FallbackStrategy;
import androidx.camera.video.FileDescriptorOutputOptions;
import androidx.camera.video.FileOutputOptions;
import androidx.camera.video.MediaSpec;
import androidx.camera.video.MediaStoreOutputOptions;
import androidx.camera.video.OutputOptions;
import androidx.camera.video.OutputResults;
import androidx.camera.video.PendingRecording;
import androidx.camera.video.Quality;
import androidx.camera.video.QualitySelector;
import androidx.camera.video.Recording;
import androidx.camera.video.RecordingStats;
import androidx.camera.video.StreamInfo;
import androidx.camera.video.VideoCapabilities;
import androidx.camera.video.VideoOutput;
import androidx.camera.video.VideoRecordEvent;
import androidx.camera.video.VideoSpec;
import androidx.camera.video.internal.AudioSource;
import androidx.camera.video.internal.AudioSourceAccessException;
import androidx.camera.video.internal.DebugUtils;
import androidx.camera.video.internal.ResourceCreationException;
import androidx.camera.video.internal.compat.Api26Impl;
import androidx.camera.video.internal.compat.quirk.DeactivateEncoderSurfaceBeforeStopEncoderQuirk;
import androidx.camera.video.internal.compat.quirk.DeviceQuirks;
import androidx.camera.video.internal.compat.quirk.EncoderNotUsePersistentInputSurfaceQuirk;
import androidx.camera.video.internal.config.AudioEncoderConfigCamcorderProfileResolver;
import androidx.camera.video.internal.config.AudioEncoderConfigDefaultResolver;
import androidx.camera.video.internal.config.AudioSourceSettingsCamcorderProfileResolver;
import androidx.camera.video.internal.config.AudioSourceSettingsDefaultResolver;
import androidx.camera.video.internal.config.MimeInfo;
import androidx.camera.video.internal.config.VideoEncoderConfigCamcorderProfileResolver;
import androidx.camera.video.internal.config.VideoEncoderConfigDefaultResolver;
import androidx.camera.video.internal.encoder.AudioEncoderConfig;
import androidx.camera.video.internal.encoder.BufferCopiedEncodedData;
import androidx.camera.video.internal.encoder.EncodeException;
import androidx.camera.video.internal.encoder.EncodedData;
import androidx.camera.video.internal.encoder.Encoder;
import androidx.camera.video.internal.encoder.EncoderCallback;
import androidx.camera.video.internal.encoder.EncoderFactory;
import androidx.camera.video.internal.encoder.EncoderImpl;
import androidx.camera.video.internal.encoder.InvalidConfigException;
import androidx.camera.video.internal.encoder.OutputConfig;
import androidx.camera.video.internal.encoder.VideoEncoderConfig;
import androidx.camera.video.internal.utils.ArrayDequeRingBuffer;
import androidx.camera.video.internal.utils.OutputUtil;
import androidx.camera.video.internal.utils.RingBuffer;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@RequiresApi(value=21)
public final class Recorder
implements VideoOutput {
    private static final String TAG = "Recorder";
    private static final Set<State> PENDING_STATES = Collections.unmodifiableSet(EnumSet.of(State.PENDING_RECORDING, State.PENDING_PAUSED));
    private static final Set<State> VALID_NON_PENDING_STATES_WHILE_PENDING = Collections.unmodifiableSet(EnumSet.of(State.INITIALIZING, State.IDLING, State.RESETTING, State.STOPPING, State.ERROR));
    public static final QualitySelector DEFAULT_QUALITY_SELECTOR = QualitySelector.fromOrderedList(Arrays.asList(Quality.FHD, Quality.HD, Quality.SD), FallbackStrategy.higherQualityOrLowerThan(Quality.FHD));
    private static final VideoSpec VIDEO_SPEC_DEFAULT = VideoSpec.builder().setQualitySelector(DEFAULT_QUALITY_SELECTOR).setAspectRatio(1).build();
    private static final MediaSpec MEDIA_SPEC_DEFAULT = MediaSpec.builder().setOutputFormat(-1).setVideoSpec(VIDEO_SPEC_DEFAULT).build();
    private static final String MEDIA_COLUMN = "_data";
    private static final Exception PENDING_RECORDING_ERROR_CAUSE_SOURCE_INACTIVE = new RuntimeException("The video frame producer became inactive before any data was received.");
    private static final int PENDING = 1;
    private static final int NOT_PENDING = 0;
    private static final long SOURCE_NON_STREAMING_TIMEOUT_MS = 1000L;
    private static final int AUDIO_CACHE_SIZE = 60;
    @VisibleForTesting
    static final EncoderFactory DEFAULT_ENCODER_FACTORY = EncoderImpl::new;
    private final MutableStateObservable<StreamInfo> mStreamInfo;
    private final Executor mUserProvidedExecutor;
    private final Executor mExecutor;
    final Executor mSequentialExecutor;
    private final EncoderFactory mVideoEncoderFactory;
    private final EncoderFactory mAudioEncoderFactory;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private State mState = State.INITIALIZING;
    @GuardedBy(value="mLock")
    private State mNonPendingState = null;
    @GuardedBy(value="mLock")
    int mStreamId = 0;
    @GuardedBy(value="mLock")
    RecordingRecord mActiveRecordingRecord = null;
    @GuardedBy(value="mLock")
    RecordingRecord mPendingRecordingRecord = null;
    @GuardedBy(value="mLock")
    private long mLastGeneratedRecordingId = 0L;
    private RecordingRecord mInProgressRecording = null;
    private boolean mShouldWaitForNewSurface;
    boolean mInProgressRecordingStopping = false;
    private SurfaceRequest.TransformationInfo mSurfaceTransformationInfo = null;
    private CamcorderProfileProxy mResolvedCamcorderProfile = null;
    final List<ListenableFuture<Void>> mEncodingFutures = new ArrayList<ListenableFuture<Void>>();
    Integer mAudioTrackIndex = null;
    Integer mVideoTrackIndex = null;
    SurfaceRequest mSurfaceRequest;
    Surface mLatestSurface = null;
    Surface mActiveSurface = null;
    MediaMuxer mMediaMuxer = null;
    final MutableStateObservable<MediaSpec> mMediaSpec;
    AudioSource mAudioSource = null;
    Encoder mVideoEncoder = null;
    OutputConfig mVideoOutputConfig = null;
    Encoder mAudioEncoder = null;
    OutputConfig mAudioOutputConfig = null;
    AudioState mAudioState = AudioState.INITIALIZING;
    @NonNull
    Uri mOutputUri = Uri.EMPTY;
    long mRecordingBytes = 0L;
    long mRecordingDurationNs = 0L;
    @VisibleForTesting
    long mFirstRecordingVideoDataTimeUs = 0L;
    @VisibleForTesting
    long mFirstRecordingAudioDataTimeUs = 0L;
    long mFileSizeLimitInBytes = 0L;
    int mRecordingStopError = 1;
    Throwable mRecordingStopErrorCause = null;
    EncodedData mPendingFirstVideoData = null;
    @NonNull
    final RingBuffer<EncodedData> mPendingAudioRingBuffer = new ArrayDequeRingBuffer<EncodedData>(60);
    Throwable mAudioErrorCause = null;
    boolean mIsAudioSourceSilenced = false;
    VideoOutput.SourceState mSourceState = VideoOutput.SourceState.INACTIVE;
    private ScheduledFuture<?> mSourceNonStreamingTimeout = null;

    Recorder(@Nullable Executor executor, @NonNull MediaSpec mediaSpec, @NonNull EncoderFactory videoEncoderFactory, @NonNull EncoderFactory audioEncoderFactory) {
        this.mUserProvidedExecutor = executor;
        this.mExecutor = executor != null ? executor : CameraXExecutors.ioExecutor();
        this.mSequentialExecutor = CameraXExecutors.newSequentialExecutor((Executor)this.mExecutor);
        this.mMediaSpec = MutableStateObservable.withInitialState((Object)this.composeRecorderMediaSpec(mediaSpec));
        this.mStreamInfo = MutableStateObservable.withInitialState((Object)StreamInfo.of(this.mStreamId, this.internalStateToStreamState(this.mState)));
        this.mVideoEncoderFactory = videoEncoderFactory;
        this.mAudioEncoderFactory = audioEncoderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSurfaceRequested(@NonNull SurfaceRequest request) {
        Object object = this.mLock;
        synchronized (object) {
            Logger.d((String)TAG, (String)("Surface is requested in state: " + (Object)((Object)this.mState) + ", Current surface: " + this.mStreamId));
            switch (this.mState) {
                case STOPPING: 
                case RESETTING: 
                case PENDING_RECORDING: 
                case PENDING_PAUSED: 
                case INITIALIZING: {
                    this.mSequentialExecutor.execute(() -> {
                        this.mSurfaceRequest = request;
                        this.initializeInternal(this.mSurfaceRequest);
                    });
                    break;
                }
                case IDLING: 
                case RECORDING: 
                case PAUSED: {
                    throw new IllegalStateException("Surface was requested when the Recorder had been initialized with state " + (Object)((Object)this.mState));
                }
                case ERROR: {
                    Logger.w((String)TAG, (String)"Surface was requested when the Recorder had encountered error.");
                    this.setState(State.INITIALIZING);
                    this.mSequentialExecutor.execute(() -> {
                        if (this.mSurfaceRequest != null) {
                            this.mSurfaceRequest.willNotProvideSurface();
                        }
                        this.mSurfaceRequest = request;
                        this.initializeInternal(this.mSurfaceRequest);
                    });
                }
            }
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public Observable<MediaSpec> getMediaSpec() {
        return this.mMediaSpec;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public Observable<StreamInfo> getStreamInfo() {
        return this.mStreamInfo;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void onSourceStateChanged(@NonNull VideoOutput.SourceState newState) {
        this.mSequentialExecutor.execute(() -> this.onSourceStateChangedInternal(newState));
    }

    @NonNull
    public PendingRecording prepareRecording(@NonNull Context context, @NonNull FileOutputOptions fileOutputOptions) {
        return this.prepareRecordingInternal(context, fileOutputOptions);
    }

    @RequiresApi(value=26)
    @NonNull
    public PendingRecording prepareRecording(@NonNull Context context, @NonNull FileDescriptorOutputOptions fileDescriptorOutputOptions) {
        if (Build.VERSION.SDK_INT < 26) {
            throw new UnsupportedOperationException("File descriptors as output destinations are not supported on pre-Android O (API 26) devices.");
        }
        return this.prepareRecordingInternal(context, fileDescriptorOutputOptions);
    }

    @NonNull
    public PendingRecording prepareRecording(@NonNull Context context, @NonNull MediaStoreOutputOptions mediaStoreOutputOptions) {
        return this.prepareRecordingInternal(context, mediaStoreOutputOptions);
    }

    @NonNull
    private PendingRecording prepareRecordingInternal(@NonNull Context context, @NonNull OutputOptions options) {
        Preconditions.checkNotNull((Object)options, (Object)"The OutputOptions cannot be null.");
        return new PendingRecording(context, this, options);
    }

    @NonNull
    public QualitySelector getQualitySelector() {
        return this.getObservableData((StateObservable)this.mMediaSpec).getVideoSpec().getQualitySelector();
    }

    int getAudioSource() {
        return this.getObservableData((StateObservable)this.mMediaSpec).getAudioSpec().getSource();
    }

    @Nullable
    public Executor getExecutor() {
        return this.mUserProvidedExecutor;
    }

    int getAspectRatio() {
        return this.getObservableData((StateObservable)this.mMediaSpec).getVideoSpec().getAspectRatio();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    Recording start(@NonNull PendingRecording pendingRecording) {
        long recordingId;
        Preconditions.checkNotNull((Object)pendingRecording, (Object)"The given PendingRecording cannot be null.");
        RecordingRecord alreadyInProgressRecording = null;
        int error = 0;
        IOException errorCause = null;
        Object object = this.mLock;
        synchronized (object) {
            recordingId = ++this.mLastGeneratedRecordingId;
            switch (this.mState) {
                case RECORDING: 
                case PAUSED: {
                    alreadyInProgressRecording = this.mActiveRecordingRecord;
                    break;
                }
                case PENDING_RECORDING: 
                case PENDING_PAUSED: {
                    alreadyInProgressRecording = (RecordingRecord)Preconditions.checkNotNull((Object)this.mPendingRecordingRecord);
                    break;
                }
                case STOPPING: 
                case RESETTING: 
                case INITIALIZING: 
                case IDLING: 
                case ERROR: {
                    if (this.mState == State.IDLING) {
                        Preconditions.checkState((this.mActiveRecordingRecord == null && this.mPendingRecordingRecord == null ? 1 : 0) != 0, (String)"Expected recorder to be idle but a recording is either pending or in progress.");
                    }
                    try {
                        RecordingRecord recordingRecord = RecordingRecord.from(pendingRecording, recordingId);
                        recordingRecord.initializeRecording(pendingRecording.getApplicationContext());
                        this.mPendingRecordingRecord = recordingRecord;
                        if (this.mState == State.IDLING) {
                            this.setState(State.PENDING_RECORDING);
                            this.mSequentialExecutor.execute(this::tryServicePendingRecording);
                            break;
                        }
                        if (this.mState == State.ERROR) {
                            this.setState(State.PENDING_RECORDING);
                            this.mSequentialExecutor.execute(() -> {
                                if (this.mSurfaceRequest == null) {
                                    throw new AssertionError((Object)"surface request is required to retry initialization.");
                                }
                                this.initializeInternal(this.mSurfaceRequest);
                            });
                            break;
                        }
                        this.setState(State.PENDING_RECORDING);
                        break;
                    }
                    catch (IOException e) {
                        error = 5;
                        errorCause = e;
                    }
                }
            }
        }
        if (alreadyInProgressRecording != null) {
            throw new IllegalStateException("A recording is already in progress. Previous recordings must be stopped before a new recording can be started.");
        }
        if (error != 0) {
            Logger.e((String)TAG, (String)("Recording was started when the Recorder had encountered error " + errorCause));
            this.finalizePendingRecording(RecordingRecord.from(pendingRecording, recordingId), error, errorCause);
            return Recording.createFinalizedFrom(pendingRecording, recordingId);
        }
        return Recording.from(pendingRecording, recordingId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pause(@NonNull Recording activeRecording) {
        Object object = this.mLock;
        synchronized (object) {
            if (!Recorder.isSameRecording(activeRecording, this.mPendingRecordingRecord) && !Recorder.isSameRecording(activeRecording, this.mActiveRecordingRecord)) {
                Logger.d((String)TAG, (String)("pause() called on a recording that is no longer active: " + activeRecording.getOutputOptions()));
                return;
            }
            switch (this.mState) {
                case PENDING_RECORDING: {
                    this.setState(State.PENDING_PAUSED);
                    break;
                }
                case INITIALIZING: 
                case IDLING: {
                    throw new IllegalStateException("Called pause() from invalid state: " + (Object)((Object)this.mState));
                }
                case RECORDING: {
                    this.setState(State.PAUSED);
                    RecordingRecord finalActiveRecordingRecord = this.mActiveRecordingRecord;
                    this.mSequentialExecutor.execute(() -> this.pauseInternal(finalActiveRecordingRecord));
                    break;
                }
                case PENDING_PAUSED: 
                case PAUSED: {
                    break;
                }
                case STOPPING: 
                case RESETTING: {
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume(@NonNull Recording activeRecording) {
        Object object = this.mLock;
        synchronized (object) {
            if (!Recorder.isSameRecording(activeRecording, this.mPendingRecordingRecord) && !Recorder.isSameRecording(activeRecording, this.mActiveRecordingRecord)) {
                Logger.d((String)TAG, (String)("resume() called on a recording that is no longer active: " + activeRecording.getOutputOptions()));
                return;
            }
            switch (this.mState) {
                case PENDING_PAUSED: {
                    this.setState(State.PENDING_RECORDING);
                    break;
                }
                case INITIALIZING: 
                case IDLING: {
                    throw new IllegalStateException("Called resume() from invalid state: " + (Object)((Object)this.mState));
                }
                case STOPPING: 
                case RESETTING: 
                case PENDING_RECORDING: 
                case RECORDING: {
                    break;
                }
                case PAUSED: {
                    this.setState(State.RECORDING);
                    RecordingRecord finalActiveRecordingRecord = this.mActiveRecordingRecord;
                    this.mSequentialExecutor.execute(() -> this.resumeInternal(finalActiveRecordingRecord));
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop(@NonNull Recording activeRecording) {
        RecordingRecord pendingRecordingToFinalize = null;
        Object object = this.mLock;
        synchronized (object) {
            if (!Recorder.isSameRecording(activeRecording, this.mPendingRecordingRecord) && !Recorder.isSameRecording(activeRecording, this.mActiveRecordingRecord)) {
                Logger.d((String)TAG, (String)("stop() called on a recording that is no longer active: " + activeRecording.getOutputOptions()));
                return;
            }
            switch (this.mState) {
                case PENDING_RECORDING: 
                case PENDING_PAUSED: {
                    Preconditions.checkState((boolean)Recorder.isSameRecording(activeRecording, this.mPendingRecordingRecord));
                    pendingRecordingToFinalize = this.mPendingRecordingRecord;
                    this.mPendingRecordingRecord = null;
                    this.restoreNonPendingState();
                    break;
                }
                case STOPPING: 
                case RESETTING: {
                    Preconditions.checkState((boolean)Recorder.isSameRecording(activeRecording, this.mActiveRecordingRecord));
                    break;
                }
                case INITIALIZING: 
                case IDLING: {
                    throw new IllegalStateException("Calling stop() while idling or initializing is invalid.");
                }
                case RECORDING: 
                case PAUSED: {
                    this.setState(State.STOPPING);
                    long explicitlyStopTimeUs = TimeUnit.NANOSECONDS.toMicros(System.nanoTime());
                    RecordingRecord finalActiveRecordingRecord = this.mActiveRecordingRecord;
                    this.mSequentialExecutor.execute(() -> this.stopInternal(finalActiveRecordingRecord, explicitlyStopTimeUs, 0, null));
                    break;
                }
            }
        }
        if (pendingRecordingToFinalize != null) {
            this.finalizePendingRecording(pendingRecordingToFinalize, 8, new RuntimeException("Recording was stopped before any data could be produced."));
        }
    }

    private void finalizePendingRecording(@NonNull RecordingRecord recordingToFinalize, int error, @Nullable Throwable cause) {
        recordingToFinalize.finalizeRecording(Uri.EMPTY);
        recordingToFinalize.updateVideoRecordEvent(VideoRecordEvent.finalizeWithError(recordingToFinalize.getOutputOptions(), RecordingStats.of(0L, 0L, AudioStats.of(1, this.mAudioErrorCause)), OutputResults.of(Uri.EMPTY), error, cause));
    }

    void onSourceStateChangedInternal(@NonNull VideoOutput.SourceState newState) {
        VideoOutput.SourceState oldState = this.mSourceState;
        this.mSourceState = newState;
        if (oldState == newState) {
            Logger.d((String)TAG, (String)("Video source transitions to the same state: " + (Object)((Object)newState)));
            return;
        }
        Logger.d((String)TAG, (String)("Video source has transitioned to state: " + (Object)((Object)newState)));
        if (newState == VideoOutput.SourceState.INACTIVE) {
            if (this.mActiveSurface == null) {
                this.reset(4, null);
                this.setLatestSurface(null);
            } else if (this.mInProgressRecording != null) {
                this.onInProgressRecordingInternalError(this.mInProgressRecording, 4, null);
            }
        } else if (newState == VideoOutput.SourceState.ACTIVE_NON_STREAMING && this.mSourceNonStreamingTimeout != null && this.mSourceNonStreamingTimeout.cancel(false) && this.mVideoEncoder != null) {
            Recorder.notifyEncoderSourceStopped(this.mVideoEncoder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset(int errorCode, @Nullable Throwable errorCause) {
        boolean shouldReset = false;
        boolean shouldStop = false;
        Object object = this.mLock;
        synchronized (object) {
            switch (this.mState) {
                case PENDING_RECORDING: 
                case PENDING_PAUSED: {
                    shouldReset = true;
                    this.updateNonPendingState(State.RESETTING);
                    break;
                }
                case IDLING: 
                case ERROR: {
                    this.setState(State.INITIALIZING);
                }
                case INITIALIZING: {
                    shouldReset = true;
                    break;
                }
                case RECORDING: 
                case PAUSED: {
                    if (this.mActiveRecordingRecord != this.mInProgressRecording) {
                        throw new AssertionError((Object)"In-progress recording does not match the active recording. Unable to reset encoder.");
                    }
                    this.setState(State.RESETTING);
                    shouldStop = true;
                    break;
                }
                case STOPPING: {
                    this.setState(State.RESETTING);
                }
            }
        }
        if (shouldReset) {
            this.resetInternal();
        } else if (shouldStop) {
            this.stopInternal(this.mInProgressRecording, null, errorCode, errorCause);
        }
    }

    private void initializeInternal(@NonNull SurfaceRequest surfaceRequest) {
        if (this.mLatestSurface != null) {
            this.mActiveSurface = this.mLatestSurface;
            surfaceRequest.provideSurface(this.mLatestSurface, this.mSequentialExecutor, this::onSurfaceRequestComplete);
            this.onInitialized();
        } else {
            surfaceRequest.setTransformationInfoListener(this.mSequentialExecutor, transformationInfo -> {
                this.mSurfaceTransformationInfo = transformationInfo;
            });
            Size surfaceSize = surfaceRequest.getResolution();
            VideoCapabilities capabilities = VideoCapabilities.from(surfaceRequest.getCamera().getCameraInfo());
            Quality highestSupportedQuality = capabilities.findHighestSupportedQualityFor(surfaceSize);
            Logger.d((String)TAG, (String)("Using supported quality of " + highestSupportedQuality + " for surface size " + surfaceSize));
            if (highestSupportedQuality != Quality.NONE) {
                this.mResolvedCamcorderProfile = capabilities.getProfile(highestSupportedQuality);
                if (this.mResolvedCamcorderProfile == null) {
                    throw new AssertionError((Object)"Camera advertised available quality but did not produce CamcorderProfile for advertised quality.");
                }
            }
            this.setupVideo(surfaceRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInitialized() {
        RecordingRecord recordingToStart = null;
        RecordingRecord pendingRecordingToFinalize = null;
        int error = 0;
        Exception errorCause = null;
        boolean startRecordingPaused = false;
        Object object = this.mLock;
        synchronized (object) {
            switch (this.mState) {
                case RESETTING: 
                case IDLING: 
                case RECORDING: 
                case PAUSED: {
                    throw new AssertionError((Object)("Incorrectly invoke onInitialized() in state " + (Object)((Object)this.mState)));
                }
                case STOPPING: {
                    if (this.mShouldWaitForNewSurface) {
                        this.mShouldWaitForNewSurface = false;
                        break;
                    }
                    throw new AssertionError((Object)"Unexpectedly invoke onInitialized() in a STOPPING state when it's not waiting for a new surface.");
                }
                case INITIALIZING: {
                    this.setState(State.IDLING);
                    break;
                }
                case ERROR: {
                    Logger.e((String)TAG, (String)"onInitialized() was invoked when the Recorder had encountered error");
                    break;
                }
                case PENDING_PAUSED: {
                    startRecordingPaused = true;
                }
                case PENDING_RECORDING: {
                    if (this.mActiveRecordingRecord != null) break;
                    if (this.mSourceState == VideoOutput.SourceState.INACTIVE) {
                        pendingRecordingToFinalize = this.mPendingRecordingRecord;
                        this.mPendingRecordingRecord = null;
                        this.restoreNonPendingState();
                        error = 4;
                        errorCause = PENDING_RECORDING_ERROR_CAUSE_SOURCE_INACTIVE;
                        break;
                    }
                    recordingToStart = this.makePendingRecordingActiveLocked(this.mState);
                }
            }
        }
        if (recordingToStart != null) {
            this.startRecording(recordingToStart, startRecordingPaused);
        } else if (pendingRecordingToFinalize != null) {
            this.finalizePendingRecording(pendingRecordingToFinalize, error, errorCause);
        }
    }

    @NonNull
    private MediaSpec composeRecorderMediaSpec(@NonNull MediaSpec mediaSpec) {
        MediaSpec.Builder mediaSpecBuilder = mediaSpec.toBuilder();
        VideoSpec videoSpec = mediaSpec.getVideoSpec();
        if (videoSpec.getAspectRatio() == -1) {
            mediaSpecBuilder.configureVideo((Consumer<VideoSpec.Builder>)((Consumer)builder -> builder.setAspectRatio(VIDEO_SPEC_DEFAULT.getAspectRatio())));
        }
        return mediaSpecBuilder.build();
    }

    private static boolean isSameRecording(@NonNull Recording activeRecording, @Nullable RecordingRecord recordingRecord) {
        if (recordingRecord == null) {
            return false;
        }
        return activeRecording.getRecordingId() == recordingRecord.getRecordingId();
    }

    @NonNull
    private MimeInfo resolveAudioMimeInfo(@NonNull MediaSpec mediaSpec) {
        String mediaSpecAudioMime = MediaSpec.outputFormatToAudioMime(mediaSpec.getOutputFormat());
        int mediaSpecAudioProfile = MediaSpec.outputFormatToAudioProfile(mediaSpec.getOutputFormat());
        String resolvedAudioMime = mediaSpecAudioMime;
        int resolvedAudioProfile = mediaSpecAudioProfile;
        boolean camcorderProfileIsCompatible = false;
        if (this.mResolvedCamcorderProfile != null) {
            String camcorderProfileAudioMime = this.mResolvedCamcorderProfile.getAudioCodecMimeType();
            int camcorderProfileAudioProfile = this.mResolvedCamcorderProfile.getRequiredAudioProfile();
            if (camcorderProfileAudioMime == null) {
                Logger.d((String)TAG, (String)("CamcorderProfile contains undefined AUDIO mime type so cannot be used. May rely on fallback defaults to derive settings [chosen mime type: " + resolvedAudioMime + "(profile: " + resolvedAudioProfile + ")]"));
            } else if (mediaSpec.getOutputFormat() == -1) {
                camcorderProfileIsCompatible = true;
                resolvedAudioMime = camcorderProfileAudioMime;
                resolvedAudioProfile = camcorderProfileAudioProfile;
                Logger.d((String)TAG, (String)("MediaSpec contains OUTPUT_FORMAT_AUTO. Using CamcorderProfile to derive AUDIO settings [mime type: " + resolvedAudioMime + "(profile: " + resolvedAudioProfile + ")]"));
            } else if (Objects.equals(mediaSpecAudioMime, camcorderProfileAudioMime) && mediaSpecAudioProfile == camcorderProfileAudioProfile) {
                camcorderProfileIsCompatible = true;
                resolvedAudioMime = camcorderProfileAudioMime;
                resolvedAudioProfile = camcorderProfileAudioProfile;
                Logger.d((String)TAG, (String)("MediaSpec audio mime/profile matches CamcorderProfile. Using CamcorderProfile to derive AUDIO settings [mime type: " + resolvedAudioMime + "(profile: " + resolvedAudioProfile + ")]"));
            } else {
                Logger.d((String)TAG, (String)("MediaSpec audio mime or profile does not match CamcorderProfile, so CamcorderProfile settings cannot be used. May rely on fallback defaults to derive AUDIO settings [CamcorderProfile mime type: " + camcorderProfileAudioMime + "(profile: " + camcorderProfileAudioProfile + "), chosen mime type: " + resolvedAudioMime + "(profile: " + resolvedAudioProfile + ")]"));
            }
        }
        MimeInfo.Builder mimeInfoBuilder = MimeInfo.builder(resolvedAudioMime).setProfile(resolvedAudioProfile);
        if (camcorderProfileIsCompatible) {
            mimeInfoBuilder.setCompatibleCamcorderProfile(this.mResolvedCamcorderProfile);
        }
        return mimeInfoBuilder.build();
    }

    @NonNull
    private MimeInfo resolveVideoMimeInfo(@NonNull MediaSpec mediaSpec) {
        String mediaSpecVideoMime;
        String resolvedVideoMime = mediaSpecVideoMime = MediaSpec.outputFormatToVideoMime(mediaSpec.getOutputFormat());
        boolean camcorderProfileIsCompatible = false;
        if (this.mResolvedCamcorderProfile != null) {
            String camcorderProfileVideoMime = this.mResolvedCamcorderProfile.getVideoCodecMimeType();
            if (camcorderProfileVideoMime == null) {
                Logger.d((String)TAG, (String)("CamcorderProfile contains undefined VIDEO mime type so cannot be used. May rely on fallback defaults to derive settings [chosen mime type: " + resolvedVideoMime + "]"));
            } else if (mediaSpec.getOutputFormat() == -1) {
                camcorderProfileIsCompatible = true;
                resolvedVideoMime = camcorderProfileVideoMime;
                Logger.d((String)TAG, (String)("MediaSpec contains OUTPUT_FORMAT_AUTO. Using CamcorderProfile to derive VIDEO settings [mime type: " + resolvedVideoMime + "]"));
            } else if (Objects.equals(mediaSpecVideoMime, camcorderProfileVideoMime)) {
                camcorderProfileIsCompatible = true;
                resolvedVideoMime = camcorderProfileVideoMime;
                Logger.d((String)TAG, (String)("MediaSpec video mime matches CamcorderProfile. Using CamcorderProfile to derive VIDEO settings [mime type: " + resolvedVideoMime + "]"));
            } else {
                Logger.d((String)TAG, (String)("MediaSpec video mime does not match CamcorderProfile, so CamcorderProfile settings cannot be used. May rely on fallback defaults to derive VIDEO settings [CamcorderProfile mime type: " + camcorderProfileVideoMime + ", chosen mime type: " + resolvedVideoMime + "]"));
            }
        } else {
            Logger.d((String)TAG, (String)("No CamcorderProfile present. May rely on fallback defaults to derive VIDEO settings [chosen mime type: " + resolvedVideoMime + "]"));
        }
        MimeInfo.Builder mimeInfoBuilder = MimeInfo.builder(resolvedVideoMime);
        if (camcorderProfileIsCompatible) {
            mimeInfoBuilder.setCompatibleCamcorderProfile(this.mResolvedCamcorderProfile);
        }
        return mimeInfoBuilder.build();
    }

    @NonNull
    private static AudioSource.Settings resolveAudioSourceSettings(@NonNull MimeInfo audioMimeInfo, @NonNull AudioSpec audioSpec) {
        Object settingsSupplier = audioMimeInfo.getCompatibleCamcorderProfile() != null ? new AudioSourceSettingsCamcorderProfileResolver(audioSpec, audioMimeInfo.getCompatibleCamcorderProfile()) : new AudioSourceSettingsDefaultResolver(audioSpec);
        return (AudioSource.Settings)settingsSupplier.get();
    }

    @NonNull
    private static AudioEncoderConfig resolveAudioEncoderConfig(@NonNull MimeInfo audioMimeInfo, @NonNull AudioSource.Settings audioSourceSettings, @NonNull AudioSpec audioSpec) {
        Object configSupplier = audioMimeInfo.getCompatibleCamcorderProfile() != null ? new AudioEncoderConfigCamcorderProfileResolver(audioMimeInfo.getMimeType(), audioMimeInfo.getProfile(), audioSpec, audioSourceSettings, audioMimeInfo.getCompatibleCamcorderProfile()) : new AudioEncoderConfigDefaultResolver(audioMimeInfo.getMimeType(), audioMimeInfo.getProfile(), audioSpec, audioSourceSettings);
        return (AudioEncoderConfig)configSupplier.get();
    }

    @NonNull
    private static VideoEncoderConfig resolveVideoEncoderConfig(@NonNull MimeInfo videoMimeInfo, @NonNull VideoSpec videoSpec, @NonNull Size surfaceSize) {
        Object configSupplier = videoMimeInfo.getCompatibleCamcorderProfile() != null ? new VideoEncoderConfigCamcorderProfileResolver(videoMimeInfo.getMimeType(), videoSpec, surfaceSize, videoMimeInfo.getCompatibleCamcorderProfile()) : new VideoEncoderConfigDefaultResolver(videoMimeInfo.getMimeType(), videoSpec, surfaceSize);
        return (VideoEncoderConfig)configSupplier.get();
    }

    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    private void setupAudio(@NonNull RecordingRecord recordingToStart) throws ResourceCreationException {
        MediaSpec mediaSpec = this.getObservableData((StateObservable)this.mMediaSpec);
        MimeInfo audioMimeInfo = this.resolveAudioMimeInfo(mediaSpec);
        AudioSource.Settings audioSourceSettings = Recorder.resolveAudioSourceSettings(audioMimeInfo, mediaSpec.getAudioSpec());
        try {
            this.mAudioSource = this.setupAudioSource(recordingToStart, audioSourceSettings);
        }
        catch (AudioSourceAccessException e) {
            throw new ResourceCreationException(e);
        }
        AudioEncoderConfig audioEncoderConfig = Recorder.resolveAudioEncoderConfig(audioMimeInfo, audioSourceSettings, mediaSpec.getAudioSpec());
        try {
            this.mAudioEncoder = this.mAudioEncoderFactory.createEncoder(this.mExecutor, audioEncoderConfig);
        }
        catch (InvalidConfigException e) {
            throw new ResourceCreationException(e);
        }
        Encoder.EncoderInput bufferProvider = this.mAudioEncoder.getInput();
        if (!(bufferProvider instanceof Encoder.ByteBufferInput)) {
            throw new AssertionError((Object)"The EncoderInput of audio isn't a ByteBufferInput.");
        }
        this.mAudioSource.setBufferProvider((Encoder.ByteBufferInput)bufferProvider);
    }

    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    @NonNull
    private AudioSource setupAudioSource(@NonNull RecordingRecord recordingToStart, @NonNull AudioSource.Settings audioSourceSettings) throws AudioSourceAccessException {
        AudioSource audioSource = recordingToStart.performOneTimeAudioSourceCreation(audioSourceSettings, CameraXExecutors.ioExecutor());
        audioSource.setAudioSourceCallback(this.mSequentialExecutor, new AudioSource.AudioSourceCallback(){

            @Override
            public void onSilenced(boolean silenced) {
                if (Recorder.this.mIsAudioSourceSilenced != silenced) {
                    Recorder.this.mIsAudioSourceSilenced = silenced;
                    Recorder.this.mAudioErrorCause = silenced ? new IllegalStateException("The audio source has been silenced.") : null;
                    Recorder.this.updateInProgressStatusEvent();
                } else {
                    Logger.w((String)Recorder.TAG, (String)("Audio source silenced transitions to the same state " + silenced));
                }
            }

            @Override
            public void onError(@NonNull Throwable throwable) {
                if (throwable instanceof AudioSourceAccessException) {
                    Recorder.this.setAudioState(AudioState.DISABLED);
                    Recorder.this.updateInProgressStatusEvent();
                }
            }
        });
        return audioSource;
    }

    private void setupVideo(@NonNull SurfaceRequest surfaceRequest) {
        MediaSpec mediaSpec = this.getObservableData((StateObservable)this.mMediaSpec);
        MimeInfo videoMimeInfo = this.resolveVideoMimeInfo(mediaSpec);
        VideoEncoderConfig config = Recorder.resolveVideoEncoderConfig(videoMimeInfo, mediaSpec.getVideoSpec(), surfaceRequest.getResolution());
        try {
            this.mVideoEncoder = this.mVideoEncoderFactory.createEncoder(this.mExecutor, config);
        }
        catch (InvalidConfigException e) {
            Logger.e((String)TAG, (String)"Unable to initialize video encoder.", (Throwable)e);
            this.onEncoderSetupError(new ResourceCreationException(e));
            return;
        }
        Encoder.EncoderInput encoderInput = this.mVideoEncoder.getInput();
        if (!(encoderInput instanceof Encoder.SurfaceInput)) {
            throw new AssertionError((Object)"The EncoderInput of video isn't a SurfaceInput.");
        }
        ((Encoder.SurfaceInput)encoderInput).setOnSurfaceUpdateListener(this.mSequentialExecutor, surface -> {
            Object object = this.mLock;
            synchronized (object) {
                Logger.d((String)TAG, (String)("Encoder surface updated: " + surface.hashCode() + ", Current surface: " + this.mStreamId));
                switch (this.mState) {
                    case STOPPING: 
                    case PENDING_RECORDING: 
                    case PENDING_PAUSED: 
                    case INITIALIZING: 
                    case IDLING: {
                        this.onEncoderSurfaceUpdated(surface, surfaceRequest);
                        break;
                    }
                    case RECORDING: 
                    case PAUSED: {
                        throw new AssertionError((Object)("Unexpected state on update of encoder surface " + (Object)((Object)this.mState)));
                    }
                    case RESETTING: {
                        break;
                    }
                }
            }
        });
    }

    private void onEncoderSurfaceUpdated(@NonNull Surface surface, @NonNull SurfaceRequest surfaceRequest) {
        if (this.mLatestSurface != surface) {
            Surface currentSurface = this.mLatestSurface;
            this.setLatestSurface(surface);
            if (currentSurface == null) {
                this.mActiveSurface = surface;
                surfaceRequest.provideSurface(surface, this.mSequentialExecutor, this::onSurfaceRequestComplete);
                this.onInitialized();
            }
        } else {
            Logger.d((String)TAG, (String)"Video encoder provides the same surface.");
        }
    }

    private void onSurfaceRequestComplete(@NonNull SurfaceRequest.Result result) {
        Logger.d((String)TAG, (String)("Surface closed: " + result.getSurface().hashCode()));
        Surface resultSurface = result.getSurface();
        if (resultSurface == this.mActiveSurface) {
            if (this.mSourceNonStreamingTimeout != null && this.mSourceNonStreamingTimeout.cancel(false) && this.mVideoEncoder != null) {
                Recorder.notifyEncoderSourceStopped(this.mVideoEncoder);
            }
            boolean needsReset = false;
            if (this.mSourceState == VideoOutput.SourceState.INACTIVE) {
                Logger.d((String)TAG, (String)"Latest active surface no longer in use and source state is INACTIVE. Resetting recorder...");
                needsReset = true;
            } else if (this.mActiveSurface == this.mLatestSurface) {
                Logger.w((String)TAG, (String)"Source has stopped producing frames into active surface, yet source state is still active. Stopping any in-progress recordings and resetting encoders in case a new surface is required.");
                needsReset = true;
            }
            this.mActiveSurface = null;
            if (needsReset) {
                this.reset(4, null);
                this.setLatestSurface(null);
            }
        } else {
            resultSurface.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEncoderSetupError(@Nullable Throwable cause) {
        RecordingRecord pendingRecordingToFinalize = null;
        Object object = this.mLock;
        synchronized (object) {
            switch (this.mState) {
                case PENDING_RECORDING: 
                case PENDING_PAUSED: {
                    pendingRecordingToFinalize = this.mPendingRecordingRecord;
                    this.mPendingRecordingRecord = null;
                }
                case INITIALIZING: {
                    this.setStreamId(-1);
                    this.setState(State.ERROR);
                    break;
                }
                case ERROR: {
                    break;
                }
                case STOPPING: 
                case RESETTING: 
                case IDLING: 
                case RECORDING: 
                case PAUSED: {
                    throw new AssertionError((Object)("Encountered encoder setup error while in unexpected state " + (Object)((Object)this.mState) + ": " + cause));
                }
            }
        }
        if (pendingRecordingToFinalize != null) {
            this.finalizePendingRecording(pendingRecordingToFinalize, 7, cause);
        }
    }

    void setupAndStartMediaMuxer(@NonNull RecordingRecord recordingToStart) {
        if (this.mMediaMuxer != null) {
            throw new AssertionError((Object)"Unable to set up media muxer when one already exists.");
        }
        if (this.isAudioEnabled() && this.mPendingAudioRingBuffer.isEmpty()) {
            throw new AssertionError((Object)"Audio is enabled but no audio sample is ready. Cannot start media muxer.");
        }
        if (this.mPendingFirstVideoData == null) {
            throw new AssertionError((Object)"Media muxer cannot be started without an encoded video frame.");
        }
        try (EncodedData videoDataToWrite = this.mPendingFirstVideoData;){
            this.mPendingFirstVideoData = null;
            List<EncodedData> audioDataToWrite = this.getAudioDataToWriteAndClearCache(videoDataToWrite.getPresentationTimeUs());
            long firstDataSize = videoDataToWrite.size();
            for (EncodedData data : audioDataToWrite) {
                firstDataSize += data.size();
            }
            if (this.mFileSizeLimitInBytes != 0L && firstDataSize > this.mFileSizeLimitInBytes) {
                Logger.d((String)TAG, (String)String.format("Initial data exceeds file size limit %d > %d", firstDataSize, this.mFileSizeLimitInBytes));
                this.onInProgressRecordingInternalError(recordingToStart, 2, null);
                return;
            }
            try {
                MediaSpec mediaSpec = this.getObservableData((StateObservable)this.mMediaSpec);
                int muxerOutputFormat = mediaSpec.getOutputFormat() == -1 ? Recorder.supportedMuxerFormatOrDefaultFrom(this.mResolvedCamcorderProfile, MediaSpec.outputFormatToMuxerFormat(MEDIA_SPEC_DEFAULT.getOutputFormat())) : MediaSpec.outputFormatToMuxerFormat(mediaSpec.getOutputFormat());
                this.mMediaMuxer = recordingToStart.performOneTimeMediaMuxerCreation(muxerOutputFormat, (Consumer<Uri>)((Consumer)uri -> {
                    this.mOutputUri = uri;
                }));
            }
            catch (IOException e) {
                this.onInProgressRecordingInternalError(recordingToStart, 5, e);
                if (videoDataToWrite != null) {
                    videoDataToWrite.close();
                }
                return;
            }
            if (this.mSurfaceTransformationInfo != null) {
                this.mMediaMuxer.setOrientationHint(this.mSurfaceTransformationInfo.getRotationDegrees());
            }
            this.mVideoTrackIndex = this.mMediaMuxer.addTrack(this.mVideoOutputConfig.getMediaFormat());
            if (this.isAudioEnabled()) {
                this.mAudioTrackIndex = this.mMediaMuxer.addTrack(this.mAudioOutputConfig.getMediaFormat());
            }
            this.mMediaMuxer.start();
            this.writeVideoData(videoDataToWrite, recordingToStart);
            for (EncodedData data : audioDataToWrite) {
                this.writeAudioData(data, recordingToStart);
            }
        }
    }

    @NonNull
    private List<EncodedData> getAudioDataToWriteAndClearCache(long firstVideoDataTimeUs) {
        EncodedData data;
        ArrayList<EncodedData> res = new ArrayList<EncodedData>();
        while ((data = this.mPendingAudioRingBuffer.poll()) != null) {
            if (data.getPresentationTimeUs() < firstVideoDataTimeUs) continue;
            res.add(data);
        }
        return res;
    }

    @SuppressLint(value={"MissingPermission"})
    private void startInternal(@NonNull RecordingRecord recordingToStart) {
        if (this.mInProgressRecording != null) {
            throw new AssertionError((Object)"Attempted to start a new recording while another was in progress.");
        }
        if (recordingToStart.getOutputOptions().getFileSizeLimit() > 0L) {
            this.mFileSizeLimitInBytes = Math.round((double)recordingToStart.getOutputOptions().getFileSizeLimit() * 0.95);
            Logger.d((String)TAG, (String)("File size limit in bytes: " + this.mFileSizeLimitInBytes));
        } else {
            this.mFileSizeLimitInBytes = 0L;
        }
        this.mInProgressRecording = recordingToStart;
        switch (this.mAudioState) {
            case ERROR: 
            case ACTIVE: 
            case DISABLED: {
                throw new AssertionError((Object)("Incorrectly invoke startInternal in audio state " + (Object)((Object)this.mAudioState)));
            }
            case IDLING: {
                this.setAudioState(recordingToStart.hasAudioEnabled() ? AudioState.ACTIVE : AudioState.DISABLED);
                break;
            }
            case INITIALIZING: {
                if (!recordingToStart.hasAudioEnabled()) break;
                if (!this.isAudioSupported()) {
                    throw new AssertionError((Object)"The Recorder doesn't support recording with audio");
                }
                try {
                    this.setupAudio(recordingToStart);
                    this.setAudioState(AudioState.ACTIVE);
                    break;
                }
                catch (ResourceCreationException e) {
                    Logger.e((String)TAG, (String)"Unable to create audio resource with error: ", (Throwable)e);
                    this.setAudioState(AudioState.ERROR);
                    this.mAudioErrorCause = e;
                }
            }
        }
        this.initEncoderCallbacks(recordingToStart);
        if (this.isAudioEnabled()) {
            this.mAudioSource.start();
            this.mAudioEncoder.start();
        }
        this.mVideoEncoder.start();
        this.mInProgressRecording.updateVideoRecordEvent(VideoRecordEvent.start(this.mInProgressRecording.getOutputOptions(), this.getInProgressRecordingStats()));
    }

    private void initEncoderCallbacks(final @NonNull RecordingRecord recordingToStart) {
        this.mEncodingFutures.add((ListenableFuture<Void>)CallbackToFutureAdapter.getFuture(completer -> {
            this.mVideoEncoder.setEncoderCallback(new EncoderCallback(){

                @Override
                public void onEncodeStart() {
                }

                @Override
                public void onEncodeStop() {
                    completer.set(null);
                }

                @Override
                public void onEncodeError(@NonNull EncodeException e) {
                    completer.setException((Throwable)e);
                }

                @Override
                public void onEncodedData(@NonNull EncodedData encodedData) {
                    if (Recorder.this.mMediaMuxer == null) {
                        if (!Recorder.this.mInProgressRecordingStopping) {
                            boolean cachedDataDropped = false;
                            if (Recorder.this.mPendingFirstVideoData != null) {
                                cachedDataDropped = true;
                                Recorder.this.mPendingFirstVideoData.close();
                                Recorder.this.mPendingFirstVideoData = null;
                            }
                            if (encodedData.isKeyFrame()) {
                                Recorder.this.mPendingFirstVideoData = encodedData;
                                if (!Recorder.this.isAudioEnabled() || !Recorder.this.mPendingAudioRingBuffer.isEmpty()) {
                                    Logger.d((String)Recorder.TAG, (String)"Received video keyframe. Starting muxer...");
                                    Recorder.this.setupAndStartMediaMuxer(recordingToStart);
                                } else if (cachedDataDropped) {
                                    Logger.d((String)Recorder.TAG, (String)"Replaced cached video keyframe with newer keyframe.");
                                } else {
                                    Logger.d((String)Recorder.TAG, (String)"Cached video keyframe while we wait for first audio sample before starting muxer.");
                                }
                            } else {
                                if (cachedDataDropped) {
                                    Logger.d((String)Recorder.TAG, (String)"Dropped cached keyframe since we have new video data and have not yet received audio data.");
                                }
                                Logger.d((String)Recorder.TAG, (String)"Dropped video data since muxer has not yet started and data is not a keyframe.");
                                Recorder.this.mVideoEncoder.requestKeyFrame();
                                encodedData.close();
                            }
                        } else {
                            Logger.d((String)Recorder.TAG, (String)"Drop video data since recording is stopping.");
                            encodedData.close();
                        }
                    } else {
                        try (EncodedData videoDataToWrite = encodedData;){
                            Recorder.this.writeVideoData(videoDataToWrite, recordingToStart);
                        }
                    }
                }

                @Override
                public void onOutputConfigUpdate(@NonNull OutputConfig outputConfig) {
                    Recorder.this.mVideoOutputConfig = outputConfig;
                }
            }, this.mSequentialExecutor);
            return "videoEncodingFuture";
        }));
        if (this.isAudioEnabled()) {
            this.mEncodingFutures.add((ListenableFuture<Void>)CallbackToFutureAdapter.getFuture(completer -> {
                this.mAudioEncoder.setEncoderCallback(new EncoderCallback(){

                    @Override
                    public void onEncodeStart() {
                    }

                    @Override
                    public void onEncodeStop() {
                        completer.set(null);
                    }

                    @Override
                    public void onEncodeError(@NonNull EncodeException e) {
                        Recorder.this.setAudioState(AudioState.ERROR);
                        Recorder.this.mAudioErrorCause = e;
                        Recorder.this.updateInProgressStatusEvent();
                        completer.set(null);
                    }

                    @Override
                    public void onEncodedData(@NonNull EncodedData encodedData) {
                        if (Recorder.this.mAudioState == AudioState.DISABLED) {
                            throw new AssertionError((Object)"Audio is not enabled but audio encoded data is produced.");
                        }
                        if (Recorder.this.mMediaMuxer == null) {
                            if (!Recorder.this.mInProgressRecordingStopping) {
                                Recorder.this.mPendingAudioRingBuffer.offer(new BufferCopiedEncodedData(encodedData));
                                if (Recorder.this.mPendingFirstVideoData != null) {
                                    Logger.d((String)Recorder.TAG, (String)"Received audio data. Starting muxer...");
                                    Recorder.this.setupAndStartMediaMuxer(recordingToStart);
                                } else {
                                    Logger.d((String)Recorder.TAG, (String)"Cached audio data while we wait for video keyframe before starting muxer.");
                                }
                            } else {
                                Logger.d((String)Recorder.TAG, (String)"Drop audio data since recording is stopping.");
                            }
                            encodedData.close();
                        } else {
                            try (EncodedData audioDataToWrite = encodedData;){
                                Recorder.this.writeAudioData(audioDataToWrite, recordingToStart);
                            }
                        }
                    }

                    @Override
                    public void onOutputConfigUpdate(@NonNull OutputConfig outputConfig) {
                        Recorder.this.mAudioOutputConfig = outputConfig;
                    }
                }, this.mSequentialExecutor);
                return "audioEncodingFuture";
            }));
        }
        Futures.addCallback((ListenableFuture)Futures.allAsList(this.mEncodingFutures), (FutureCallback)new FutureCallback<List<Void>>(){

            public void onSuccess(@Nullable List<Void> result) {
                Logger.d((String)Recorder.TAG, (String)"Encodings end successfully.");
                Recorder.this.finalizeInProgressRecording(Recorder.this.mRecordingStopError, Recorder.this.mRecordingStopErrorCause);
            }

            public void onFailure(Throwable t) {
                Logger.d((String)Recorder.TAG, (String)("Encodings end with error: " + t));
                Recorder.this.finalizeInProgressRecording(6, t);
            }
        }, (Executor)CameraXExecutors.directExecutor());
    }

    void writeVideoData(@NonNull EncodedData encodedData, @NonNull RecordingRecord recording) {
        if (this.mVideoTrackIndex == null) {
            throw new AssertionError((Object)"Video data comes before the track is added to MediaMuxer.");
        }
        long newRecordingBytes = this.mRecordingBytes + encodedData.size();
        if (this.mFileSizeLimitInBytes != 0L && newRecordingBytes > this.mFileSizeLimitInBytes) {
            Logger.d((String)TAG, (String)String.format("Reach file size limit %d > %d", newRecordingBytes, this.mFileSizeLimitInBytes));
            this.onInProgressRecordingInternalError(recording, 2, null);
            return;
        }
        this.mMediaMuxer.writeSampleData(this.mVideoTrackIndex.intValue(), encodedData.getByteBuffer(), encodedData.getBufferInfo());
        this.mRecordingBytes = newRecordingBytes;
        if (this.mFirstRecordingVideoDataTimeUs == 0L) {
            this.mFirstRecordingVideoDataTimeUs = encodedData.getPresentationTimeUs();
            Logger.d((String)TAG, (String)String.format("First video time: %d (%s)", this.mFirstRecordingVideoDataTimeUs, DebugUtils.readableUs(this.mFirstRecordingVideoDataTimeUs)));
        }
        this.mRecordingDurationNs = TimeUnit.MICROSECONDS.toNanos(encodedData.getPresentationTimeUs() - this.mFirstRecordingVideoDataTimeUs);
        this.updateInProgressStatusEvent();
    }

    void writeAudioData(@NonNull EncodedData encodedData, @NonNull RecordingRecord recording) {
        long newRecordingBytes = this.mRecordingBytes + encodedData.size();
        if (this.mFileSizeLimitInBytes != 0L && newRecordingBytes > this.mFileSizeLimitInBytes) {
            Logger.d((String)TAG, (String)String.format("Reach file size limit %d > %d", newRecordingBytes, this.mFileSizeLimitInBytes));
            this.onInProgressRecordingInternalError(recording, 2, null);
            return;
        }
        this.mMediaMuxer.writeSampleData(this.mAudioTrackIndex.intValue(), encodedData.getByteBuffer(), encodedData.getBufferInfo());
        this.mRecordingBytes = newRecordingBytes;
        if (this.mFirstRecordingAudioDataTimeUs == 0L) {
            this.mFirstRecordingAudioDataTimeUs = encodedData.getPresentationTimeUs();
            Logger.d((String)TAG, (String)String.format("First audio time: %d (%s)", this.mFirstRecordingAudioDataTimeUs, DebugUtils.readableUs(this.mFirstRecordingAudioDataTimeUs)));
        }
    }

    private void pauseInternal(@NonNull RecordingRecord recordingToPause) {
        if (this.mInProgressRecording == recordingToPause && !this.mInProgressRecordingStopping) {
            if (this.isAudioEnabled()) {
                this.mAudioEncoder.pause();
            }
            this.mVideoEncoder.pause();
            this.mInProgressRecording.updateVideoRecordEvent(VideoRecordEvent.pause(this.mInProgressRecording.getOutputOptions(), this.getInProgressRecordingStats()));
        }
    }

    private void resumeInternal(@NonNull RecordingRecord recordingToResume) {
        if (this.mInProgressRecording == recordingToResume && !this.mInProgressRecordingStopping) {
            if (this.isAudioEnabled()) {
                this.mAudioEncoder.start();
            }
            this.mVideoEncoder.start();
            this.mInProgressRecording.updateVideoRecordEvent(VideoRecordEvent.resume(this.mInProgressRecording.getOutputOptions(), this.getInProgressRecordingStats()));
        }
    }

    void stopInternal(@NonNull RecordingRecord recordingToStop, @Nullable Long explicitlyStopTime, int stopError, @Nullable Throwable errorCause) {
        if (this.mInProgressRecording == recordingToStop && !this.mInProgressRecordingStopping) {
            this.mShouldWaitForNewSurface = DeviceQuirks.get(EncoderNotUsePersistentInputSurfaceQuirk.class) != null;
            this.mInProgressRecordingStopping = true;
            this.mRecordingStopError = stopError;
            this.mRecordingStopErrorCause = errorCause;
            if (this.isAudioEnabled()) {
                this.mPendingAudioRingBuffer.clear();
                if (explicitlyStopTime == null) {
                    this.mAudioEncoder.stop();
                } else {
                    this.mAudioEncoder.stop(explicitlyStopTime);
                }
            }
            if (this.mPendingFirstVideoData != null) {
                this.mPendingFirstVideoData.close();
                this.mPendingFirstVideoData = null;
            }
            if (this.mSourceState != VideoOutput.SourceState.ACTIVE_NON_STREAMING) {
                Encoder finalVideoEncoder = this.mVideoEncoder;
                this.mSourceNonStreamingTimeout = CameraXExecutors.mainThreadExecutor().schedule(() -> this.mSequentialExecutor.execute(() -> {
                    Logger.d((String)TAG, (String)"The source didn't become non-streaming before timeout. Waited 1000ms");
                    if (DeviceQuirks.get(DeactivateEncoderSurfaceBeforeStopEncoderQuirk.class) != null) {
                        Recorder.notifyEncoderSourceStopped(finalVideoEncoder);
                    }
                }), 1000L, TimeUnit.MILLISECONDS);
            } else {
                Recorder.notifyEncoderSourceStopped(this.mVideoEncoder);
            }
            if (explicitlyStopTime == null) {
                this.mVideoEncoder.stop();
            } else {
                this.mVideoEncoder.stop(explicitlyStopTime);
            }
        }
    }

    private static void notifyEncoderSourceStopped(@NonNull Encoder encoder) {
        if (encoder instanceof EncoderImpl) {
            ((EncoderImpl)encoder).signalSourceStopped();
        }
    }

    private void resetInternal() {
        if (this.mAudioEncoder != null) {
            Logger.d((String)TAG, (String)"Releasing audio encoder.");
            this.mAudioEncoder.release();
            this.mAudioEncoder = null;
            this.mAudioOutputConfig = null;
        }
        if (this.mVideoEncoder != null) {
            Logger.d((String)TAG, (String)"Releasing video encoder.");
            this.mVideoEncoder.release();
            this.mVideoEncoder = null;
            this.mVideoOutputConfig = null;
        }
        if (this.mAudioSource != null) {
            Logger.d((String)TAG, (String)"Releasing audio source.");
            this.mAudioSource.release();
            this.mAudioSource = null;
        }
        this.setAudioState(AudioState.INITIALIZING);
    }

    private int internalAudioStateToAudioStatsState(@NonNull AudioState audioState) {
        switch (audioState) {
            case DISABLED: 
            case INITIALIZING: {
                return 1;
            }
            case ACTIVE: {
                if (this.mIsAudioSourceSilenced) {
                    return 2;
                }
                return 0;
            }
            case ERROR: {
                return 3;
            }
        }
        throw new AssertionError((Object)("Invalid internal audio state: " + (Object)((Object)audioState)));
    }

    @NonNull
    private StreamInfo.StreamState internalStateToStreamState(@NonNull State state) {
        DeactivateEncoderSurfaceBeforeStopEncoderQuirk quirk = DeviceQuirks.get(DeactivateEncoderSurfaceBeforeStopEncoderQuirk.class);
        return state == State.RECORDING || state == State.STOPPING && quirk == null ? StreamInfo.StreamState.ACTIVE : StreamInfo.StreamState.INACTIVE;
    }

    boolean isAudioEnabled() {
        return this.mAudioState == AudioState.ACTIVE;
    }

    void finalizeInProgressRecording(int error, @Nullable Throwable throwable) {
        if (this.mInProgressRecording == null) {
            throw new AssertionError((Object)"Attempted to finalize in-progress recording, but no recording is in progress.");
        }
        int errorToSend = error;
        if (this.mMediaMuxer != null) {
            block12: {
                try {
                    this.mMediaMuxer.stop();
                    this.mMediaMuxer.release();
                }
                catch (IllegalStateException e) {
                    Logger.e((String)TAG, (String)("MediaMuxer failed to stop or release with error: " + e.getMessage()));
                    if (errorToSend != 0) break block12;
                    errorToSend = 1;
                }
            }
            this.mMediaMuxer = null;
        } else if (errorToSend == 0) {
            errorToSend = 8;
        }
        this.mInProgressRecording.finalizeRecording(this.mOutputUri);
        OutputOptions outputOptions = this.mInProgressRecording.getOutputOptions();
        RecordingStats stats = this.getInProgressRecordingStats();
        OutputResults outputResults = OutputResults.of(this.mOutputUri);
        this.mInProgressRecording.updateVideoRecordEvent(errorToSend == 0 ? VideoRecordEvent.finalize(outputOptions, stats, outputResults) : VideoRecordEvent.finalizeWithError(outputOptions, stats, outputResults, errorToSend, throwable));
        RecordingRecord finalizedRecording = this.mInProgressRecording;
        this.mInProgressRecording = null;
        this.mInProgressRecordingStopping = false;
        this.mAudioTrackIndex = null;
        this.mVideoTrackIndex = null;
        this.mEncodingFutures.clear();
        this.mOutputUri = Uri.EMPTY;
        this.mRecordingBytes = 0L;
        this.mRecordingDurationNs = 0L;
        this.mFirstRecordingVideoDataTimeUs = 0L;
        this.mFirstRecordingAudioDataTimeUs = 0L;
        this.mRecordingStopError = 1;
        this.mRecordingStopErrorCause = null;
        this.mAudioErrorCause = null;
        this.mPendingAudioRingBuffer.clear();
        switch (this.mAudioState) {
            case IDLING: {
                throw new AssertionError((Object)"Incorrectly finalize recording when audio state is IDLING");
            }
            case INITIALIZING: {
                break;
            }
            case ACTIVE: 
            case DISABLED: {
                this.setAudioState(AudioState.IDLING);
                break;
            }
            case ERROR: {
                this.setAudioState(AudioState.INITIALIZING);
            }
        }
        this.onRecordingFinalized(finalizedRecording);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRecordingFinalized(@NonNull RecordingRecord finalizedRecording) {
        boolean needsReset = false;
        boolean startRecordingPaused = false;
        RecordingRecord recordingToStart = null;
        RecordingRecord pendingRecordingToFinalize = null;
        int error = 0;
        Exception errorCause = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mActiveRecordingRecord != finalizedRecording) {
                throw new AssertionError((Object)"Active recording did not match finalized recording on finalize.");
            }
            this.mActiveRecordingRecord = null;
            switch (this.mState) {
                case RESETTING: {
                    this.setState(State.INITIALIZING);
                    needsReset = true;
                    break;
                }
                case STOPPING: 
                case RECORDING: 
                case PAUSED: {
                    if (this.mShouldWaitForNewSurface) {
                        this.setState(State.INITIALIZING);
                        break;
                    }
                    this.setState(State.IDLING);
                    break;
                }
                case PENDING_PAUSED: {
                    startRecordingPaused = true;
                }
                case PENDING_RECORDING: {
                    if (this.mSourceState == VideoOutput.SourceState.INACTIVE) {
                        pendingRecordingToFinalize = this.mPendingRecordingRecord;
                        this.mPendingRecordingRecord = null;
                        this.setState(State.INITIALIZING);
                        error = 4;
                        errorCause = PENDING_RECORDING_ERROR_CAUSE_SOURCE_INACTIVE;
                        break;
                    }
                    if (this.mShouldWaitForNewSurface) {
                        this.updateNonPendingState(State.INITIALIZING);
                        break;
                    }
                    recordingToStart = this.makePendingRecordingActiveLocked(this.mState);
                    break;
                }
                case ERROR: {
                    break;
                }
                case INITIALIZING: 
                case IDLING: {
                    throw new AssertionError((Object)("Unexpected state on finalize of recording: " + (Object)((Object)this.mState)));
                }
            }
        }
        if (needsReset) {
            this.resetInternal();
        } else if (recordingToStart != null) {
            if (this.mShouldWaitForNewSurface) {
                throw new AssertionError((Object)"Attempt to start a pending recording while the Recorder is waiting for a new surface request.");
            }
            this.startRecording(recordingToStart, startRecordingPaused);
        } else if (pendingRecordingToFinalize != null) {
            this.finalizePendingRecording(pendingRecordingToFinalize, error, errorCause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onInProgressRecordingInternalError(@NonNull RecordingRecord recording, int error, @Nullable Throwable cause) {
        if (recording != this.mInProgressRecording) {
            throw new AssertionError((Object)"Internal error occurred on recording that is not the current in-progress recording.");
        }
        boolean needsStop = false;
        Object object = this.mLock;
        synchronized (object) {
            switch (this.mState) {
                case RECORDING: 
                case PAUSED: {
                    this.setState(State.STOPPING);
                    needsStop = true;
                }
                case STOPPING: 
                case RESETTING: 
                case PENDING_RECORDING: 
                case PENDING_PAUSED: {
                    if (recording != this.mActiveRecordingRecord) {
                        throw new AssertionError((Object)"Internal error occurred for recording but it is not the active recording.");
                    }
                    break;
                }
                case INITIALIZING: 
                case IDLING: 
                case ERROR: {
                    throw new AssertionError((Object)("In-progress recording error occurred while in unexpected state: " + (Object)((Object)this.mState)));
                }
            }
        }
        if (needsStop) {
            this.stopInternal(recording, null, error, cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryServicePendingRecording() {
        boolean startRecordingPaused = false;
        RecordingRecord recordingToStart = null;
        RecordingRecord pendingRecordingToFinalize = null;
        int error = 0;
        Exception errorCause = null;
        Object object = this.mLock;
        synchronized (object) {
            switch (this.mState) {
                case PENDING_PAUSED: {
                    startRecordingPaused = true;
                }
                case PENDING_RECORDING: {
                    if (this.mActiveRecordingRecord != null) break;
                    if (this.mSourceState == VideoOutput.SourceState.INACTIVE) {
                        pendingRecordingToFinalize = this.mPendingRecordingRecord;
                        this.mPendingRecordingRecord = null;
                        this.restoreNonPendingState();
                        error = 4;
                        errorCause = PENDING_RECORDING_ERROR_CAUSE_SOURCE_INACTIVE;
                        break;
                    }
                    recordingToStart = this.makePendingRecordingActiveLocked(this.mState);
                    break;
                }
            }
        }
        if (recordingToStart != null) {
            this.startRecording(recordingToStart, startRecordingPaused);
        } else if (pendingRecordingToFinalize != null) {
            this.finalizePendingRecording(pendingRecordingToFinalize, error, errorCause);
        }
    }

    @GuardedBy(value="mLock")
    @NonNull
    private RecordingRecord makePendingRecordingActiveLocked(@NonNull State state) {
        boolean startRecordingPaused = false;
        if (state == State.PENDING_PAUSED) {
            startRecordingPaused = true;
        } else if (state != State.PENDING_RECORDING) {
            throw new AssertionError((Object)"makePendingRecordingActiveLocked() can only be called from a pending state.");
        }
        if (this.mActiveRecordingRecord != null) {
            throw new AssertionError((Object)"Cannot make pending recording active because another recording is already active.");
        }
        if (this.mPendingRecordingRecord == null) {
            throw new AssertionError((Object)"Pending recording should exist when in a PENDING state.");
        }
        RecordingRecord recordingToStart = this.mActiveRecordingRecord = this.mPendingRecordingRecord;
        this.mPendingRecordingRecord = null;
        if (startRecordingPaused) {
            this.setState(State.PAUSED);
        } else {
            this.setState(State.RECORDING);
        }
        return recordingToStart;
    }

    private void startRecording(@NonNull RecordingRecord recordingToStart, boolean startRecordingPaused) {
        this.startInternal(recordingToStart);
        if (startRecordingPaused) {
            this.pauseInternal(recordingToStart);
        }
    }

    void updateInProgressStatusEvent() {
        if (this.mInProgressRecording != null) {
            this.mInProgressRecording.updateVideoRecordEvent(VideoRecordEvent.status(this.mInProgressRecording.getOutputOptions(), this.getInProgressRecordingStats()));
        }
    }

    @NonNull
    RecordingStats getInProgressRecordingStats() {
        return RecordingStats.of(this.mRecordingDurationNs, this.mRecordingBytes, AudioStats.of(this.internalAudioStateToAudioStatsState(this.mAudioState), this.mAudioErrorCause));
    }

    <T> T getObservableData(@NonNull StateObservable<T> observable) {
        ListenableFuture future = observable.fetchData();
        try {
            return (T)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    boolean isAudioSupported() {
        return this.getObservableData((StateObservable)this.mMediaSpec).getAudioSpec().getChannelCount() != 0;
    }

    @GuardedBy(value="mLock")
    void setState(@NonNull State state) {
        if (this.mState == state) {
            throw new AssertionError((Object)("Attempted to transition to state " + (Object)((Object)state) + ", but Recorder is already in state " + (Object)((Object)state)));
        }
        Logger.d((String)TAG, (String)("Transitioning Recorder internal state: " + (Object)((Object)this.mState) + " --> " + (Object)((Object)state)));
        StreamInfo.StreamState streamState = null;
        if (PENDING_STATES.contains((Object)state)) {
            if (!PENDING_STATES.contains((Object)this.mState)) {
                if (!VALID_NON_PENDING_STATES_WHILE_PENDING.contains((Object)this.mState)) {
                    throw new AssertionError((Object)("Invalid state transition. Should not be transitioning to a PENDING state from state " + (Object)((Object)this.mState)));
                }
                this.mNonPendingState = this.mState;
                streamState = this.internalStateToStreamState(this.mNonPendingState);
            }
        } else if (this.mNonPendingState != null) {
            this.mNonPendingState = null;
        }
        this.mState = state;
        if (streamState == null) {
            streamState = this.internalStateToStreamState(this.mState);
        }
        this.mStreamInfo.setState((Object)StreamInfo.of(this.mStreamId, streamState));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLatestSurface(@Nullable Surface surface) {
        if (this.mLatestSurface == surface) {
            return;
        }
        this.mLatestSurface = surface;
        Object object = this.mLock;
        synchronized (object) {
            this.setStreamId(surface != null ? surface.hashCode() : 0);
        }
    }

    @GuardedBy(value="mLock")
    private void setStreamId(int streamId) {
        if (this.mStreamId == streamId) {
            return;
        }
        Logger.d((String)TAG, (String)("Transitioning streamId: " + this.mStreamId + " --> " + streamId));
        this.mStreamId = streamId;
        this.mStreamInfo.setState((Object)StreamInfo.of(streamId, this.internalStateToStreamState(this.mState)));
    }

    @GuardedBy(value="mLock")
    private void updateNonPendingState(@NonNull State state) {
        if (!PENDING_STATES.contains((Object)this.mState)) {
            throw new AssertionError((Object)("Can only updated non-pending state from a pending state, but state is " + (Object)((Object)this.mState)));
        }
        if (!VALID_NON_PENDING_STATES_WHILE_PENDING.contains((Object)state)) {
            throw new AssertionError((Object)("Invalid state transition. State is not a valid non-pending state while in a pending state: " + (Object)((Object)state)));
        }
        if (this.mNonPendingState != state) {
            this.mNonPendingState = state;
            this.mStreamInfo.setState((Object)StreamInfo.of(this.mStreamId, this.internalStateToStreamState(state)));
        }
    }

    @GuardedBy(value="mLock")
    private void restoreNonPendingState() {
        if (!PENDING_STATES.contains((Object)this.mState)) {
            throw new AssertionError((Object)("Cannot restore non-pending state when in state " + (Object)((Object)this.mState)));
        }
        this.setState(this.mNonPendingState);
    }

    void setAudioState(AudioState audioState) {
        Logger.d((String)TAG, (String)("Transitioning audio state: " + (Object)((Object)this.mAudioState) + " --> " + (Object)((Object)audioState)));
        this.mAudioState = audioState;
    }

    private static int supportedMuxerFormatOrDefaultFrom(@Nullable CamcorderProfileProxy profileProxy, int defaultMuxerFormat) {
        if (profileProxy != null) {
            switch (profileProxy.getFileFormat()) {
                case 2: {
                    return 0;
                }
                case 9: {
                    return 1;
                }
                case 1: {
                    if (Build.VERSION.SDK_INT < 26) {
                        return 0;
                    }
                    return 2;
                }
            }
        }
        return defaultMuxerFormat;
    }

    @RequiresApi(value=21)
    public static final class Builder {
        private final MediaSpec.Builder mMediaSpecBuilder;
        private Executor mExecutor = null;
        private EncoderFactory mVideoEncoderFactory = DEFAULT_ENCODER_FACTORY;
        private EncoderFactory mAudioEncoderFactory = DEFAULT_ENCODER_FACTORY;

        public Builder() {
            this.mMediaSpecBuilder = MediaSpec.builder();
        }

        @NonNull
        public Builder setExecutor(@NonNull Executor executor) {
            Preconditions.checkNotNull((Object)executor, (Object)"The specified executor can't be null.");
            this.mExecutor = executor;
            return this;
        }

        @NonNull
        public Builder setQualitySelector(@NonNull QualitySelector qualitySelector) {
            Preconditions.checkNotNull((Object)qualitySelector, (Object)"The specified quality selector can't be null.");
            this.mMediaSpecBuilder.configureVideo((Consumer<VideoSpec.Builder>)((Consumer)builder -> builder.setQualitySelector(qualitySelector)));
            return this;
        }

        @NonNull
        Builder setAspectRatio(int aspectRatio) {
            this.mMediaSpecBuilder.configureVideo((Consumer<VideoSpec.Builder>)((Consumer)builder -> builder.setAspectRatio(aspectRatio)));
            return this;
        }

        @NonNull
        Builder setAudioSource(int source) {
            this.mMediaSpecBuilder.configureAudio((Consumer<AudioSpec.Builder>)((Consumer)builder -> builder.setSource(source)));
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NonNull
        Builder setVideoEncoderFactory(@NonNull EncoderFactory videoEncoderFactory) {
            this.mVideoEncoderFactory = videoEncoderFactory;
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NonNull
        Builder setAudioEncoderFactory(@NonNull EncoderFactory audioEncoderFactory) {
            this.mAudioEncoderFactory = audioEncoderFactory;
            return this;
        }

        @NonNull
        public Recorder build() {
            return new Recorder(this.mExecutor, this.mMediaSpecBuilder.build(), this.mVideoEncoderFactory, this.mAudioEncoderFactory);
        }
    }

    @RequiresApi(value=21)
    @AutoValue
    static abstract class RecordingRecord
    implements AutoCloseable {
        private final CloseGuardHelper mCloseGuard = CloseGuardHelper.create();
        private final AtomicBoolean mInitialized = new AtomicBoolean(false);
        private final AtomicReference<MediaMuxerSupplier> mMediaMuxerSupplier = new AtomicReference<Object>(null);
        private final AtomicReference<AudioSourceSupplier> mAudioSourceSupplier = new AtomicReference<Object>(null);
        private final AtomicReference<Consumer<Uri>> mRecordingFinalizer = new AtomicReference<Consumer>(ignored -> {});

        RecordingRecord() {
        }

        @NonNull
        static RecordingRecord from(@NonNull PendingRecording pendingRecording, long recordingId) {
            return new AutoValue_Recorder_RecordingRecord(pendingRecording.getOutputOptions(), pendingRecording.getListenerExecutor(), pendingRecording.getEventListener(), pendingRecording.isAudioEnabled(), recordingId);
        }

        @NonNull
        abstract OutputOptions getOutputOptions();

        @Nullable
        abstract Executor getCallbackExecutor();

        @Nullable
        abstract Consumer<VideoRecordEvent> getEventListener();

        abstract boolean hasAudioEnabled();

        abstract long getRecordingId();

        void initializeRecording(final @NonNull Context context) throws IOException {
            if (this.mInitialized.getAndSet(true)) {
                throw new AssertionError((Object)("Recording " + this + " has already been initialized"));
            }
            OutputOptions outputOptions = this.getOutputOptions();
            ParcelFileDescriptor dupedParcelFileDescriptor = outputOptions instanceof FileDescriptorOutputOptions ? ((FileDescriptorOutputOptions)outputOptions).getParcelFileDescriptor().dup() : null;
            this.mCloseGuard.open("finalizeRecording");
            MediaMuxerSupplier mediaMuxerSupplier = (muxerOutputFormat, outputUriCreatedCallback) -> {
                MediaMuxer mediaMuxer;
                Uri outputUri = Uri.EMPTY;
                if (outputOptions instanceof FileOutputOptions) {
                    FileOutputOptions fileOutputOptions = (FileOutputOptions)outputOptions;
                    File file = fileOutputOptions.getFile();
                    if (!OutputUtil.createParentFolder(file)) {
                        Logger.w((String)Recorder.TAG, (String)("Failed to create folder for " + file.getAbsolutePath()));
                    }
                    mediaMuxer = new MediaMuxer(file.getAbsolutePath(), muxerOutputFormat);
                    outputUri = Uri.fromFile((File)file);
                } else if (outputOptions instanceof FileDescriptorOutputOptions) {
                    if (Build.VERSION.SDK_INT < 26) throw new IOException("MediaMuxer doesn't accept FileDescriptor as output destination.");
                    mediaMuxer = Api26Impl.createMediaMuxer(dupedParcelFileDescriptor.getFileDescriptor(), muxerOutputFormat);
                } else {
                    if (!(outputOptions instanceof MediaStoreOutputOptions)) throw new AssertionError((Object)("Invalid output options type: " + outputOptions.getClass().getSimpleName()));
                    MediaStoreOutputOptions mediaStoreOutputOptions = (MediaStoreOutputOptions)outputOptions;
                    ContentValues contentValues = new ContentValues(mediaStoreOutputOptions.getContentValues());
                    if (Build.VERSION.SDK_INT >= 29) {
                        contentValues.put("is_pending", Integer.valueOf(1));
                    }
                    if ((outputUri = mediaStoreOutputOptions.getContentResolver().insert(mediaStoreOutputOptions.getCollectionUri(), contentValues)) == null) {
                        throw new IOException("Unable to create MediaStore entry.");
                    }
                    if (Build.VERSION.SDK_INT < 26) {
                        String path = OutputUtil.getAbsolutePathFromUri(mediaStoreOutputOptions.getContentResolver(), outputUri, Recorder.MEDIA_COLUMN);
                        if (path == null) {
                            throw new IOException("Unable to get path from uri " + outputUri);
                        }
                        if (!OutputUtil.createParentFolder(new File(path))) {
                            Logger.w((String)Recorder.TAG, (String)("Failed to create folder for " + path));
                        }
                        mediaMuxer = new MediaMuxer(path, muxerOutputFormat);
                    } else {
                        ParcelFileDescriptor fileDescriptor = mediaStoreOutputOptions.getContentResolver().openFileDescriptor(outputUri, "rw");
                        mediaMuxer = Api26Impl.createMediaMuxer(fileDescriptor.getFileDescriptor(), muxerOutputFormat);
                        fileDescriptor.close();
                    }
                }
                outputUriCreatedCallback.accept((Object)outputUri);
                return mediaMuxer;
            };
            this.mMediaMuxerSupplier.set(mediaMuxerSupplier);
            Consumer recordingFinalizer = null;
            if (this.hasAudioEnabled()) {
                AudioSourceSupplier audioSourceSupplier;
                if (Build.VERSION.SDK_INT >= 31) {
                    audioSourceSupplier = new AudioSourceSupplier(){

                        @Override
                        @NonNull
                        @RequiresPermission(value="android.permission.RECORD_AUDIO")
                        public AudioSource get(@NonNull AudioSource.Settings settings, @NonNull Executor executor) throws AudioSourceAccessException {
                            return new AudioSource(settings, executor, context);
                        }
                    };
                    this.mAudioSourceSupplier.set(audioSourceSupplier);
                } else {
                    audioSourceSupplier = new AudioSourceSupplier(){

                        @Override
                        @NonNull
                        @RequiresPermission(value="android.permission.RECORD_AUDIO")
                        public AudioSource get(@NonNull AudioSource.Settings settings, @NonNull Executor executor) throws AudioSourceAccessException {
                            return new AudioSource(settings, executor, null);
                        }
                    };
                    this.mAudioSourceSupplier.set(audioSourceSupplier);
                }
            }
            if (outputOptions instanceof MediaStoreOutputOptions) {
                MediaStoreOutputOptions mediaStoreOutputOptions = (MediaStoreOutputOptions)outputOptions;
                recordingFinalizer = Build.VERSION.SDK_INT >= 29 ? outputUri -> {
                    if (outputUri.equals((Object)Uri.EMPTY)) {
                        return;
                    }
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("is_pending", Integer.valueOf(0));
                    mediaStoreOutputOptions.getContentResolver().update(outputUri, contentValues, null, null);
                } : outputUri -> {
                    if (outputUri.equals((Object)Uri.EMPTY)) {
                        return;
                    }
                    String filePath = OutputUtil.getAbsolutePathFromUri(mediaStoreOutputOptions.getContentResolver(), outputUri, Recorder.MEDIA_COLUMN);
                    if (filePath != null) {
                        MediaScannerConnection.scanFile((Context)context, (String[])new String[]{filePath}, null, (path, uri) -> {
                            if (uri == null) {
                                Logger.e((String)Recorder.TAG, (String)String.format("File scanning operation failed [path: %s]", path));
                            } else {
                                Logger.d((String)Recorder.TAG, (String)String.format("File scan completed successfully [path: %s, URI: %s]", path, uri));
                            }
                        });
                    } else {
                        Logger.d((String)Recorder.TAG, (String)("Skipping media scanner scan. Unable to retrieve file path from URI: " + outputUri));
                    }
                };
            } else if (outputOptions instanceof FileDescriptorOutputOptions) {
                recordingFinalizer = ignored -> {
                    try {
                        dupedParcelFileDescriptor.close();
                    }
                    catch (IOException e) {
                        Logger.e((String)Recorder.TAG, (String)"Failed to close dup'd ParcelFileDescriptor", (Throwable)e);
                    }
                };
            }
            if (recordingFinalizer != null) {
                this.mRecordingFinalizer.set((Consumer<Uri>)recordingFinalizer);
            }
        }

        void updateVideoRecordEvent(@NonNull VideoRecordEvent event) {
            VideoRecordEvent.Finalize finalizeEvent;
            if (!Objects.equals(event.getOutputOptions(), this.getOutputOptions())) {
                throw new AssertionError((Object)("Attempted to update event listener with event from incorrect recording [Recording: " + event.getOutputOptions() + ", Expected: " + this.getOutputOptions() + "]"));
            }
            String message = "Sending VideoRecordEvent " + event.getClass().getSimpleName();
            if (event instanceof VideoRecordEvent.Finalize && (finalizeEvent = (VideoRecordEvent.Finalize)event).hasError()) {
                message = message + String.format(" [error: %s]", VideoRecordEvent.Finalize.errorToString(finalizeEvent.getError()));
            }
            Logger.d((String)Recorder.TAG, (String)message);
            if (this.getCallbackExecutor() != null && this.getEventListener() != null) {
                try {
                    this.getCallbackExecutor().execute(() -> this.getEventListener().accept((Object)event));
                }
                catch (RejectedExecutionException e) {
                    Logger.e((String)Recorder.TAG, (String)"The callback executor is invalid.", (Throwable)e);
                }
            }
        }

        @NonNull
        @RequiresPermission(value="android.permission.RECORD_AUDIO")
        AudioSource performOneTimeAudioSourceCreation(@NonNull AudioSource.Settings settings, @NonNull Executor audioSourceExecutor) throws AudioSourceAccessException {
            if (!this.hasAudioEnabled()) {
                throw new AssertionError((Object)("Recording does not have audio enabled. Unable to create audio source for recording " + this));
            }
            AudioSourceSupplier audioSourceSupplier = this.mAudioSourceSupplier.getAndSet(null);
            if (audioSourceSupplier == null) {
                throw new AssertionError((Object)("One-time audio source creation has already occurred for recording " + this));
            }
            return audioSourceSupplier.get(settings, audioSourceExecutor);
        }

        @NonNull
        MediaMuxer performOneTimeMediaMuxerCreation(int muxerOutputFormat, @NonNull Consumer<Uri> outputUriCreatedCallback) throws IOException {
            if (!this.mInitialized.get()) {
                throw new AssertionError((Object)("Recording " + this + " has not been initialized"));
            }
            MediaMuxerSupplier mediaMuxerSupplier = this.mMediaMuxerSupplier.getAndSet(null);
            if (mediaMuxerSupplier == null) {
                throw new AssertionError((Object)("One-time media muxer creation has already occurred for recording " + this));
            }
            return mediaMuxerSupplier.get(muxerOutputFormat, outputUriCreatedCallback);
        }

        void finalizeRecording(@NonNull Uri uri) {
            if (!this.mInitialized.get()) {
                return;
            }
            this.finalizeRecordingInternal((Consumer<Uri>)((Consumer)this.mRecordingFinalizer.getAndSet(null)), uri);
        }

        @Override
        public void close() {
            this.finalizeRecording(Uri.EMPTY);
        }

        protected void finalize() throws Throwable {
            try {
                this.mCloseGuard.warnIfOpen();
                Consumer finalizer = this.mRecordingFinalizer.getAndSet(null);
                if (finalizer != null) {
                    this.finalizeRecordingInternal((Consumer<Uri>)finalizer, Uri.EMPTY);
                }
            }
            finally {
                super.finalize();
            }
        }

        private void finalizeRecordingInternal(@Nullable Consumer<Uri> finalizer, @NonNull Uri uri) {
            if (finalizer == null) {
                throw new AssertionError((Object)("Recording " + this + " has already been finalized"));
            }
            this.mCloseGuard.close();
            finalizer.accept((Object)uri);
        }

        private static interface AudioSourceSupplier {
            @RequiresPermission(value="android.permission.RECORD_AUDIO")
            @NonNull
            public AudioSource get(@NonNull AudioSource.Settings var1, @NonNull Executor var2) throws AudioSourceAccessException;
        }

        private static interface MediaMuxerSupplier {
            @NonNull
            public MediaMuxer get(int var1, @NonNull Consumer<Uri> var2) throws IOException;
        }
    }

    static enum AudioState {
        INITIALIZING,
        IDLING,
        DISABLED,
        ACTIVE,
        ERROR;

    }

    static enum State {
        INITIALIZING,
        PENDING_RECORDING,
        PENDING_PAUSED,
        IDLING,
        RECORDING,
        PAUSED,
        STOPPING,
        RESETTING,
        ERROR;

    }
}

