/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.os.Build;
import android.util.Pair;
import android.util.Size;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.impl.CameraEventCallback;
import androidx.camera.camera2.impl.CameraEventCallbacks;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.ExtendableBuilder;
import androidx.camera.core.Logger;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.ImageInfoProcessor;
import androidx.camera.core.impl.PreviewConfig;
import androidx.camera.extensions.impl.CaptureStageImpl;
import androidx.camera.extensions.impl.PreviewExtenderImpl;
import androidx.camera.extensions.impl.PreviewImageProcessorImpl;
import androidx.camera.extensions.internal.AdaptingCaptureStage;
import androidx.camera.extensions.internal.AdaptingPreviewProcessor;
import androidx.camera.extensions.internal.AdaptingRequestUpdateProcessor;
import androidx.camera.extensions.internal.BasicVendorExtender;
import androidx.camera.extensions.internal.CloseableProcessor;
import androidx.camera.extensions.internal.VendorExtender;
import java.util.List;

@RequiresApi(value=21)
public class PreviewConfigProvider
implements ConfigProvider<PreviewConfig> {
    private static final String TAG = "PreviewConfigProvider";
    static final Config.Option<Integer> OPTION_PREVIEW_CONFIG_PROVIDER_MODE = Config.Option.create((String)"camerax.extensions.previewConfigProvider.mode", Integer.class);
    private final VendorExtender mVendorExtender;
    private final Context mContext;
    private final int mEffectMode;

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    public PreviewConfigProvider(int mode, @NonNull VendorExtender vendorExtender, @NonNull Context context) {
        this.mEffectMode = mode;
        this.mVendorExtender = vendorExtender;
        this.mContext = context;
    }

    @NonNull
    public PreviewConfig getConfig() {
        Preview.Builder builder = new Preview.Builder();
        this.updateBuilderConfig(builder, this.mEffectMode, this.mVendorExtender, this.mContext);
        return builder.getUseCaseConfig();
    }

    void updateBuilderConfig(@NonNull Preview.Builder builder, int effectMode, @NonNull VendorExtender vendorExtender, @NonNull Context context) {
        if (vendorExtender instanceof BasicVendorExtender) {
            PreviewExtenderImpl previewExtenderImpl = ((BasicVendorExtender)vendorExtender).getPreviewExtenderImpl();
            if (previewExtenderImpl != null) {
                PreviewEventAdapter previewEventAdapter;
                switch (previewExtenderImpl.getProcessorType()) {
                    case PROCESSOR_TYPE_REQUEST_UPDATE_ONLY: {
                        AdaptingRequestUpdateProcessor adaptingRequestUpdateProcessor = new AdaptingRequestUpdateProcessor(previewExtenderImpl);
                        builder.setImageInfoProcessor((ImageInfoProcessor)adaptingRequestUpdateProcessor);
                        previewEventAdapter = new PreviewEventAdapter(previewExtenderImpl, context, adaptingRequestUpdateProcessor);
                        break;
                    }
                    case PROCESSOR_TYPE_IMAGE_PROCESSOR: {
                        AdaptingPreviewProcessor adaptingPreviewProcessor = new AdaptingPreviewProcessor((PreviewImageProcessorImpl)previewExtenderImpl.getProcessor());
                        builder.setCaptureProcessor((CaptureProcessor)adaptingPreviewProcessor);
                        builder.setIsRgba8888SurfaceRequired(true);
                        previewEventAdapter = new PreviewEventAdapter(previewExtenderImpl, context, adaptingPreviewProcessor);
                        break;
                    }
                    default: {
                        previewEventAdapter = new PreviewEventAdapter(previewExtenderImpl, context, null);
                    }
                }
                new Camera2ImplConfig.Extender((ExtendableBuilder)builder).setCameraEventCallback(new CameraEventCallbacks(new CameraEventCallback[]{previewEventAdapter}));
                builder.setUseCaseEventCallback((UseCase.EventCallback)previewEventAdapter);
            } else {
                Logger.e((String)TAG, (String)"PreviewExtenderImpl is null!");
            }
        } else {
            builder.setIsRgba8888SurfaceRequired(true);
        }
        builder.getMutableConfig().insertOption(OPTION_PREVIEW_CONFIG_PROVIDER_MODE, (Object)effectMode);
        List<Pair<Integer, Size[]>> supportedResolutions = vendorExtender.getSupportedPreviewOutputResolutions();
        builder.setSupportedResolutions(supportedResolutions);
    }

    private static class PreviewEventAdapter
    extends CameraEventCallback
    implements UseCase.EventCallback {
        @NonNull
        final PreviewExtenderImpl mImpl;
        @NonNull
        private final Context mContext;
        final CloseableProcessor mCloseableProcessor;
        @GuardedBy(value="mLock")
        volatile boolean mActive = true;
        final Object mLock = new Object();
        @GuardedBy(value="mLock")
        private volatile int mEnabledSessionCount = 0;
        @GuardedBy(value="mLock")
        private volatile boolean mUnbind = false;

        PreviewEventAdapter(@NonNull PreviewExtenderImpl impl, @NonNull Context context, @Nullable CloseableProcessor closeableProcessor) {
            this.mImpl = impl;
            this.mContext = context;
            this.mCloseableProcessor = closeableProcessor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @OptIn(markerClass={ExperimentalCamera2Interop.class})
        public void onAttach(@NonNull CameraInfo cameraInfo) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mActive) {
                    String cameraId = Camera2CameraInfo.from((CameraInfo)cameraInfo).getCameraId();
                    CameraCharacteristics cameraCharacteristics = Camera2CameraInfo.extractCameraCharacteristics((CameraInfo)cameraInfo);
                    this.mImpl.onInit(cameraId, cameraCharacteristics, this.mContext);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDetach() {
            Object object = this.mLock;
            synchronized (object) {
                this.mUnbind = true;
                if (this.mEnabledSessionCount == 0) {
                    this.callDeInit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void callDeInit() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mActive) {
                    if (this.mCloseableProcessor != null) {
                        this.mCloseableProcessor.close();
                    }
                    this.mImpl.onDeInit();
                    this.mActive = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public CaptureConfig onPresetSession() {
            Object object = this.mLock;
            synchronized (object) {
                CaptureStageImpl captureStageImpl = this.mImpl.onPresetSession();
                if (captureStageImpl != null) {
                    if (Build.VERSION.SDK_INT >= 28) {
                        return new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                    }
                    Logger.w((String)PreviewConfigProvider.TAG, (String)"The CaptureRequest parameters returned from onPresetSession() will be passed to the camera device as part of the capture session via SessionConfiguration#setSessionParameters(CaptureRequest) which only supported from API level 28!");
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Nullable
        public CaptureConfig onEnableSession() {
            Object object;
            block12: {
                CaptureConfig captureConfig;
                try {
                    CaptureStageImpl captureStageImpl;
                    object = this.mLock;
                    // MONITORENTER : object
                    if (!this.mActive || (captureStageImpl = this.mImpl.onEnableSession()) == null) break block12;
                    captureConfig = new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                    // MONITOREXIT : object
                    Object object2 = this.mLock;
                }
                catch (Throwable throwable) {
                    Object object3 = this.mLock;
                    // MONITORENTER : object3
                    ++this.mEnabledSessionCount;
                    // MONITOREXIT : object3
                    throw throwable;
                }
                ++this.mEnabledSessionCount;
                // MONITOREXIT : object2
                return captureConfig;
            }
            // MONITOREXIT : object
            object = null;
            Object object4 = this.mLock;
            ++this.mEnabledSessionCount;
            // MONITOREXIT : object4
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Nullable
        public CaptureConfig onDisableSession() {
            Object object;
            block15: {
                CaptureConfig captureConfig;
                try {
                    CaptureStageImpl captureStageImpl;
                    object = this.mLock;
                    // MONITORENTER : object
                    if (!this.mActive || (captureStageImpl = this.mImpl.onDisableSession()) == null) break block15;
                    captureConfig = new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                    // MONITOREXIT : object
                    Object object2 = this.mLock;
                }
                catch (Throwable throwable) {
                    Object object3 = this.mLock;
                    // MONITORENTER : object3
                    --this.mEnabledSessionCount;
                    if (this.mEnabledSessionCount == 0 && this.mUnbind) {
                        this.callDeInit();
                    }
                    // MONITOREXIT : object3
                    throw throwable;
                }
                --this.mEnabledSessionCount;
                if (this.mEnabledSessionCount == 0 && this.mUnbind) {
                    this.callDeInit();
                }
                // MONITOREXIT : object2
                return captureConfig;
            }
            // MONITOREXIT : object
            object = null;
            Object object4 = this.mLock;
            --this.mEnabledSessionCount;
            if (this.mEnabledSessionCount == 0 && this.mUnbind) {
                this.callDeInit();
            }
            // MONITOREXIT : object4
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public CaptureConfig onRepeating() {
            Object object = this.mLock;
            synchronized (object) {
                CaptureStageImpl captureStageImpl;
                if (this.mActive && (captureStageImpl = this.mImpl.getCaptureStage()) != null) {
                    return new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                }
            }
            return null;
        }
    }
}

