/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraFilter;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.Identifier;
import androidx.camera.extensions.internal.VendorExtender;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RequiresApi(value=21)
final class ExtensionCameraFilter
implements CameraFilter {
    private final Identifier mId;
    private final VendorExtender mVendorExtender;

    ExtensionCameraFilter(@NonNull String filterId, @NonNull VendorExtender vendorExtender) {
        this.mId = Identifier.create((Object)filterId);
        this.mVendorExtender = vendorExtender;
    }

    @NonNull
    public Identifier getIdentifier() {
        return this.mId;
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    @NonNull
    public List<CameraInfo> filter(@NonNull List<CameraInfo> cameraInfos) {
        ArrayList<CameraInfo> result = new ArrayList<CameraInfo>();
        for (CameraInfo cameraInfo : cameraInfos) {
            Map cameraCharacteristicsMap;
            Preconditions.checkArgument((boolean)(cameraInfo instanceof CameraInfoInternal), (Object)"The camera info doesn't contain internal implementation.");
            String cameraId = Camera2CameraInfo.from((CameraInfo)cameraInfo).getCameraId();
            if (!this.mVendorExtender.isExtensionAvailable(cameraId, cameraCharacteristicsMap = Camera2CameraInfo.from((CameraInfo)cameraInfo).getCameraCharacteristicsMap())) continue;
            result.add(cameraInfo);
        }
        return result;
    }
}

