/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.workaround;

import android.hardware.camera2.CaptureRequest;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.compat.quirk.DeviceQuirks;
import androidx.camera.camera2.internal.compat.quirk.PreviewPixelHDRnetQuirk;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.SessionConfig;

public class PreviewPixelHDRnet {
    public static final Rational ASPECT_RATIO_16_9 = new Rational(16, 9);

    private PreviewPixelHDRnet() {
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    public static void setHDRnet(@NonNull Size resolution, @NonNull SessionConfig.Builder sessionBuilder) {
        PreviewPixelHDRnetQuirk quirk = DeviceQuirks.get(PreviewPixelHDRnetQuirk.class);
        if (quirk == null) {
            return;
        }
        if (PreviewPixelHDRnet.isAspectRatioMatch(resolution, ASPECT_RATIO_16_9)) {
            return;
        }
        Camera2ImplConfig.Builder camera2ConfigBuilder = new Camera2ImplConfig.Builder();
        camera2ConfigBuilder.setCaptureRequestOption(CaptureRequest.TONEMAP_MODE, 2);
        sessionBuilder.addImplementationOptions((Config)camera2ConfigBuilder.build());
    }

    private static boolean isAspectRatioMatch(@NonNull Size resolution, @NonNull Rational aspectRatio) {
        return aspectRatio.equals((Object)new Rational(resolution.getWidth(), resolution.getHeight()));
    }
}

