/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraCharacteristics;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.internal.CameraUnavailableExceptionHelper;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.core.InitializationException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CameraIdUtil {
    private CameraIdUtil() {
    }

    public static boolean isBackwardCompatible(@NonNull CameraManagerCompat cameraManagerCompat, @NonNull String cameraId) throws InitializationException {
        int[] availableCapabilities;
        if ("robolectric".equals(Build.FINGERPRINT)) {
            return true;
        }
        try {
            availableCapabilities = (int[])cameraManagerCompat.getCameraCharacteristicsCompat(cameraId).get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        }
        catch (CameraAccessExceptionCompat e) {
            throw new InitializationException((Throwable)CameraUnavailableExceptionHelper.createFrom(e));
        }
        if (availableCapabilities != null) {
            for (int capability : availableCapabilities) {
                if (capability != 0) continue;
                return true;
            }
        }
        return false;
    }
}

