/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraDevice;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class CameraDeviceStateCallbacks {
    private CameraDeviceStateCallbacks() {
    }

    @NonNull
    public static CameraDevice.StateCallback createNoOpCallback() {
        return new NoOpDeviceStateCallback();
    }

    @NonNull
    public static CameraDevice.StateCallback createComboCallback(@NonNull List<CameraDevice.StateCallback> callbacks) {
        if (callbacks.isEmpty()) {
            return CameraDeviceStateCallbacks.createNoOpCallback();
        }
        if (callbacks.size() == 1) {
            return callbacks.get(0);
        }
        return new ComboDeviceStateCallback(callbacks);
    }

    @NonNull
    public static CameraDevice.StateCallback createComboCallback(CameraDevice.StateCallback ... callbacks) {
        return CameraDeviceStateCallbacks.createComboCallback(Arrays.asList(callbacks));
    }

    static final class NoOpDeviceStateCallback
    extends CameraDevice.StateCallback {
        NoOpDeviceStateCallback() {
        }

        public void onOpened(@NonNull CameraDevice cameraDevice) {
        }

        public void onClosed(@NonNull CameraDevice cameraDevice) {
        }

        public void onDisconnected(@NonNull CameraDevice cameraDevice) {
        }

        public void onError(@NonNull CameraDevice cameraDevice, int error) {
        }
    }

    private static final class ComboDeviceStateCallback
    extends CameraDevice.StateCallback {
        private final List<CameraDevice.StateCallback> mCallbacks = new ArrayList<CameraDevice.StateCallback>();

        ComboDeviceStateCallback(@NonNull List<CameraDevice.StateCallback> callbacks) {
            for (CameraDevice.StateCallback callback : callbacks) {
                if (callback instanceof NoOpDeviceStateCallback) continue;
                this.mCallbacks.add(callback);
            }
        }

        public void onOpened(@NonNull CameraDevice cameraDevice) {
            for (CameraDevice.StateCallback callback : this.mCallbacks) {
                callback.onOpened(cameraDevice);
            }
        }

        public void onClosed(@NonNull CameraDevice cameraDevice) {
            for (CameraDevice.StateCallback callback : this.mCallbacks) {
                callback.onClosed(cameraDevice);
            }
        }

        public void onDisconnected(@NonNull CameraDevice cameraDevice) {
            for (CameraDevice.StateCallback callback : this.mCallbacks) {
                callback.onDisconnected(cameraDevice);
            }
        }

        public void onError(@NonNull CameraDevice cameraDevice, int error) {
            for (CameraDevice.StateCallback callback : this.mCallbacks) {
                callback.onError(cameraDevice, error);
            }
        }
    }
}

