/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.workaround;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.internal.SynchronizedCaptureSession;
import androidx.camera.camera2.internal.compat.quirk.CaptureSessionOnClosedNotCalledQuirk;
import androidx.camera.core.impl.Quirks;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ForceCloseCaptureSession {
    @Nullable
    private final CaptureSessionOnClosedNotCalledQuirk mCaptureSessionOnClosedNotCalledQuirk;

    public ForceCloseCaptureSession(@NonNull Quirks deviceQuirks) {
        this.mCaptureSessionOnClosedNotCalledQuirk = (CaptureSessionOnClosedNotCalledQuirk)deviceQuirks.get(CaptureSessionOnClosedNotCalledQuirk.class);
    }

    public boolean shouldForceClose() {
        return this.mCaptureSessionOnClosedNotCalledQuirk != null;
    }

    public void onSessionConfigured(@NonNull SynchronizedCaptureSession session, @NonNull List<SynchronizedCaptureSession> creatingSessions, @NonNull List<SynchronizedCaptureSession> sessions, @NonNull OnConfigured onConfigured) {
        if (this.shouldForceClose()) {
            LinkedHashSet<SynchronizedCaptureSession> staleCreatingSessions = new LinkedHashSet<SynchronizedCaptureSession>();
            for (SynchronizedCaptureSession s : creatingSessions) {
                if (s == session) break;
                staleCreatingSessions.add(s);
            }
            this.forceOnConfigureFailed(staleCreatingSessions);
        }
        onConfigured.run(session);
        if (this.shouldForceClose()) {
            LinkedHashSet<SynchronizedCaptureSession> openedSessions = new LinkedHashSet<SynchronizedCaptureSession>();
            for (SynchronizedCaptureSession s : sessions) {
                if (s == session) break;
                openedSessions.add(s);
            }
            this.forceOnClosed(openedSessions);
        }
    }

    private void forceOnConfigureFailed(@NonNull Set<SynchronizedCaptureSession> sessions) {
        for (SynchronizedCaptureSession session : sessions) {
            session.getStateCallback().onConfigureFailed(session);
        }
    }

    private void forceOnClosed(@NonNull Set<SynchronizedCaptureSession> sessions) {
        for (SynchronizedCaptureSession session : sessions) {
            session.getStateCallback().onClosed(session);
        }
    }

    @FunctionalInterface
    public static interface OnConfigured {
        public void run(@NonNull SynchronizedCaptureSession var1);
    }
}

