/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import androidx.camera.core.Logger;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\bJ\u0006\u0010\f\u001a\u00020\bJ\u0006\u0010\r\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/camera/camera2/internal/VideoUsageControl;", "", "executor", "Ljava/util/concurrent/Executor;", "(Ljava/util/concurrent/Executor;)V", "mVideoUsage", "Ljava/util/concurrent/atomic/AtomicInteger;", "decrementUsage", "", "getUsage", "", "incrementUsage", "reset", "resetDirectly", "camera-camera2_release"})
public final class VideoUsageControl {
    @NotNull
    private final Executor executor;
    @NotNull
    private final AtomicInteger mVideoUsage;

    public VideoUsageControl(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.executor = executor;
        this.mVideoUsage = new AtomicInteger(0);
    }

    public final void incrementUsage() {
        this.executor.execute(() -> VideoUsageControl.incrementUsage$lambda$0(this));
    }

    public final void decrementUsage() {
        this.executor.execute(() -> VideoUsageControl.decrementUsage$lambda$1(this));
    }

    public final void reset() {
        this.executor.execute(() -> VideoUsageControl.reset$lambda$2(this));
    }

    public final void resetDirectly() {
        this.mVideoUsage.set(0);
        Logger.d((String)"VideoUsageControl", (String)"resetDirectly: mVideoUsage reset!");
    }

    public final int getUsage() {
        return this.mVideoUsage.get();
    }

    private static final void incrementUsage$lambda$0(VideoUsageControl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int currentVal = this$0.mVideoUsage.incrementAndGet();
        Logger.d((String)"VideoUsageControl", (String)("incrementUsage: mVideoUsage = " + currentVal));
    }

    private static final void decrementUsage$lambda$1(VideoUsageControl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int currentVal = this$0.mVideoUsage.decrementAndGet();
        if (currentVal < 0) {
            Logger.w((String)"VideoUsageControl", (String)("decrementUsage: mVideoUsage = " + currentVal + ", which is less than 0!"));
        } else {
            Logger.d((String)"VideoUsageControl", (String)("decrementUsage: mVideoUsage = " + currentVal));
        }
    }

    private static final void reset$lambda$2(VideoUsageControl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.resetDirectly();
    }
}

