/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.concurrent;

import android.hardware.camera2.CameraCharacteristics;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.Logger;
import androidx.camera.core.concurrent.CameraCoordinator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@RequiresApi(value=21)
public class Camera2CameraCoordinator
implements CameraCoordinator {
    private static final String TAG = "Camera2CameraCoordinator";
    @NonNull
    private final CameraManagerCompat mCameraManager;
    @NonNull
    private final List<CameraCoordinator.ConcurrentCameraModeListener> mConcurrentCameraModeListeners;
    @NonNull
    private final Map<String, List<String>> mConcurrentCameraIdMap;
    @NonNull
    private List<CameraInfo> mActiveConcurrentCameraInfos;
    @NonNull
    private Set<Set<String>> mConcurrentCameraIds;
    private int mCameraOperatingMode = 0;

    public Camera2CameraCoordinator(@NonNull CameraManagerCompat cameraManager) {
        this.mCameraManager = cameraManager;
        this.mConcurrentCameraIdMap = new HashMap<String, List<String>>();
        this.mConcurrentCameraIds = new HashSet<Set<String>>();
        this.mConcurrentCameraModeListeners = new ArrayList<CameraCoordinator.ConcurrentCameraModeListener>();
        this.mActiveConcurrentCameraInfos = new ArrayList<CameraInfo>();
        this.retrieveConcurrentCameraIds();
    }

    @NonNull
    public List<List<CameraSelector>> getConcurrentCameraSelectors() {
        ArrayList<List<CameraSelector>> concurrentCameraSelectorLists = new ArrayList<List<CameraSelector>>();
        for (Set<String> concurrentCameraIdList : this.mConcurrentCameraIds) {
            ArrayList<CameraSelector> cameraSelectors = new ArrayList<CameraSelector>();
            for (String concurrentCameraId : concurrentCameraIdList) {
                cameraSelectors.add(Camera2CameraCoordinator.createCameraSelectorById(this.mCameraManager, concurrentCameraId));
            }
            concurrentCameraSelectorLists.add(cameraSelectors);
        }
        return concurrentCameraSelectorLists;
    }

    @NonNull
    public List<CameraInfo> getActiveConcurrentCameraInfos() {
        return this.mActiveConcurrentCameraInfos;
    }

    public void setActiveConcurrentCameraInfos(@NonNull List<CameraInfo> cameraInfos) {
        this.mActiveConcurrentCameraInfos = new ArrayList<CameraInfo>(cameraInfos);
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    @Nullable
    public String getPairedConcurrentCameraId(@NonNull String cameraId) {
        if (!this.mConcurrentCameraIdMap.containsKey(cameraId)) {
            return null;
        }
        for (String pairedCameraId : this.mConcurrentCameraIdMap.get(cameraId)) {
            for (CameraInfo cameraInfo : this.mActiveConcurrentCameraInfos) {
                if (!pairedCameraId.equals(Camera2CameraInfo.from(cameraInfo).getCameraId())) continue;
                return pairedCameraId;
            }
        }
        return null;
    }

    public int getCameraOperatingMode() {
        return this.mCameraOperatingMode;
    }

    public void setCameraOperatingMode(int cameraOperatingMode) {
        if (cameraOperatingMode != this.mCameraOperatingMode) {
            for (CameraCoordinator.ConcurrentCameraModeListener listener : this.mConcurrentCameraModeListeners) {
                listener.onCameraOperatingModeUpdated(this.mCameraOperatingMode, cameraOperatingMode);
            }
        }
        if (this.mCameraOperatingMode == 2 && cameraOperatingMode != 2) {
            this.mActiveConcurrentCameraInfos.clear();
        }
        this.mCameraOperatingMode = cameraOperatingMode;
    }

    public void addListener(@NonNull CameraCoordinator.ConcurrentCameraModeListener listener) {
        this.mConcurrentCameraModeListeners.add(listener);
    }

    public void removeListener(@NonNull CameraCoordinator.ConcurrentCameraModeListener listener) {
        this.mConcurrentCameraModeListeners.remove(listener);
    }

    public void shutdown() {
        this.mConcurrentCameraModeListeners.clear();
        this.mConcurrentCameraIdMap.clear();
        this.mActiveConcurrentCameraInfos.clear();
        this.mConcurrentCameraIds.clear();
        this.mCameraOperatingMode = 0;
    }

    private void retrieveConcurrentCameraIds() {
        try {
            this.mConcurrentCameraIds = this.mCameraManager.getConcurrentCameraIds();
        }
        catch (CameraAccessExceptionCompat e) {
            Logger.e((String)TAG, (String)"Failed to get concurrent camera ids");
        }
        for (Set<String> concurrentCameraIdList : this.mConcurrentCameraIds) {
            ArrayList<String> cameraIdList = new ArrayList<String>(concurrentCameraIdList);
            if (cameraIdList.size() < 2) continue;
            String cameraId1 = (String)cameraIdList.get(0);
            String cameraId2 = (String)cameraIdList.get(1);
            if (!this.mConcurrentCameraIdMap.containsKey(cameraId1)) {
                this.mConcurrentCameraIdMap.put(cameraId1, new ArrayList());
            }
            if (!this.mConcurrentCameraIdMap.containsKey(cameraId2)) {
                this.mConcurrentCameraIdMap.put(cameraId2, new ArrayList());
            }
            this.mConcurrentCameraIdMap.get(cameraId1).add((String)cameraIdList.get(1));
            this.mConcurrentCameraIdMap.get(cameraId2).add((String)cameraIdList.get(0));
        }
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    private static CameraSelector createCameraSelectorById(@NonNull CameraManagerCompat cameraManager, @NonNull String cameraId) {
        CameraSelector.Builder builder = new CameraSelector.Builder().addCameraFilter(cameraInfos -> {
            for (CameraInfo cameraInfo : cameraInfos) {
                if (!cameraId.equals(Camera2CameraInfo.from(cameraInfo).getCameraId())) continue;
                return Collections.singletonList(cameraInfo);
            }
            throw new IllegalArgumentException("No camera can be find for id: " + cameraId);
        });
        try {
            CameraCharacteristicsCompat cameraCharacteristics = cameraManager.getCameraCharacteristicsCompat(cameraId);
            Integer cameraLensFacing = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
            builder.requireLensFacing(cameraLensFacing.intValue());
        }
        catch (CameraAccessExceptionCompat e) {
            throw new RuntimeException(e);
        }
        return builder.build();
    }
}

